/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import zipkin2.Annotation;
import zipkin2.DependencyLink;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.internal.Nullable;

final class JsonAdapters {
    static final JsonAdapter<Span> SPAN_ADAPTER = new JsonAdapter<Span>(){

        public Span fromJson(JsonReader reader) throws IOException {
            Span.Builder result = Span.newBuilder();
            reader.beginObject();
            block30: while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (reader.peek() == JsonReader.Token.NULL) {
                    reader.skipValue();
                    continue;
                }
                switch (nextName) {
                    case "traceId": {
                        result.traceId(reader.nextString());
                        continue block30;
                    }
                    case "parentId": {
                        result.parentId(reader.nextString());
                        continue block30;
                    }
                    case "id": {
                        result.id(reader.nextString());
                        continue block30;
                    }
                    case "kind": {
                        result.kind(Span.Kind.valueOf((String)reader.nextString()));
                        continue block30;
                    }
                    case "name": {
                        result.name(reader.nextString());
                        continue block30;
                    }
                    case "timestamp": {
                        result.timestamp(Long.valueOf(reader.nextLong()));
                        continue block30;
                    }
                    case "duration": {
                        result.duration(Long.valueOf(reader.nextLong()));
                        continue block30;
                    }
                    case "localEndpoint": {
                        result.localEndpoint((Endpoint)ENDPOINT_ADAPTER.fromJson(reader));
                        continue block30;
                    }
                    case "remoteEndpoint": {
                        result.remoteEndpoint((Endpoint)ENDPOINT_ADAPTER.fromJson(reader));
                        continue block30;
                    }
                    case "annotations": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            Annotation a = (Annotation)ANNOTATION_ADAPTER.fromJson(reader);
                            result.addAnnotation(a.timestamp(), a.value());
                        }
                        reader.endArray();
                        continue block30;
                    }
                    case "tags": {
                        reader.beginObject();
                        while (reader.hasNext()) {
                            result.putTag(reader.nextName(), reader.nextString());
                        }
                        reader.endObject();
                        continue block30;
                    }
                    case "debug": {
                        result.debug(Boolean.valueOf(reader.nextBoolean()));
                        continue block30;
                    }
                    case "shared": {
                        result.shared(Boolean.valueOf(reader.nextBoolean()));
                        continue block30;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return result.build();
        }

        public void toJson(JsonWriter writer, @Nullable Span value) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    static final JsonAdapter<Annotation> ANNOTATION_ADAPTER = new JsonAdapter<Annotation>(){

        public Annotation fromJson(JsonReader reader) throws IOException {
            reader.beginObject();
            Long timestamp = null;
            String value = null;
            block8: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "timestamp": {
                        timestamp = reader.nextLong();
                        continue block8;
                    }
                    case "value": {
                        value = reader.nextString();
                        continue block8;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (timestamp == null || value == null) {
                throw new IllegalStateException("Incomplete annotation at " + reader.getPath());
            }
            return Annotation.create((long)timestamp, value);
        }

        public void toJson(JsonWriter writer, @Nullable Annotation value) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    static final JsonAdapter<Endpoint> ENDPOINT_ADAPTER = new JsonAdapter<Endpoint>(){

        public Endpoint fromJson(JsonReader reader) throws IOException {
            reader.beginObject();
            String serviceName = null;
            String ipv4 = null;
            String ipv6 = null;
            Integer port = null;
            block12: while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (reader.peek() == JsonReader.Token.NULL) {
                    reader.skipValue();
                    continue;
                }
                switch (nextName) {
                    case "serviceName": {
                        serviceName = reader.nextString();
                        continue block12;
                    }
                    case "ipv4": {
                        ipv4 = reader.nextString();
                        continue block12;
                    }
                    case "ipv6": {
                        ipv6 = reader.nextString();
                        continue block12;
                    }
                    case "port": {
                        port = reader.nextInt();
                        continue block12;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (serviceName == null && ipv4 == null && ipv6 == null && port == null) {
                throw new IllegalStateException("Incomplete endpoint at " + reader.getPath());
            }
            return Endpoint.newBuilder().serviceName(serviceName).ip(ipv4).ip(ipv6).port(port).build();
        }

        public void toJson(JsonWriter writer, @Nullable Endpoint value) throws IOException {
            throw new UnsupportedOperationException();
        }
    }.nullSafe();
    static final JsonAdapter<DependencyLink> DEPENDENCY_LINK_ADAPTER = new JsonAdapter<DependencyLink>(){

        public DependencyLink fromJson(JsonReader reader) throws IOException {
            DependencyLink.Builder result = DependencyLink.newBuilder();
            reader.beginObject();
            block12: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "parent": {
                        result.parent(reader.nextString());
                        continue block12;
                    }
                    case "child": {
                        result.child(reader.nextString());
                        continue block12;
                    }
                    case "callCount": {
                        result.callCount(reader.nextLong());
                        continue block12;
                    }
                    case "errorCount": {
                        result.errorCount(reader.nextLong());
                        continue block12;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return result.build();
        }

        public void toJson(JsonWriter writer, @Nullable DependencyLink value) throws IOException {
            throw new UnsupportedOperationException();
        }
    };

    JsonAdapters() {
    }
}

