/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch;

import com.google.auto.value.AutoValue;
import com.squareup.moshi.JsonReader;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSource;
import zipkin2.CheckResult;
import zipkin2.elasticsearch.$AutoValue_ElasticsearchStorage;
import zipkin2.elasticsearch.BodyConverters;
import zipkin2.elasticsearch.ElasticsearchSpanConsumer;
import zipkin2.elasticsearch.ElasticsearchSpanStore;
import zipkin2.elasticsearch.EnsureIndexTemplate;
import zipkin2.elasticsearch.IndexTemplates;
import zipkin2.elasticsearch.PseudoAddressRecordSet;
import zipkin2.elasticsearch.VersionSpecificTemplates;
import zipkin2.elasticsearch.internal.IndexNameFormatter;
import zipkin2.elasticsearch.internal.JsonReaders;
import zipkin2.elasticsearch.internal.client.HttpCall;
import zipkin2.internal.Nullable;
import zipkin2.internal.Platform;
import zipkin2.storage.SpanConsumer;
import zipkin2.storage.SpanStore;
import zipkin2.storage.StorageComponent;

@AutoValue
public abstract class ElasticsearchStorage
extends StorageComponent {
    static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");

    public static Builder newBuilder(OkHttpClient client) {
        return new $AutoValue_ElasticsearchStorage.Builder().client(client).hosts(Collections.singletonList("http://localhost:9200")).maxRequests(64).strictTraceId(true).index("zipkin").dateSeparator('-').indexShards(5).indexReplicas(1).namesLookback(86400000).shutdownClientOnClose(false).flushOnWrites(false);
    }

    public static Builder newBuilder() {
        Builder result = ElasticsearchStorage.newBuilder(new OkHttpClient());
        result.shutdownClientOnClose(true);
        return result;
    }

    abstract Builder toBuilder();

    abstract OkHttpClient client();

    abstract boolean shutdownClientOnClose();

    public abstract HostsSupplier hostsSupplier();

    @Nullable
    public abstract String pipeline();

    public abstract boolean flushOnWrites();

    public abstract int maxRequests();

    public abstract boolean strictTraceId();

    abstract int indexShards();

    abstract int indexReplicas();

    public abstract IndexNameFormatter indexNameFormatter();

    public abstract int namesLookback();

    public SpanStore spanStore() {
        this.ensureIndexTemplates();
        return new ElasticsearchSpanStore(this);
    }

    public SpanConsumer spanConsumer() {
        this.ensureIndexTemplates();
        return new ElasticsearchSpanConsumer(this);
    }

    public float version() {
        return this.ensureIndexTemplates().version();
    }

    public void clear() throws IOException {
        LinkedHashSet<String> toClear = new LinkedHashSet<String>();
        toClear.add(this.indexNameFormatter().formatType("span"));
        toClear.add(this.indexNameFormatter().formatType("dependency"));
        for (String index : toClear) {
            this.clear(index);
        }
    }

    void clear(String index) throws IOException {
        Request deleteRequest = new Request.Builder().url(this.http().baseUrl.newBuilder().addPathSegment(index).build()).delete().tag((Object)"delete-index").build();
        this.http().newCall(deleteRequest, BodyConverters.NULL).execute();
        ElasticsearchStorage.flush(this.http(), index);
    }

    public static void flush(HttpCall.Factory factory, String index) throws IOException {
        Request flushRequest = new Request.Builder().url(factory.baseUrl.newBuilder().addPathSegment(index).addPathSegment("_flush").build()).post(RequestBody.create((MediaType)APPLICATION_JSON, (String)"")).tag((Object)"flush-index").build();
        factory.newCall(flushRequest, BodyConverters.NULL).execute();
    }

    public CheckResult check() {
        return this.ensureClusterReady(this.indexNameFormatter().formatType("span"));
    }

    CheckResult ensureClusterReady(String index) {
        Request request = new Request.Builder().url(this.http().baseUrl.resolve("/_cluster/health/" + index)).tag((Object)"get-cluster-health").build();
        try {
            return this.http().newCall(request, ReadStatus.INSTANCE).execute();
        }
        catch (IOException | RuntimeException e) {
            return CheckResult.failed((Throwable)e);
        }
    }

    IndexTemplates ensureIndexTemplates() {
        String index = this.indexNameFormatter().index();
        try {
            IndexTemplates templates = new VersionSpecificTemplates(this).get(this.http());
            EnsureIndexTemplate.apply(this.http(), index + ":" + "span" + "_template", templates.span());
            EnsureIndexTemplate.apply(this.http(), index + ":" + "dependency" + "_template", templates.dependency());
            return templates;
        }
        catch (IOException e) {
            throw Platform.get().uncheckedIOException(e);
        }
    }

    public HttpCall.Factory http() {
        List<String> hosts = this.hostsSupplier().get();
        if (hosts.isEmpty()) {
            throw new IllegalArgumentException("no hosts configured");
        }
        OkHttpClient ok = hosts.size() == 1 ? this.client() : this.client().newBuilder().dns(PseudoAddressRecordSet.create(hosts, this.client().dns())).build();
        ok.dispatcher().setMaxRequests(this.maxRequests());
        ok.dispatcher().setMaxRequestsPerHost(this.maxRequests());
        return new HttpCall.Factory(ok, HttpUrl.parse((String)hosts.get(0)));
    }

    public void close() {
        if (!this.shutdownClientOnClose()) {
            return;
        }
        this.http().close();
    }

    ElasticsearchStorage() {
    }

    static enum ReadStatus implements HttpCall.BodyConverter<CheckResult>
    {
        INSTANCE;


        @Override
        public CheckResult convert(BufferedSource b) throws IOException {
            b.request(Long.MAX_VALUE);
            Buffer body = b.buffer();
            JsonReader status = JsonReaders.enterPath(JsonReader.of((BufferedSource)body.clone()), "status");
            if (status == null) {
                throw new IllegalStateException("Health status couldn't be read " + body.readUtf8());
            }
            if ("RED".equalsIgnoreCase(status.nextString())) {
                throw new IllegalStateException("Health status is RED");
            }
            return CheckResult.OK;
        }

        public String toString() {
            return "ReadStatus";
        }
    }

    public static abstract class Builder
    extends StorageComponent.Builder {
        abstract Builder client(OkHttpClient var1);

        public abstract Builder shutdownClientOnClose(boolean var1);

        public final Builder hosts(final List<String> hosts) {
            if (hosts == null) {
                throw new NullPointerException("hosts == null");
            }
            return this.hostsSupplier(new HostsSupplier(){

                @Override
                public List<String> get() {
                    return hosts;
                }

                public String toString() {
                    return hosts.toString();
                }
            });
        }

        public abstract Builder hostsSupplier(HostsSupplier var1);

        public abstract Builder maxRequests(int var1);

        public abstract Builder pipeline(String var1);

        public abstract Builder namesLookback(int var1);

        public abstract Builder flushOnWrites(boolean var1);

        public final Builder index(String index) {
            this.indexNameFormatterBuilder().index(index);
            return this;
        }

        public final Builder dateSeparator(char dateSeparator) {
            this.indexNameFormatterBuilder().dateSeparator(dateSeparator);
            return this;
        }

        public abstract Builder indexShards(int var1);

        public abstract Builder indexReplicas(int var1);

        public abstract Builder strictTraceId(boolean var1);

        public abstract ElasticsearchStorage build();

        abstract IndexNameFormatter.Builder indexNameFormatterBuilder();

        Builder() {
        }
    }

    public static interface HostsSupplier {
        public List<String> get();
    }
}

