/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch;

import com.squareup.moshi.JsonReader;
import java.io.IOException;
import java.util.List;
import okio.BufferedSource;
import zipkin2.DependencyLink;
import zipkin2.Span;
import zipkin2.elasticsearch.JsonAdapters;
import zipkin2.elasticsearch.internal.JsonReaders;
import zipkin2.elasticsearch.internal.client.HttpCall;
import zipkin2.elasticsearch.internal.client.SearchResultConverter;
import zipkin2.internal.DependencyLinker;

public final class BodyConverters {
    static final HttpCall.BodyConverter<Object> NULL = new HttpCall.BodyConverter<Object>(){

        @Override
        public Object convert(BufferedSource content) throws IOException {
            return null;
        }
    };
    static final HttpCall.BodyConverter<List<String>> KEYS = new HttpCall.BodyConverter<List<String>>(){

        @Override
        public List<String> convert(BufferedSource b) throws IOException {
            return JsonReaders.collectValuesNamed(JsonReader.of((BufferedSource)b), "key");
        }
    };
    static final HttpCall.BodyConverter<List<Span>> SPANS = SearchResultConverter.create(JsonAdapters.SPAN_ADAPTER);
    static final HttpCall.BodyConverter<List<DependencyLink>> DEPENDENCY_LINKS = new SearchResultConverter<DependencyLink>(JsonAdapters.DEPENDENCY_LINK_ADAPTER){

        @Override
        public List<DependencyLink> convert(BufferedSource content) throws IOException {
            Object result = super.convert(content);
            return result.isEmpty() ? result : DependencyLinker.merge((Iterable)result);
        }
    };
}

