/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch;

import com.fasterxml.jackson.core.JsonParser;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.linecorp.armeria.client.ResponseTimeoutException;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpMethod;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import zipkin2.Call;
import zipkin2.CheckResult;
import zipkin2.elasticsearch.$AutoValue_ElasticsearchStorage;
import zipkin2.elasticsearch.BodyConverters;
import zipkin2.elasticsearch.ElasticsearchAutocompleteTags;
import zipkin2.elasticsearch.ElasticsearchSpanConsumer;
import zipkin2.elasticsearch.ElasticsearchSpanStore;
import zipkin2.elasticsearch.ElasticsearchVersion;
import zipkin2.elasticsearch.EnsureIndexTemplate;
import zipkin2.elasticsearch.IndexTemplates;
import zipkin2.elasticsearch.VersionSpecificTemplates;
import zipkin2.elasticsearch.internal.IndexNameFormatter;
import zipkin2.elasticsearch.internal.Internal;
import zipkin2.elasticsearch.internal.JsonReaders;
import zipkin2.elasticsearch.internal.client.HttpCall;
import zipkin2.internal.Nullable;
import zipkin2.storage.AutocompleteTags;
import zipkin2.storage.ServiceAndSpanNames;
import zipkin2.storage.SpanConsumer;
import zipkin2.storage.SpanStore;
import zipkin2.storage.StorageComponent;
import zipkin2.storage.Traces;

@AutoValue
public abstract class ElasticsearchStorage
extends StorageComponent {
    volatile boolean ensuredTemplates;
    static final HttpCall.BodyConverter<CheckResult> READ_STATUS;

    public static Builder newBuilder(LazyHttpClient lazyHttpClient) {
        return new $AutoValue_ElasticsearchStorage.Builder().lazyHttpClient(lazyHttpClient).strictTraceId(true).searchEnabled(true).index("zipkin").dateSeparator('-').indexShards(5).indexReplicas(1).ensureTemplates(true).namesLookback(86400000).flushOnWrites(false).autocompleteKeys(Collections.emptyList()).autocompleteTtl((int)TimeUnit.HOURS.toMillis(1L)).autocompleteCardinality(20000);
    }

    abstract Builder toBuilder();

    abstract LazyHttpClient lazyHttpClient();

    @Nullable
    public abstract String pipeline();

    public abstract boolean flushOnWrites();

    public abstract boolean strictTraceId();

    abstract boolean searchEnabled();

    abstract List<String> autocompleteKeys();

    abstract int autocompleteTtl();

    abstract int autocompleteCardinality();

    abstract int indexShards();

    abstract int indexReplicas();

    public abstract IndexNameFormatter indexNameFormatter();

    abstract boolean ensureTemplates();

    public abstract int namesLookback();

    @Nullable
    abstract Integer templatePriority();

    public SpanStore spanStore() {
        this.ensureIndexTemplates();
        return new ElasticsearchSpanStore(this);
    }

    public Traces traces() {
        return (Traces)this.spanStore();
    }

    public ServiceAndSpanNames serviceAndSpanNames() {
        return (ServiceAndSpanNames)this.spanStore();
    }

    public AutocompleteTags autocompleteTags() {
        this.ensureIndexTemplates();
        return new ElasticsearchAutocompleteTags(this);
    }

    public SpanConsumer spanConsumer() {
        this.ensureIndexTemplates();
        return new ElasticsearchSpanConsumer(this);
    }

    @Memoized
    public ElasticsearchVersion version() {
        try {
            return ElasticsearchVersion.get(this.http());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    char indexTypeDelimiter() {
        return VersionSpecificTemplates.indexTypeDelimiter(this.version());
    }

    public void clear() throws IOException {
        LinkedHashSet<String> toClear = new LinkedHashSet<String>();
        toClear.add(this.indexNameFormatter().formatType("span"));
        toClear.add(this.indexNameFormatter().formatType("dependency"));
        for (String index : toClear) {
            this.clear(index);
        }
    }

    void clear(String index) throws IOException {
        String url = "/" + index;
        AggregatedHttpRequest delete = AggregatedHttpRequest.of((HttpMethod)HttpMethod.DELETE, (String)url);
        this.http().newCall(delete, BodyConverters.NULL, "delete-index").execute();
    }

    public boolean isOverCapacity(Throwable e) {
        return e instanceof RejectedExecutionException || e instanceof ResponseTimeoutException;
    }

    public CheckResult check() {
        return this.ensureIndexTemplatesAndClusterReady(this.indexNameFormatter().formatType("span"));
    }

    CheckResult ensureIndexTemplatesAndClusterReady(String index) {
        try {
            this.version();
            this.ensureIndexTemplates();
            AggregatedHttpRequest request = AggregatedHttpRequest.of((HttpMethod)HttpMethod.GET, (String)("/_cluster/health/" + index));
            CheckResult result = (CheckResult)this.http().newCall(request, READ_STATUS, "get-cluster-health").execute();
            if (result == null) {
                throw new IllegalArgumentException("No content reading cluster health");
            }
            return result;
        }
        catch (Throwable e) {
            Call.propagateIfFatal((Throwable)e);
            if (e instanceof RejectedExecutionException || e instanceof UncheckedIOException) {
                e = e.getCause();
            }
            return CheckResult.failed((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureIndexTemplates() {
        if (this.ensuredTemplates) {
            return;
        }
        if (!this.ensureTemplates()) {
            this.ensuredTemplates = true;
        }
        ElasticsearchStorage elasticsearchStorage = this;
        synchronized (elasticsearchStorage) {
            if (this.ensuredTemplates) {
                return;
            }
            this.doEnsureIndexTemplates();
            this.ensuredTemplates = true;
        }
    }

    IndexTemplates doEnsureIndexTemplates() {
        try {
            HttpCall.Factory http = this.http();
            IndexTemplates templates = this.versionSpecificTemplates(this.version());
            EnsureIndexTemplate.ensureIndexTemplate(http, this.buildUrl(templates, "span"), templates.span());
            EnsureIndexTemplate.ensureIndexTemplate(http, this.buildUrl(templates, "dependency"), templates.dependency());
            EnsureIndexTemplate.ensureIndexTemplate(http, this.buildUrl(templates, "autocomplete"), templates.autocomplete());
            return templates;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    IndexTemplates versionSpecificTemplates(ElasticsearchVersion version) {
        return new VersionSpecificTemplates(this.indexNameFormatter().index(), this.indexReplicas(), this.indexShards(), this.searchEnabled(), this.strictTraceId(), this.templatePriority()).get(version);
    }

    String buildUrl(IndexTemplates templates, String type) {
        String indexPrefix = this.indexNameFormatter().index() + templates.indexTypeDelimiter();
        if (this.version().compareTo(ElasticsearchVersion.V7_8) >= 0 && this.templatePriority() != null) {
            return "/_index_template/" + indexPrefix + type + "_template";
        }
        if (this.version().compareTo(ElasticsearchVersion.V6_7) >= 0 && this.version().compareTo(ElasticsearchVersion.V7_0) < 0) {
            return "/_template/" + indexPrefix + type + "_template?include_type_name=true";
        }
        return "/_template/" + indexPrefix + type + "_template";
    }

    public final String toString() {
        return "ElasticsearchStorage{initialEndpoints=" + this.lazyHttpClient() + ", index=" + this.indexNameFormatter().index() + "}";
    }

    @Memoized
    HttpCall.Factory http() {
        return new HttpCall.Factory(this.lazyHttpClient().get());
    }

    public void close() {
        this.lazyHttpClient().close();
    }

    ElasticsearchStorage() {
    }

    static {
        Internal.instance = new Internal(){

            @Override
            public HttpCall.Factory http(ElasticsearchStorage storage) {
                return storage.http();
            }
        };
        READ_STATUS = new HttpCall.BodyConverter<CheckResult>(){

            @Override
            public CheckResult convert(JsonParser parser, Supplier<String> contentString) throws IOException {
                JsonParser status = JsonReaders.enterPath(parser, "status");
                if (status == null) {
                    throw new IllegalArgumentException("Health status couldn't be read " + contentString.get());
                }
                if ("RED".equalsIgnoreCase(status.getText())) {
                    return CheckResult.failed((Throwable)new IllegalStateException("Health status is RED"));
                }
                return CheckResult.OK;
            }

            public String toString() {
                return "ReadStatus";
            }
        };
    }

    public static interface LazyHttpClient
    extends Supplier<WebClient>,
    Closeable {
        @Override
        public WebClient get();

        @Override
        default public void close() {
        }

        public String toString();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends StorageComponent.Builder {
        public abstract Builder pipeline(String var1);

        public abstract Builder namesLookback(int var1);

        public abstract Builder flushOnWrites(boolean var1);

        public final Builder index(String index) {
            this.indexNameFormatterBuilder().index(index);
            return this;
        }

        public final Builder dateSeparator(char dateSeparator) {
            this.indexNameFormatterBuilder().dateSeparator(dateSeparator);
            return this;
        }

        public abstract Builder indexShards(int var1);

        public abstract Builder indexReplicas(int var1);

        public abstract Builder ensureTemplates(boolean var1);

        public abstract Builder templatePriority(@Nullable Integer var1);

        public abstract Builder strictTraceId(boolean var1);

        public abstract Builder searchEnabled(boolean var1);

        public abstract Builder autocompleteKeys(List<String> var1);

        public abstract Builder autocompleteTtl(int var1);

        public abstract Builder autocompleteCardinality(int var1);

        public abstract ElasticsearchStorage build();

        abstract Builder lazyHttpClient(LazyHttpClient var1);

        abstract IndexNameFormatter.Builder indexNameFormatterBuilder();

        Builder() {
        }
    }
}

