/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import zipkin2.elasticsearch.internal.client.Aggregation;
import zipkin2.internal.Nullable;

public final class SearchRequest {
    static final int MAX_RESULT_WINDOW = 10000;
    final transient List<String> indices;
    @Nullable
    final transient String type;
    Integer size = 10000;
    Boolean _source;
    Object query;
    Map<String, Aggregation> aggs;

    public static SearchRequest create(List<String> indices) {
        return new SearchRequest(indices, null);
    }

    public static SearchRequest create(List<String> indices, String type) {
        return new SearchRequest(indices, type);
    }

    SearchRequest(List<String> indices, @Nullable String type) {
        this.indices = indices;
        this.type = type;
    }

    public SearchRequest filters(Filters filters) {
        return this.query(new BoolQuery("must", filters));
    }

    public SearchRequest term(String field, String value) {
        return this.query(new Term(field, value));
    }

    public SearchRequest terms(String field, Collection<String> values) {
        return this.query(new Terms(field, values));
    }

    public SearchRequest addAggregation(Aggregation agg) {
        this.size = null;
        this._source = false;
        if (this.aggs == null) {
            this.aggs = new LinkedHashMap<String, Aggregation>();
        }
        this.aggs.put(agg.field, agg);
        return this;
    }

    public Integer getSize() {
        return this.size;
    }

    public Boolean get_source() {
        return this._source;
    }

    public Object getQuery() {
        return this.query;
    }

    public Map<String, Aggregation> getAggs() {
        return this.aggs;
    }

    String tag() {
        return this.aggs != null ? "aggregation" : "search";
    }

    SearchRequest query(Object filter) {
        this.query = Collections.singletonMap("bool", Collections.singletonMap("filter", filter));
        return this;
    }

    static class BoolQuery {
        final Map<String, Object> bool;

        BoolQuery(String op, Object clause) {
            this.bool = Collections.singletonMap(op, clause);
        }

        public Map<String, Object> getBool() {
            return this.bool;
        }
    }

    static class Term {
        final Map<String, String> term;

        Term(String field, String value) {
            this.term = Collections.singletonMap(field, value);
        }

        public Map<String, String> getTerm() {
            return this.term;
        }
    }

    static class Terms {
        final Map<String, Collection<String>> terms;

        Terms(String field, Collection<String> values) {
            this.terms = Collections.singletonMap(field, values);
        }

        public Map<String, Collection<String>> getTerms() {
            return this.terms;
        }
    }

    static class Range {
        final Map<String, Bounds> range;

        Range(String field, long from, Long to) {
            this.range = Collections.singletonMap(field, new Bounds(from, to));
        }

        public Map<String, Bounds> getRange() {
            return this.range;
        }

        static class Bounds {
            final long from;
            final Long to;
            final boolean include_lower = true;
            final boolean include_upper = true;

            Bounds(long from, Long to) {
                this.from = from;
                this.to = to;
            }

            public long getFrom() {
                return this.from;
            }

            public Long getTo() {
                return this.to;
            }

            @JsonProperty(value="include_lower")
            public boolean isIncludeLower() {
                return true;
            }

            @JsonProperty(value="include_upper")
            public boolean isIncludeUpper() {
                return true;
            }
        }
    }

    public static class Filters
    extends ArrayList<Object> {
        public Filters addRange(String field, long from, Long to) {
            this.add(new Range(field, from, to));
            return this;
        }

        public Filters addTerm(String field, String value) {
            this.add(new Term(field, value));
            return this;
        }
    }
}

