/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch;

import java.util.List;
import zipkin2.Call;
import zipkin2.elasticsearch.BodyConverters;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.internal.IndexNameFormatter;
import zipkin2.elasticsearch.internal.client.Aggregation;
import zipkin2.elasticsearch.internal.client.SearchCallFactory;
import zipkin2.elasticsearch.internal.client.SearchRequest;
import zipkin2.storage.AutocompleteTags;

final class ElasticsearchAutocompleteTags
implements AutocompleteTags {
    final boolean enabled;
    final IndexNameFormatter indexNameFormatter;
    final SearchCallFactory search;
    final int namesLookback;
    final Call<List<String>> keysCall;

    ElasticsearchAutocompleteTags(ElasticsearchStorage es) {
        this.search = new SearchCallFactory(es.http());
        this.indexNameFormatter = es.indexNameFormatter();
        this.enabled = es.searchEnabled() && !es.autocompleteKeys().isEmpty();
        this.namesLookback = es.namesLookback();
        this.keysCall = Call.create(es.autocompleteKeys());
    }

    public Call<List<String>> getKeys() {
        if (!this.enabled) {
            return Call.emptyList();
        }
        return this.keysCall.clone();
    }

    public Call<List<String>> getValues(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("key was empty");
        }
        if (!this.enabled) {
            return Call.emptyList();
        }
        long endMillis = System.currentTimeMillis();
        long beginMillis = endMillis - (long)this.namesLookback;
        List<String> indices = this.indexNameFormatter.formatTypeAndRange("autocomplete", beginMillis, endMillis);
        if (indices.isEmpty()) {
            return Call.emptyList();
        }
        SearchRequest.Filters filters = new SearchRequest.Filters().addTerm("tagKey", key);
        SearchRequest request = SearchRequest.create(indices).filters(filters).addAggregation(Aggregation.terms("tagValue", Integer.MAX_VALUE));
        return this.search.newCall(request, BodyConverters.KEYS);
    }
}

