/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import zipkin2.elasticsearch.internal.JsonReaders;
import zipkin2.elasticsearch.internal.JsonSerializers;
import zipkin2.elasticsearch.internal.client.HttpCall;

public class SearchResultConverter<T>
implements HttpCall.BodyConverter<List<T>> {
    final JsonSerializers.ObjectParser<T> adapter;

    public static <T> SearchResultConverter<T> create(JsonSerializers.ObjectParser<T> adapter) {
        return new SearchResultConverter<T>(adapter);
    }

    protected SearchResultConverter(JsonSerializers.ObjectParser<T> adapter) {
        this.adapter = adapter;
    }

    @Override
    public List<T> convert(JsonParser parser, Supplier<String> contentString) throws IOException {
        JsonParser hits = JsonReaders.enterPath(parser, "hits", "hits");
        if (hits == null || !hits.isExpectedStartArrayToken()) {
            return List.of();
        }
        ArrayList<T> result = new ArrayList<T>();
        while (hits.nextToken() != JsonToken.END_ARRAY) {
            JsonParser source = JsonReaders.enterPath(hits, "_source");
            if (source == null) continue;
            result.add(this.adapter.parse(source));
        }
        return result.isEmpty() ? List.of() : result;
    }
}

