/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.auto.value.AutoValue;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpRequestWriter;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.util.Exceptions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.codec.http.QueryStringEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import zipkin2.Call;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.ElasticsearchVersion;
import zipkin2.elasticsearch.internal.AutoValue_BulkCallBuilder_IndexEntry;
import zipkin2.elasticsearch.internal.BulkIndexWriter;
import zipkin2.elasticsearch.internal.Internal;
import zipkin2.elasticsearch.internal.JsonSerializers;
import zipkin2.elasticsearch.internal.client.HttpCall;

public final class BulkCallBuilder {
    static final HttpCall.BodyConverter<Void> CHECK_FOR_ERRORS = new HttpCall.BodyConverter<Void>(){

        @Override
        public Void convert(JsonParser parser, Supplier<String> contentString) {
            RuntimeException toThrow = null;
            try {
                Number status;
                JsonNode root = (JsonNode)JsonSerializers.OBJECT_MAPPER.readTree(parser);
                if (!root.at("/errors").booleanValue() && !root.at("/error").isObject()) {
                    return null;
                }
                String message = HttpCall.maybeRootCauseReason(root);
                if (message == null) {
                    message = contentString.get();
                }
                toThrow = (status = root.findPath("status").numberValue()) != null && status.intValue() == 429 ? new RejectedExecutionException(message) : new RuntimeException(message);
            }
            catch (IOException | RuntimeException exception) {
                // empty catch block
            }
            if (toThrow != null) {
                throw toThrow;
            }
            return null;
        }

        public String toString() {
            return "CheckForErrors";
        }
    };
    final String tag;
    final boolean shouldAddType;
    final HttpCall.Factory http;
    final String pipeline;
    final boolean waitForRefresh;
    final List<IndexEntry<?>> entries = new ArrayList();

    public BulkCallBuilder(ElasticsearchStorage es, ElasticsearchVersion version, String tag) {
        this.tag = tag;
        this.shouldAddType = version.compareTo(ElasticsearchVersion.V7_0) < 0;
        this.http = Internal.instance.http(es);
        this.pipeline = es.pipeline();
        this.waitForRefresh = es.flushOnWrites();
    }

    static <T> IndexEntry<T> newIndexEntry(String index, String typeName, T input, BulkIndexWriter<T> writer) {
        return new AutoValue_BulkCallBuilder_IndexEntry<T>(index, typeName, input, writer);
    }

    public <T> void index(String index, String typeName, T input, BulkIndexWriter<T> writer) {
        this.entries.add(BulkCallBuilder.newIndexEntry(index, typeName, input, writer));
    }

    public HttpCall<Void> build() {
        QueryStringEncoder urlBuilder = new QueryStringEncoder("/_bulk");
        if (this.pipeline != null) {
            urlBuilder.addParam("pipeline", this.pipeline);
        }
        if (this.waitForRefresh) {
            urlBuilder.addParam("refresh", "wait_for");
        }
        ByteBufAllocator alloc = (ByteBufAllocator)RequestContext.mapCurrent(RequestContext::alloc, () -> PooledByteBufAllocator.DEFAULT);
        BulkRequestSupplier request = new BulkRequestSupplier(this.entries, this.shouldAddType, RequestHeaders.of((HttpMethod)HttpMethod.POST, (String)urlBuilder.toString(), (CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)MediaType.JSON_UTF_8), alloc);
        return this.http.newCall(request, CHECK_FOR_ERRORS, this.tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> ByteBuf serialize(ByteBufAllocator alloc, IndexEntry<T> entry, boolean shouldAddType) {
        ByteBuf document = alloc.heapBuffer(600);
        ByteBuf metadata = alloc.heapBuffer(200);
        try {
            String id = entry.writer().writeDocument(entry.input(), new ByteBufOutputStream(document));
            BulkCallBuilder.writeIndexMetadata(new ByteBufOutputStream(metadata), entry, id, shouldAddType);
            ByteBuf payload = alloc.ioBuffer(document.readableBytes() + metadata.readableBytes() + 2);
            try {
                payload.writeBytes(metadata).writeByte(10).writeBytes(document).writeByte(10);
            }
            catch (Throwable t) {
                payload.release();
                Call.propagateIfFatal((Throwable)t);
                Exceptions.throwUnsafely((Throwable)t);
            }
            ByteBuf byteBuf = payload;
            return byteBuf;
        }
        finally {
            document.release();
            metadata.release();
        }
    }

    static <T> void writeIndexMetadata(ByteBufOutputStream sink, IndexEntry<T> entry, String id, boolean shouldAddType) {
        try (JsonGenerator writer = JsonSerializers.jsonGenerator((OutputStream)sink);){
            writer.writeStartObject();
            writer.writeObjectFieldStart("index");
            writer.writeStringField("_index", entry.index());
            if (shouldAddType) {
                writer.writeStringField("_type", entry.typeName());
            }
            writer.writeStringField("_id", id);
            writer.writeEndObject();
            writer.writeEndObject();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @AutoValue
    static abstract class IndexEntry<T> {
        IndexEntry() {
        }

        abstract String index();

        abstract String typeName();

        abstract T input();

        abstract BulkIndexWriter<T> writer();
    }

    static class BulkRequestSupplier
    implements HttpCall.RequestSupplier {
        final List<IndexEntry<?>> entries;
        final boolean shouldAddType;
        final RequestHeaders headers;
        final ByteBufAllocator alloc;

        BulkRequestSupplier(List<IndexEntry<?>> entries, boolean shouldAddType, RequestHeaders headers, ByteBufAllocator alloc) {
            this.entries = List.copyOf(entries);
            this.shouldAddType = shouldAddType;
            this.headers = headers;
            this.alloc = alloc;
        }

        @Override
        public RequestHeaders headers() {
            return this.headers;
        }

        @Override
        public HttpRequest get() {
            HttpRequestWriter writer = HttpRequest.streaming((RequestHeaders)this.headers);
            this.writeEntry(writer, 0);
            return writer;
        }

        private void writeEntry(HttpRequestWriter writer, int index) {
            if (index == this.entries.size()) {
                writer.close();
                return;
            }
            if (!writer.tryWrite((Object)HttpData.wrap((ByteBuf)BulkCallBuilder.serialize(this.alloc, this.entries.get(index), this.shouldAddType)))) {
                return;
            }
            writer.whenConsumed().thenRun(() -> this.writeEntry(writer, index + 1));
        }
    }
}

