/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal;

import com.google.auto.value.AutoValue;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import zipkin2.elasticsearch.internal.AutoValue_IndexNameFormatter;
import zipkin2.internal.DateUtil;
import zipkin2.internal.Nullable;

@AutoValue
public abstract class IndexNameFormatter {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    public static Builder newBuilder() {
        return new AutoValue_IndexNameFormatter.Builder();
    }

    public abstract Builder toBuilder();

    public abstract String index();

    abstract char dateSeparator();

    abstract DateTimeFormatter dateFormat();

    public List<String> formatTypeAndRange(@Nullable String type, long beginMillis, long endMillis) {
        GregorianCalendar current = IndexNameFormatter.midnightUTC(beginMillis);
        GregorianCalendar end = IndexNameFormatter.midnightUTC(endMillis);
        String prefix = this.prefix(type);
        ArrayList<String> indices = new ArrayList<String>();
        while (current.compareTo(end) <= 0) {
            if (current.get(2) == 0 && current.get(5) == 1) {
                current.set(6, current.getActualMaximum(6));
                if (current.compareTo(end) <= 0) {
                    indices.add(String.format("%s-%s%c*", prefix, current.get(1), Character.valueOf(this.dateSeparator())));
                    current.add(5, 1);
                    continue;
                }
                current.set(6, 1);
            } else if (current.get(5) == 1) {
                current.set(5, current.getActualMaximum(5));
                if (current.compareTo(end) <= 0) {
                    indices.add(this.formatIndexPattern("%s-%s%c%02d%c*", current, prefix));
                    current.add(5, 1);
                    continue;
                }
                current.set(5, 9);
                if (current.compareTo(end) <= 0) {
                    indices.add(this.formatIndexPattern("%s-%s%c%02d%c0*", current, prefix));
                    current.add(5, 1);
                    continue;
                }
                current.set(5, 1);
            } else if (current.get(5) == 10) {
                current.set(5, 19);
                if (current.compareTo(end) <= 0) {
                    indices.add(this.formatIndexPattern("%s-%s%c%02d%c1*", current, prefix));
                    current.add(5, 1);
                    continue;
                }
                current.set(5, 10);
            } else if (current.get(5) == 20) {
                current.set(5, 29);
                if (current.compareTo(end) <= 0) {
                    indices.add(this.formatIndexPattern("%s-%s%c%02d%c2*", current, prefix));
                    current.add(5, 1);
                    continue;
                }
                current.set(5, 20);
            }
            indices.add(this.formatTypeAndTimestamp(type, current.getTimeInMillis()));
            current.add(5, 1);
        }
        return indices;
    }

    String formatIndexPattern(String format, GregorianCalendar current, String prefix) {
        return String.format(format, prefix, current.get(1), Character.valueOf(this.dateSeparator()), current.get(2) + 1, Character.valueOf(this.dateSeparator()));
    }

    static GregorianCalendar midnightUTC(long epochMillis) {
        GregorianCalendar result = new GregorianCalendar(UTC);
        result.setTimeInMillis(DateUtil.midnightUTC((long)epochMillis));
        return result;
    }

    public String formatTypeAndTimestampForInsert(String type, char indexTypeDelimiter, long timestampMillis) {
        return this.index() + indexTypeDelimiter + type + "-" + this.format(timestampMillis);
    }

    public String formatTypeAndTimestamp(@Nullable String type, long timestampMillis) {
        return this.prefix(type) + "-" + this.format(timestampMillis);
    }

    private String prefix(@Nullable String type) {
        return type != null ? this.index() + "*" + type : this.index();
    }

    public String formatType(@Nullable String type) {
        return this.prefix(type) + "-*";
    }

    String format(long timestampMillis) {
        return this.dateFormat().format(LocalDateTime.ofInstant(Instant.ofEpochMilli(timestampMillis), ZoneOffset.UTC));
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder index(String var1);

        public abstract Builder dateSeparator(char var1);

        abstract Builder dateFormat(DateTimeFormatter var1);

        abstract char dateSeparator();

        public final IndexNameFormatter build() {
            char separator = this.dateSeparator();
            String format = separator == '\u0000' ? "yyyyMMdd" : "yyyy-MM-dd".replace('-', separator);
            return this.dateFormat(DateTimeFormatter.ofPattern(format).withZone(ZoneOffset.UTC)).autoBuild();
        }

        abstract IndexNameFormatter autoBuild();
    }
}

