/*
 * Decompiled with CFR 0.152.
 */
package zipkin2;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import zipkin2.Endpoint;
import zipkin2.Span;

public final class TestObjects {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final long DAY = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS);
    static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final long TODAY = TestObjects.midnightUTC(System.currentTimeMillis());
    public static final Endpoint FRONTEND = Endpoint.newBuilder().serviceName("frontend").ip("127.0.0.1").build();
    public static final Endpoint BACKEND = Endpoint.newBuilder().serviceName("backend").ip("192.168.99.101").port(9000).build();
    public static final Endpoint DB = Endpoint.newBuilder().serviceName("db").ip("2001:db8::c001").port(3036).build();
    public static final Span CLIENT_SPAN = Span.newBuilder().traceId("7180c278b62e8f6a216a2aea45d08fc9").parentId("1").id("2").name("get").kind(Span.Kind.CLIENT).localEndpoint(FRONTEND).remoteEndpoint(BACKEND).timestamp((TODAY + 50L) * 1000L).duration(200000L).addAnnotation((TODAY + 100L) * 1000L, "foo").putTag("http.path", "/api").putTag("clnt/finagle.version", "6.45.0").build();
    public static final List<Span> TRACE = Arrays.asList(Span.newBuilder().traceId(CLIENT_SPAN.traceId()).id("1").name("get").kind(Span.Kind.SERVER).localEndpoint(FRONTEND).timestamp(TODAY * 1000L).duration(350000L).build(), CLIENT_SPAN, Span.newBuilder().traceId(CLIENT_SPAN.traceId()).parentId(CLIENT_SPAN.parentId()).id(CLIENT_SPAN.id()).shared(true).name("get").kind(Span.Kind.SERVER).localEndpoint(BACKEND).timestamp((TODAY + 100L) * 1000L).duration(150000L).build(), Span.newBuilder().traceId(CLIENT_SPAN.traceId()).parentId("2").id("3").name("query").kind(Span.Kind.CLIENT).localEndpoint(BACKEND).remoteEndpoint(DB).timestamp((TODAY + 150L) * 1000L).duration(50000L).addAnnotation((TODAY + 190L) * 1000L, "\u2ee9").putTag("error", "\ud83d\udca9").build());
    public static final long TRACE_DURATION = TRACE.get(0).durationAsLong() / 1000L;
    public static final long TRACE_STARTTS = TRACE.get(0).timestampAsLong() / 1000L;
    public static final long TRACE_ENDTS = TRACE_STARTTS + TRACE_DURATION;
    static final Span.Builder spanBuilder = TestObjects.spanBuilder();
    public static final Span[] LOTS_OF_SPANS = (Span[])new Random().longs(100000L).mapToObj(t -> TestObjects.span(t)).toArray(Span[]::new);

    public static long midnightUTC(long epochMillis) {
        Calendar day = Calendar.getInstance(UTC);
        day.setTimeInMillis(epochMillis);
        day.set(14, 0);
        day.set(13, 0);
        day.set(12, 0);
        day.set(11, 0);
        return day.getTimeInMillis();
    }

    static Span.Builder spanBuilder() {
        return Span.newBuilder().name("get /foo").timestamp(System.currentTimeMillis() * 1000L).duration(1000L).kind(Span.Kind.SERVER).localEndpoint(BACKEND).putTag("http.method", "GET");
    }

    public static Span span(long traceId) {
        return spanBuilder.traceId(Long.toHexString(traceId)).id(traceId).build();
    }
}

