/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.storage.ITSpanStore;
import zipkin2.storage.SpanStore;
import zipkin2.storage.StorageComponent;

public abstract class ITStrictTraceIdFalse {
    protected abstract StorageComponent storage();

    protected SpanStore store() {
        return this.storage().spanStore();
    }

    @Before
    public abstract void clear() throws Exception;

    @Test
    public void getTraces_128BitTraceId() throws IOException {
        this.getTraces_128BitTraceId(this.accept128BitTrace(this.storage()));
    }

    @Test
    public void getTraces_128BitTraceId_mixed() throws IOException {
        this.getTraces_128BitTraceId(this.acceptMixedTrace());
    }

    protected void getTraces_128BitTraceId(List<Span> trace) throws IOException {
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().build()).execute())).containsExactly((Object[])new List[]{trace});
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName(TestObjects.FRONTEND.serviceName()).parseAnnotationQuery("foo").build()).execute())).containsExactly((Object[])new List[]{trace});
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName(TestObjects.BACKEND.serviceName()).parseAnnotationQuery("error").build()).execute())).containsExactly((Object[])new List[]{trace});
    }

    @Test
    public void getTrace_retrievesBy64Or128BitTraceId() throws IOException {
        List<Span> trace = this.accept128BitTrace(this.storage());
        this.retrievesBy64Or128BitTraceId(trace);
    }

    @Test
    public void getTrace_retrievesBy64Or128BitTraceId_mixed() throws IOException {
        List<Span> trace = this.acceptMixedTrace();
        this.retrievesBy64Or128BitTraceId(trace);
    }

    void retrievesBy64Or128BitTraceId(List<Span> trace) throws IOException {
        Assertions.assertThat((List)((List)this.store().getTrace(trace.get(0).traceId().substring(16)).execute())).containsOnlyElementsOf(trace);
        Assertions.assertThat((List)((List)this.store().getTrace(trace.get(0).traceId()).execute())).containsOnlyElementsOf(trace);
    }

    protected List<Span> accept128BitTrace(StorageComponent storage) throws IOException {
        ArrayList<Span> trace = new ArrayList<Span>(TestObjects.TRACE);
        Collections.reverse(trace);
        storage.spanConsumer().accept(trace).execute();
        return TestObjects.TRACE;
    }

    List<Span> acceptMixedTrace() throws IOException {
        ArrayList<Span> trace = new ArrayList<Span>(TestObjects.TRACE);
        String downgraded = ((Span)trace.get(0)).traceId().substring(16);
        for (int i = 2; i < trace.size(); ++i) {
            trace.set(i, ((Span)trace.get(i)).toBuilder().traceId(downgraded).build());
        }
        Collections.reverse(trace);
        this.accept(trace.toArray(new Span[0]));
        return ITSpanStore.sortTrace(trace);
    }

    void accept(Span ... spans) throws IOException {
        this.storage().spanConsumer().accept(Arrays.asList(spans)).execute();
    }
}

