/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import de.flapdoodle.embed.process.distribution.GenericVersion;
import de.flapdoodle.embed.process.distribution.IVersion;
import io.zonky.test.db.flyway.BlockingDataSourceWrapper;
import io.zonky.test.db.provider.DatabasePreparer;
import io.zonky.test.db.provider.DatabaseProvider;
import io.zonky.test.db.provider.DatabaseType;
import io.zonky.test.db.provider.ProviderType;
import io.zonky.test.db.util.PropertyUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.commons.lang3.RandomStringUtils;
import org.postgresql.ds.PGSimpleDataSource;
import org.springframework.core.env.Environment;
import ru.yandex.qatools.embed.postgresql.EmbeddedPostgres;
import ru.yandex.qatools.embed.postgresql.util.SocketUtil;

public class YandexPostgresDatabaseProvider
implements DatabaseProvider {
    private static final String POSTGRES_USERNAME = "postgres";
    private static final String POSTGRES_PASSWORD = "yandex";
    private static final LoadingCache<DatabaseConfig, DatabaseInstance> databases = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<DatabaseConfig, DatabaseInstance>(){

        public DatabaseInstance load(DatabaseConfig config) throws IOException {
            return new DatabaseInstance(config);
        }
    });
    private final DatabaseConfig databaseConfig;
    private final ClientConfig clientConfig;

    public YandexPostgresDatabaseProvider(Environment environment) {
        String postgresVersion = environment.getProperty("zonky.test.database.postgres.yandex-provider.postgres-version", "10.11-1");
        Map<String, String> initdbProperties = PropertyUtils.extractAll(environment, "zonky.test.database.postgres.initdb.properties");
        Map<String, String> configProperties = PropertyUtils.extractAll(environment, "zonky.test.database.postgres.server.properties");
        Map<String, String> connectProperties = PropertyUtils.extractAll(environment, "zonky.test.database.postgres.client.properties");
        this.databaseConfig = new DatabaseConfig((IVersion)new GenericVersion(postgresVersion), initdbProperties, configProperties);
        this.clientConfig = new ClientConfig(connectProperties);
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.POSTGRES;
    }

    @Override
    public ProviderType getProviderType() {
        return ProviderType.YANDEX;
    }

    @Override
    public DataSource getDatabase(DatabasePreparer preparer) throws SQLException {
        DatabaseInstance instance = (DatabaseInstance)databases.getUnchecked((Object)this.databaseConfig);
        DatabaseInstance.DatabaseTemplate template = instance.getTemplate(this.clientConfig, preparer);
        return template.createDatabase();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        YandexPostgresDatabaseProvider that = (YandexPostgresDatabaseProvider)o;
        return Objects.equals(this.databaseConfig, that.databaseConfig) && Objects.equals(this.clientConfig, that.clientConfig);
    }

    public int hashCode() {
        return Objects.hash(this.databaseConfig, this.clientConfig);
    }

    private static class ClientConfig {
        private final Map<String, String> connectProperties;

        private ClientConfig(Map<String, String> connectProperties) {
            this.connectProperties = ImmutableMap.copyOf(connectProperties);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientConfig that = (ClientConfig)o;
            return Objects.equals(this.connectProperties, that.connectProperties);
        }

        public int hashCode() {
            return Objects.hash(this.connectProperties);
        }
    }

    private static class DatabaseConfig {
        private final IVersion version;
        private final Map<String, String> initdbProperties;
        private final Map<String, String> configProperties;

        private DatabaseConfig(IVersion version, Map<String, String> initdbProperties, Map<String, String> configProperties) {
            this.version = version;
            this.initdbProperties = ImmutableMap.copyOf(initdbProperties);
            this.configProperties = ImmutableMap.copyOf(configProperties);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DatabaseConfig that = (DatabaseConfig)o;
            return Objects.equals(this.version, that.version) && Objects.equals(this.initdbProperties, that.initdbProperties) && Objects.equals(this.configProperties, that.configProperties);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.initdbProperties, this.configProperties);
        }
    }

    protected static class DatabaseInstance {
        private final EmbeddedPostgres postgres;
        private final Semaphore semaphore;
        private final LoadingCache<TemplateKey, DatabaseTemplate> templates = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<TemplateKey, DatabaseTemplate>(){

            public DatabaseTemplate load(TemplateKey key) throws Exception {
                return new DatabaseTemplate(key.config, key.preparer);
            }
        });

        private DatabaseInstance(DatabaseConfig config) throws IOException {
            HashMap<String, String> initdbProperties = new HashMap<String, String>(config.initdbProperties);
            initdbProperties.putIfAbsent("encoding", "UTF-8");
            List initdbParams = initdbProperties.entrySet().stream().map(e -> String.format("--%s=%s", e.getKey(), e.getValue())).collect(Collectors.toList());
            HashMap<String, String> serverProperties = new HashMap<String, String>(config.configProperties);
            serverProperties.putIfAbsent("max_connections", "300");
            List postgresParams = serverProperties.entrySet().stream().flatMap(e -> Stream.of("-c", String.format("%s=%s", e.getKey(), e.getValue()))).collect(Collectors.toList());
            this.postgres = new EmbeddedPostgres(config.version);
            this.postgres.start(EmbeddedPostgres.defaultRuntimeConfig(), "localhost", SocketUtil.findFreePort(), YandexPostgresDatabaseProvider.POSTGRES_USERNAME, YandexPostgresDatabaseProvider.POSTGRES_USERNAME, YandexPostgresDatabaseProvider.POSTGRES_PASSWORD, initdbParams, postgresParams);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((EmbeddedPostgres)this.postgres).close()));
            this.semaphore = new Semaphore(Integer.parseInt((String)serverProperties.get("max_connections")));
        }

        public DatabaseTemplate getTemplate(ClientConfig config, DatabasePreparer preparer) {
            return (DatabaseTemplate)this.templates.getUnchecked((Object)new TemplateKey(config, preparer));
        }

        protected static class TemplateKey {
            private final ClientConfig config;
            private final DatabasePreparer preparer;

            private TemplateKey(ClientConfig config, DatabasePreparer preparer) {
                this.config = config;
                this.preparer = preparer;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                TemplateKey that = (TemplateKey)o;
                return Objects.equals(this.config, that.config) && Objects.equals(this.preparer, that.preparer);
            }

            public int hashCode() {
                return Objects.hash(this.config, this.preparer);
            }
        }

        protected class DatabaseTemplate {
            private final ClientConfig config;
            private final String templateName;

            private DatabaseTemplate(ClientConfig config, DatabasePreparer preparer) throws SQLException {
                this.config = config;
                this.templateName = RandomStringUtils.randomAlphabetic((int)12).toLowerCase(Locale.ENGLISH);
                this.executeStatement(String.format("CREATE DATABASE %s OWNER %s ENCODING 'utf8'", this.templateName, YandexPostgresDatabaseProvider.POSTGRES_USERNAME));
                DataSource dataSource = this.getDatabase(this.templateName);
                preparer.prepare(dataSource);
            }

            public DataSource createDatabase() throws SQLException {
                String databaseName = RandomStringUtils.randomAlphabetic((int)12).toLowerCase(Locale.ENGLISH);
                this.executeStatement(String.format("CREATE DATABASE %s TEMPLATE %s OWNER %s ENCODING 'utf8'", databaseName, this.templateName, YandexPostgresDatabaseProvider.POSTGRES_USERNAME));
                return this.getDatabase(databaseName);
            }

            private void executeStatement(String ddlStatement) throws SQLException {
                DataSource dataSource = this.getDatabase(YandexPostgresDatabaseProvider.POSTGRES_USERNAME);
                try (Connection connection = dataSource.getConnection();
                     PreparedStatement stmt = connection.prepareStatement(ddlStatement);){
                    stmt.execute();
                }
            }

            private DataSource getDatabase(String dbName) throws SQLException {
                PGSimpleDataSource dataSource = new PGSimpleDataSource();
                dataSource.setServerName("localhost");
                dataSource.setPortNumber(DatabaseInstance.this.postgres.getConfig().map(config -> config.net().port()).orElse(-1).intValue());
                dataSource.setDatabaseName(dbName);
                dataSource.setUser(YandexPostgresDatabaseProvider.POSTGRES_USERNAME);
                dataSource.setPassword(YandexPostgresDatabaseProvider.POSTGRES_PASSWORD);
                for (Map.Entry entry : this.config.connectProperties.entrySet()) {
                    dataSource.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
                return new BlockingDataSourceWrapper((DataSource)dataSource, DatabaseInstance.this.semaphore);
            }
        }
    }
}

