/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider;

import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.util.Assert;

public final class ProviderType {
    public static final ProviderType DOCKER = new ProviderType("docker", "org.testcontainers:postgresql");
    public static final ProviderType ZONKY = new ProviderType("zonky", "io.zonky.test:embedded-postgres");
    public static final ProviderType OPENTABLE = new ProviderType("opentable", "com.opentable.components:otj-pg-embedded");
    public static final ProviderType YANDEX = new ProviderType("yandex", "ru.yandex.qatools.embed:postgresql-embedded");
    private final String name;
    private final String dependency;

    public static ProviderType valueOf(String name) {
        Assert.notNull((Object)name, (String)"Provider name must not be null");
        return Stream.of(DOCKER, ZONKY, OPENTABLE, YANDEX).filter(type -> type.name().equals(name.toLowerCase())).findFirst().orElse(new ProviderType(name.toLowerCase()));
    }

    private ProviderType(String name) {
        this(name, null);
    }

    private ProviderType(String name, String dependency) {
        this.name = name;
        this.dependency = dependency;
    }

    public String name() {
        return this.name;
    }

    String getDependencyInfo() {
        return this.dependency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProviderType that = (ProviderType)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name;
    }
}

