/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import io.zonky.test.db.provider.DatabaseDescriptor;
import io.zonky.test.db.provider.DatabasePreparer;
import io.zonky.test.db.provider.DatabaseProvider;
import io.zonky.test.db.provider.GenericDatabaseProvider;
import io.zonky.test.db.provider.MissingDatabaseProviderException;
import io.zonky.test.db.provider.MissingProviderDependencyException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.ListenableFutureTask;

public class PrefetchingDatabaseProvider
implements GenericDatabaseProvider {
    private static final Logger logger = LoggerFactory.getLogger(PrefetchingDatabaseProvider.class);
    private static final ThreadPoolTaskExecutor taskExecutor = new PriorityThreadPoolTaskExecutor();
    private static final ConcurrentMap<PipelineKey, DatabasePipeline> pipelines = new ConcurrentHashMap<PipelineKey, DatabasePipeline>();
    private final int pipelineCacheSize;
    private final Map<DatabaseDescriptor, DatabaseProvider> databaseProviders;

    public PrefetchingDatabaseProvider(ObjectProvider<List<DatabaseProvider>> databaseProviders, Environment environment) {
        this.databaseProviders = Optional.ofNullable(databaseProviders.getIfAvailable()).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(p -> new DatabaseDescriptor(p.getDatabaseType(), p.getProviderType()), Function.identity()));
        String threadNamePrefix = environment.getProperty("zonky.test.database.prefetching.thread-name-prefix", "prefetching-");
        int concurrency = (Integer)environment.getProperty("zonky.test.database.prefetching.concurrency", Integer.TYPE, (Object)3);
        this.pipelineCacheSize = (Integer)environment.getProperty("zonky.test.database.prefetching.pipeline-cache-size", Integer.TYPE, (Object)3);
        taskExecutor.setThreadNamePrefix(threadNamePrefix);
        taskExecutor.setCorePoolSize(concurrency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource getDatabase(DatabasePreparer preparer, DatabaseDescriptor descriptor) throws Exception {
        PipelineKey key;
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.trace("Prefetching pipelines: {}", pipelines.values());
        DatabaseProvider provider = this.databaseProviders.get(descriptor);
        if (provider == null) {
            throw this.missingDatabaseProviderException(descriptor);
        }
        DatabasePipeline pipeline = pipelines.computeIfAbsent(key = new PipelineKey(preparer, descriptor, provider), k -> new DatabasePipeline());
        PreparedResult result = (PreparedResult)pipeline.results.poll();
        this.prepareDatabase(key, result == null ? Integer.MIN_VALUE : Integer.MAX_VALUE);
        long invocationCount = pipeline.requests.incrementAndGet();
        if (invocationCount == 1L) {
            for (int i = 1; i <= this.pipelineCacheSize; ++i) {
                int priority = -1 * (int)(invocationCount / (long)this.pipelineCacheSize * (long)i);
                this.prepareDatabase(key, priority);
            }
        } else {
            Set i = pipeline.tasks;
            synchronized (i) {
                List cancelledTasks = pipeline.tasks.stream().filter(t -> ((PrefetchingTask)t).priority > Integer.MIN_VALUE).filter(t -> t.cancel(false)).collect(Collectors.toList());
                for (int i2 = 1; i2 <= cancelledTasks.size(); ++i2) {
                    int priority = -1 * (int)(invocationCount / (long)cancelledTasks.size() * (long)i2);
                    this.prepareDatabase(key, priority);
                }
            }
        }
        DataSource dataSource = result != null ? result.get() : ((PreparedResult)pipeline.results.take()).get();
        logger.debug("Database has been successfully returned in {}", (Object)stopwatch);
        return dataSource;
    }

    protected MissingDatabaseProviderException missingDatabaseProviderException(DatabaseDescriptor descriptor) {
        boolean isProviderPresent = this.databaseProviders.keySet().stream().map(DatabaseDescriptor::getProviderType).anyMatch(p -> p.equals(descriptor.getProviderType()));
        if (isProviderPresent) {
            return new MissingDatabaseProviderException(descriptor);
        }
        return new MissingProviderDependencyException(descriptor);
    }

    private ListenableFutureTask<DataSource> prepareDatabase(PipelineKey key, int priority) {
        final PrefetchingTask task = new PrefetchingTask(key.provider, key.preparer, priority);
        final DatabasePipeline pipeline = (DatabasePipeline)pipelines.get(key);
        task.addCallback((ListenableFutureCallback)new ListenableFutureCallback<DataSource>(){

            public void onSuccess(DataSource result) {
                pipeline.tasks.remove(task);
                pipeline.results.offer(PreparedResult.success(result));
            }

            public void onFailure(Throwable error) {
                pipeline.tasks.remove(task);
                if (!(error instanceof CancellationException)) {
                    pipeline.results.offer(PreparedResult.failure(error));
                }
            }
        });
        pipeline.tasks.add(task);
        taskExecutor.execute((Runnable)((Object)task));
        return task;
    }

    static {
        taskExecutor.setThreadNamePrefix("prefetching-");
        taskExecutor.setAllowCoreThreadTimeOut(true);
        taskExecutor.setKeepAliveSeconds(60);
        taskExecutor.setCorePoolSize(1);
        taskExecutor.initialize();
    }

    private static class PrefetchingTask
    extends ListenableFutureTask<DataSource>
    implements Comparable<PrefetchingTask> {
        private final AtomicBoolean active = new AtomicBoolean(true);
        private final int priority;

        public PrefetchingTask(DatabaseProvider provider, DatabasePreparer preparer, int priority) {
            super(() -> provider.getDatabase(preparer));
            this.priority = priority;
        }

        public void run() {
            if (this.active.compareAndSet(true, false)) {
                super.run();
            }
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            if (mayInterruptIfRunning || this.active.compareAndSet(true, false)) {
                return super.cancel(mayInterruptIfRunning);
            }
            return false;
        }

        @Override
        public int compareTo(PrefetchingTask task) {
            return Integer.compare(this.priority, task.priority);
        }
    }

    private static class PriorityThreadPoolTaskExecutor
    extends ThreadPoolTaskExecutor {
        private PriorityThreadPoolTaskExecutor() {
        }

        protected BlockingQueue<Runnable> createQueue(int queueCapacity) {
            return new PriorityBlockingQueue<Runnable>();
        }
    }

    private static class PreparedResult {
        private final DataSource result;
        private final Throwable error;

        public static PreparedResult success(DataSource result) {
            return new PreparedResult(result, null);
        }

        public static PreparedResult failure(Throwable error) {
            return new PreparedResult(null, error);
        }

        private PreparedResult(DataSource result, Throwable error) {
            this.result = result;
            this.error = error;
        }

        public DataSource get() throws Exception {
            if (this.result != null) {
                return this.result;
            }
            Throwables.propagateIfPossible((Throwable)this.error, Exception.class);
            throw new RuntimeException(this.error);
        }
    }

    private static class DatabasePipeline {
        private final AtomicLong requests = new AtomicLong();
        private final Set<PrefetchingTask> tasks = Collections.newSetFromMap(new ConcurrentHashMap());
        private final BlockingQueue<PreparedResult> results = new LinkedBlockingQueue<PreparedResult>();

        private DatabasePipeline() {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("totalRequests", this.requests.get()).add("prefetchingQueue", this.tasks.size()).add("preparedResults", this.results.size()).toString();
        }
    }

    private static class PipelineKey {
        private final DatabasePreparer preparer;
        private final DatabaseDescriptor descriptor;
        private final DatabaseProvider provider;

        private PipelineKey(DatabasePreparer preparer, DatabaseDescriptor descriptor, DatabaseProvider provider) {
            this.preparer = preparer;
            this.descriptor = descriptor;
            this.provider = provider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PipelineKey that = (PipelineKey)o;
            return Objects.equals(this.preparer, that.preparer) && Objects.equals(this.descriptor, that.descriptor) && Objects.equals(this.provider, that.provider);
        }

        public int hashCode() {
            return Objects.hash(this.preparer, this.descriptor, this.provider);
        }
    }
}

