/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.flyway;

import com.google.common.base.Preconditions;
import io.zonky.test.db.flyway.FlywayConfigSnapshot;
import io.zonky.test.db.flyway.FlywayDataSourceContext;
import io.zonky.test.db.provider.DatabaseDescriptor;
import io.zonky.test.db.provider.DatabasePreparer;
import io.zonky.test.db.provider.GenericDatabaseProvider;
import io.zonky.test.db.util.ReflectionUtils;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.sql.DataSource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flywaydb.core.Flyway;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.concurrent.CompletableToListenableFutureAdapter;
import org.springframework.util.concurrent.ListenableFuture;

public class DefaultFlywayDataSourceContext
implements FlywayDataSourceContext {
    protected static final int DEFAULT_MAX_RETRY_ATTEMPTS = 2;
    protected static final ThreadLocal<DataSource> preparerDataSourceHolder = new ThreadLocal();
    protected volatile CompletableFuture<DataSource> dataSourceFuture = CompletableFuture.completedFuture(null);
    @Autowired
    protected GenericDatabaseProvider databaseProvider;
    protected DatabaseDescriptor databaseDescriptor;
    protected int maxAttempts = 2;
    protected TaskExecutor bootstrapExecutor;

    public Class<?> getTargetClass() {
        return DataSource.class;
    }

    public boolean isStatic() {
        return false;
    }

    public Object getTarget() throws Exception {
        DataSource threadBoundDataSource = preparerDataSourceHolder.get();
        if (threadBoundDataSource != null) {
            return threadBoundDataSource;
        }
        if (this.bootstrapExecutor == null && !this.dataSourceFuture.isDone()) {
            throw new IllegalStateException("dataSource is not initialized yet");
        }
        DataSource dataSource = this.dataSourceFuture.get();
        Preconditions.checkState((dataSource != null ? 1 : 0) != 0, (Object)"Unexpected error occurred while initializing the data source");
        return dataSource;
    }

    public void releaseTarget(Object target) {
    }

    @Override
    public void setDescriptor(DatabaseDescriptor descriptor) {
        this.databaseDescriptor = descriptor;
    }

    @Override
    public synchronized ListenableFuture<DataSource> reload(Flyway flyway) {
        Executor executor = this.bootstrapExecutor != null ? this.bootstrapExecutor : Runnable::run;
        CompletionStage reloadFuture = this.dataSourceFuture.thenApplyAsync(x -> {
            for (int current = 1; current <= this.maxAttempts; ++current) {
                try {
                    FlywayDatabasePreparer databasePreparer = new FlywayDatabasePreparer(flyway);
                    return this.databaseProvider.getDatabase(databasePreparer, this.databaseDescriptor);
                }
                catch (Exception e) {
                    if (ExceptionUtils.indexOfType((Throwable)e, IOException.class) != -1 && current != this.maxAttempts) continue;
                    throw new CompletionException(e);
                }
            }
            throw new IllegalStateException("maxAttempts parameter must be greater or equal to 1");
        }, executor);
        this.dataSourceFuture = ((CompletableFuture)reloadFuture).exceptionally(throwable -> null);
        return new CompletableToListenableFutureAdapter((CompletableFuture)reloadFuture);
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public void setBootstrapExecutor(TaskExecutor bootstrapExecutor) {
        this.bootstrapExecutor = bootstrapExecutor;
    }

    protected FlywayConfigSnapshot createConfigSnapshot(Flyway flyway) {
        return new FlywayConfigSnapshot(flyway);
    }

    protected class FlywayDatabasePreparer
    implements DatabasePreparer {
        private final FlywayConfigSnapshot configSnapshot;
        private final Flyway flyway;

        public FlywayDatabasePreparer(Flyway flyway) {
            this.configSnapshot = DefaultFlywayDataSourceContext.this.createConfigSnapshot(flyway);
            this.flyway = flyway;
        }

        @Override
        public void prepare(DataSource ds) {
            preparerDataSourceHolder.set(ds);
            try {
                ReflectionUtils.invokeMethod(this.flyway, "migrate", new Object[0]);
            }
            finally {
                preparerDataSourceHolder.remove();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FlywayDatabasePreparer that = (FlywayDatabasePreparer)o;
            return Objects.equals(this.configSnapshot, that.configSnapshot);
        }

        public int hashCode() {
            return Objects.hash(this.configSnapshot);
        }
    }
}

