/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.flyway;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.zonky.test.db.flyway.FlywayClassUtils;
import io.zonky.test.db.util.ReflectionUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.springframework.util.ClassUtils;

public class FlywayConfigSnapshot {
    private static final int flywayVersion = FlywayClassUtils.getFlywayVersion();
    private static final boolean isFlywayPro = FlywayClassUtils.isFlywayPro();
    private final ClassLoader classLoader;
    private final DataSource dataSource;
    private final Object[] callbacks;
    private final List<MigrationResolver> resolvers;
    private final List<Object> errorHandlers;
    private final Object resourceProvider;
    private final Object javaMigrationClassProvider;
    private final MigrationVersion baselineVersion;
    private final MigrationVersion target;
    private final List<Object> locations;
    private final List<String> schemas;
    private final List<String> sqlMigrationSuffixes;
    private final List<Class<?>> javaMigrations;
    private final List<String> errorOverrides;
    private final Map<String, String> placeholders;
    private final Map<String, String> jdbcProperties;
    private final List<Object> cherryPick;
    private final String table;
    private final String tablespace;
    private final String defaultSchemaName;
    private final String baselineDescription;
    private final String undoSqlMigrationPrefix;
    private final String repeatableSqlMigrationPrefix;
    private final String sqlMigrationSeparator;
    private final String sqlMigrationPrefix;
    private final String placeholderPrefix;
    private final String placeholderSuffix;
    private final Object encoding;
    private final String initSql;
    private final String licenseKey;
    private final String url;
    private final String user;
    private final String password;
    private final boolean skipDefaultResolvers;
    private final boolean skipDefaultCallbacks;
    private final boolean skipExecutingMigrations;
    private final boolean placeholderReplacement;
    private final boolean baselineOnMigrate;
    private final boolean outOfOrder;
    private final boolean ignoreMissingMigrations;
    private final boolean ignoreIgnoredMigrations;
    private final boolean ignorePendingMigrations;
    private final boolean ignoreFutureMigrations;
    private final boolean validateMigrationNaming;
    private final boolean validateOnMigrate;
    private final boolean cleanOnValidationError;
    private final boolean cleanDisabled;
    private final boolean allowMixedMigrations;
    private final boolean createSchemas;
    private final boolean mixed;
    private final boolean group;
    private final String installedBy;
    private final boolean dryRun;
    private final boolean stream;
    private final boolean batch;
    private final boolean oracleSqlPlus;
    private final boolean oracleSqlplusWarn;
    private final String oracleKerberosConfigFile;
    private final String oracleKerberosCacheFile;
    private final boolean outputQueryResults;
    private final int connectRetries;
    private final int lockRetryCount;
    private final String conjurUrl;
    private final String conjurToken;
    private final String vaultUrl;
    private final String vaultToken;
    private final List<String> vaultSecrets;

    public FlywayConfigSnapshot(Flyway flyway) {
        Object config = flywayVersion >= 51 ? ReflectionUtils.getField(flyway, "configuration") : flyway;
        this.classLoader = (ClassLoader)FlywayConfigSnapshot.getValue(config, "getClassLoader");
        this.dataSource = (DataSource)FlywayConfigSnapshot.getValue(config, "getDataSource");
        this.resolvers = ImmutableList.copyOf((Object[])FlywayConfigSnapshot.getArray(config, "getResolvers"));
        this.callbacks = (Object[])FlywayConfigSnapshot.getValue(config, "getCallbacks");
        this.sqlMigrationSeparator = (String)FlywayConfigSnapshot.getValue(config, "getSqlMigrationSeparator");
        this.sqlMigrationPrefix = (String)FlywayConfigSnapshot.getValue(config, "getSqlMigrationPrefix");
        this.placeholderSuffix = (String)FlywayConfigSnapshot.getValue(config, "getPlaceholderSuffix");
        this.placeholderPrefix = (String)FlywayConfigSnapshot.getValue(config, "getPlaceholderPrefix");
        this.placeholders = ImmutableMap.copyOf(FlywayConfigSnapshot.getMap(config, "getPlaceholders"));
        this.target = (MigrationVersion)FlywayConfigSnapshot.getValue(config, "getTarget");
        this.table = (String)FlywayConfigSnapshot.getValue(config, "getTable");
        this.schemas = ImmutableList.copyOf((Object[])FlywayConfigSnapshot.getArray(config, "getSchemas"));
        this.encoding = FlywayConfigSnapshot.getValue(config, "getEncoding");
        this.locations = ImmutableList.copyOf((Object[])FlywayConfigSnapshot.getArray(config, "getLocations"));
        this.outOfOrder = (Boolean)FlywayConfigSnapshot.getValue(config, "isOutOfOrder");
        this.validateOnMigrate = (Boolean)FlywayConfigSnapshot.getValue(config, "isValidateOnMigrate");
        this.cleanOnValidationError = (Boolean)FlywayConfigSnapshot.getValue(config, "isCleanOnValidationError");
        if (flywayVersion >= 31) {
            this.baselineVersion = (MigrationVersion)FlywayConfigSnapshot.getValue(config, "getBaselineVersion");
            this.baselineDescription = (String)FlywayConfigSnapshot.getValue(config, "getBaselineDescription");
            this.baselineOnMigrate = (Boolean)FlywayConfigSnapshot.getValue(config, "isBaselineOnMigrate");
        } else {
            this.baselineVersion = null;
            this.baselineDescription = null;
            this.baselineOnMigrate = false;
        }
        this.placeholderReplacement = flywayVersion >= 32 ? (Boolean)FlywayConfigSnapshot.getValue(config, "isPlaceholderReplacement") : true;
        if (flywayVersion >= 40) {
            this.skipDefaultResolvers = (Boolean)FlywayConfigSnapshot.getValue(config, "isSkipDefaultResolvers");
            this.skipDefaultCallbacks = (Boolean)FlywayConfigSnapshot.getValue(config, "isSkipDefaultCallbacks");
            this.repeatableSqlMigrationPrefix = (String)FlywayConfigSnapshot.getValue(config, "getRepeatableSqlMigrationPrefix");
            this.ignoreFutureMigrations = (Boolean)FlywayConfigSnapshot.getValue(config, "isIgnoreFutureMigrations");
            this.cleanDisabled = (Boolean)FlywayConfigSnapshot.getValue(config, "isCleanDisabled");
        } else {
            this.skipDefaultResolvers = false;
            this.skipDefaultCallbacks = false;
            this.repeatableSqlMigrationPrefix = "R";
            this.ignoreFutureMigrations = true;
            this.cleanDisabled = false;
        }
        if (flywayVersion >= 41) {
            this.ignoreMissingMigrations = (Boolean)FlywayConfigSnapshot.getValue(config, "isIgnoreMissingMigrations");
            this.installedBy = (String)FlywayConfigSnapshot.getValue(config, "getInstalledBy");
        } else {
            this.ignoreMissingMigrations = false;
            this.installedBy = null;
        }
        this.allowMixedMigrations = flywayVersion >= 41 && flywayVersion < 50 ? (Boolean)FlywayConfigSnapshot.getValue(config, "isAllowMixedMigrations") : false;
        if (flywayVersion >= 42) {
            this.mixed = (Boolean)FlywayConfigSnapshot.getValue(config, "isMixed");
            this.group = (Boolean)FlywayConfigSnapshot.getValue(config, "isGroup");
        } else {
            this.mixed = false;
            this.group = false;
        }
        if (flywayVersion >= 50) {
            this.sqlMigrationSuffixes = ImmutableList.copyOf((Object[])FlywayConfigSnapshot.getArray(config, "getSqlMigrationSuffixes"));
        } else {
            String sqlMigrationSuffix = (String)FlywayConfigSnapshot.getValue(config, "getSqlMigrationSuffix");
            this.sqlMigrationSuffixes = ImmutableList.of((Object)sqlMigrationSuffix);
        }
        if (flywayVersion >= 50 && isFlywayPro) {
            this.undoSqlMigrationPrefix = (String)FlywayConfigSnapshot.getValue(config, "getUndoSqlMigrationPrefix");
            this.dryRun = FlywayConfigSnapshot.getValue(config, "getDryRunOutput") != null;
        } else {
            this.undoSqlMigrationPrefix = null;
            this.dryRun = false;
        }
        this.errorHandlers = flywayVersion >= 50 && flywayVersion < 60 && isFlywayPro ? ImmutableList.copyOf((Object[])FlywayConfigSnapshot.getArray(config, "getErrorHandlers")) : ImmutableList.of();
        this.ignoreIgnoredMigrations = flywayVersion >= 51 ? (Boolean)FlywayConfigSnapshot.getValue(config, "isIgnoreIgnoredMigrations") : false;
        if (flywayVersion >= 51 && isFlywayPro) {
            this.errorOverrides = ImmutableList.copyOf((Object[])FlywayConfigSnapshot.getArray(config, "getErrorOverrides"));
            this.stream = (Boolean)FlywayConfigSnapshot.getValue(config, "isStream");
            this.batch = (Boolean)FlywayConfigSnapshot.getValue(config, "isBatch");
            this.oracleSqlPlus = (Boolean)FlywayConfigSnapshot.getValue(config, "isOracleSqlplus");
        } else {
            this.errorOverrides = ImmutableList.of();
            this.stream = false;
            this.batch = false;
            this.oracleSqlPlus = false;
        }
        if (flywayVersion >= 52) {
            this.ignorePendingMigrations = (Boolean)FlywayConfigSnapshot.getValue(config, "isIgnorePendingMigrations");
            this.connectRetries = (Integer)FlywayConfigSnapshot.getValue(config, "getConnectRetries");
            this.initSql = (String)FlywayConfigSnapshot.getValue(config, "getInitSql");
        } else {
            this.ignorePendingMigrations = false;
            this.connectRetries = 0;
            this.initSql = null;
        }
        this.licenseKey = flywayVersion >= 52 && isFlywayPro ? (String)FlywayConfigSnapshot.getValue(config, "getLicenseKey") : null;
        if (flywayVersion >= 60) {
            this.tablespace = (String)FlywayConfigSnapshot.getValue(config, "getTablespace");
            this.javaMigrations = ImmutableList.copyOf((Collection)Arrays.stream(FlywayConfigSnapshot.getArray(config, "getJavaMigrations")).map(Object::getClass).collect(Collectors.toList()));
        } else {
            this.tablespace = null;
            this.javaMigrations = ImmutableList.of();
        }
        if (flywayVersion >= 60 && isFlywayPro) {
            this.oracleSqlplusWarn = (Boolean)FlywayConfigSnapshot.getValue(config, "isOracleSqlplusWarn");
            this.outputQueryResults = (Boolean)FlywayConfigSnapshot.getValue(config, "outputQueryResults");
        } else {
            this.oracleSqlplusWarn = false;
            this.outputQueryResults = true;
        }
        this.defaultSchemaName = flywayVersion >= 61 ? (String)FlywayConfigSnapshot.getValue(config, "getDefaultSchema") : null;
        this.validateMigrationNaming = flywayVersion >= 62 ? (Boolean)FlywayConfigSnapshot.getValue(config, "isValidateMigrationNaming") : false;
        if (flywayVersion >= 65) {
            this.resourceProvider = FlywayConfigSnapshot.getValue(config, "getResourceProvider");
            this.javaMigrationClassProvider = FlywayConfigSnapshot.getValue(config, "getJavaMigrationClassProvider");
            this.createSchemas = (Boolean)FlywayConfigSnapshot.getValue(config, "getCreateSchemas");
        } else {
            this.resourceProvider = null;
            this.javaMigrationClassProvider = null;
            this.createSchemas = true;
        }
        if (flywayVersion >= 70) {
            this.url = (String)FlywayConfigSnapshot.getValue(config, "getUrl");
            this.user = (String)FlywayConfigSnapshot.getValue(config, "getUser");
            this.password = (String)FlywayConfigSnapshot.getValue(config, "getPassword");
        } else {
            this.url = null;
            this.user = null;
            this.password = null;
        }
        if (flywayVersion >= 70 && isFlywayPro) {
            this.jdbcProperties = ImmutableMap.copyOf(FlywayConfigSnapshot.getMap(config, "getJdbcProperties"));
            this.cherryPick = ImmutableList.copyOf((Object[])FlywayConfigSnapshot.getArray(config, "getCherryPick"));
            this.skipExecutingMigrations = (Boolean)FlywayConfigSnapshot.getValue(config, "isSkipExecutingMigrations");
            this.oracleKerberosConfigFile = (String)FlywayConfigSnapshot.getValue(config, "getOracleKerberosConfigFile");
            this.oracleKerberosCacheFile = (String)FlywayConfigSnapshot.getValue(config, "getOracleKerberosCacheFile");
        } else {
            this.jdbcProperties = ImmutableMap.of();
            this.cherryPick = ImmutableList.of();
            this.skipExecutingMigrations = false;
            this.oracleKerberosConfigFile = "";
            this.oracleKerberosCacheFile = "";
        }
        this.lockRetryCount = flywayVersion >= 71 ? (Integer)FlywayConfigSnapshot.getValue(config, "getLockRetryCount") : 50;
        if (flywayVersion >= 74 && isFlywayPro) {
            this.conjurUrl = (String)FlywayConfigSnapshot.getValue(config, "getConjurUrl");
            this.conjurToken = (String)FlywayConfigSnapshot.getValue(config, "getConjurToken");
            this.vaultUrl = (String)FlywayConfigSnapshot.getValue(config, "getVaultUrl");
            this.vaultToken = (String)FlywayConfigSnapshot.getValue(config, "getVaultToken");
            this.vaultSecrets = ClassUtils.hasMethod(config.getClass(), (String)"getVaultSecret", (Class[])new Class[0]) ? ImmutableList.of(FlywayConfigSnapshot.getValue(config, "getVaultSecret")) : ImmutableList.copyOf((Object[])FlywayConfigSnapshot.getArray(config, "getVaultSecrets"));
        } else {
            this.conjurUrl = null;
            this.conjurToken = null;
            this.vaultUrl = null;
            this.vaultToken = null;
            this.vaultSecrets = ImmutableList.of();
        }
    }

    private static <T> T getValue(Object target, String method) {
        return ReflectionUtils.invokeMethod(target, method, new Object[0]);
    }

    private static <E> E[] getArray(Object target, String method) {
        return (Object[])ReflectionUtils.invokeMethod(target, method, new Object[0]);
    }

    private static <K, V> Map<K, V> getMap(Object target, String method) {
        return (Map)ReflectionUtils.invokeMethod(target, method, new Object[0]);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public MigrationVersion getBaselineVersion() {
        return this.baselineVersion;
    }

    public String getBaselineDescription() {
        return this.baselineDescription;
    }

    public List<MigrationResolver> getResolvers() {
        return this.resolvers;
    }

    public Object getResourceProvider() {
        return this.resourceProvider;
    }

    public Object getJavaMigrationClassProvider() {
        return this.javaMigrationClassProvider;
    }

    public boolean isSkipDefaultResolvers() {
        return this.skipDefaultResolvers;
    }

    public Object[] getCallbacks() {
        return this.callbacks;
    }

    public boolean isSkipDefaultCallbacks() {
        return this.skipDefaultCallbacks;
    }

    public boolean isSkipExecutingMigrations() {
        return this.skipExecutingMigrations;
    }

    public List<String> getSqlMigrationSuffixes() {
        return this.sqlMigrationSuffixes;
    }

    public List<Class<?>> getJavaMigrations() {
        return this.javaMigrations;
    }

    public String getUndoSqlMigrationPrefix() {
        return this.undoSqlMigrationPrefix;
    }

    public String getRepeatableSqlMigrationPrefix() {
        return this.repeatableSqlMigrationPrefix;
    }

    public String getSqlMigrationSeparator() {
        return this.sqlMigrationSeparator;
    }

    public String getSqlMigrationPrefix() {
        return this.sqlMigrationPrefix;
    }

    public boolean isPlaceholderReplacement() {
        return this.placeholderReplacement;
    }

    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public Map<String, String> getJdbcProperties() {
        return this.jdbcProperties;
    }

    public List<Object> getCherryPick() {
        return this.cherryPick;
    }

    public MigrationVersion getTarget() {
        return this.target;
    }

    public String getTable() {
        return this.table;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public Object getEncoding() {
        return this.encoding;
    }

    public String getInitSql() {
        return this.initSql;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public List<Object> getLocations() {
        return this.locations;
    }

    public boolean isBaselineOnMigrate() {
        return this.baselineOnMigrate;
    }

    public boolean isOutOfOrder() {
        return this.outOfOrder;
    }

    public boolean isIgnoreMissingMigrations() {
        return this.ignoreMissingMigrations;
    }

    public boolean isIgnoreIgnoredMigrations() {
        return this.ignoreIgnoredMigrations;
    }

    public boolean isIgnorePendingMigrations() {
        return this.ignorePendingMigrations;
    }

    public boolean isIgnoreFutureMigrations() {
        return this.ignoreFutureMigrations;
    }

    public boolean isValidateMigrationNaming() {
        return this.validateMigrationNaming;
    }

    public boolean isValidateOnMigrate() {
        return this.validateOnMigrate;
    }

    public boolean isCleanOnValidationError() {
        return this.cleanOnValidationError;
    }

    public boolean isCleanDisabled() {
        return this.cleanDisabled;
    }

    public boolean isAllowMixedMigrations() {
        return this.allowMixedMigrations;
    }

    public boolean isCreateSchemas() {
        return this.createSchemas;
    }

    public boolean isMixed() {
        return this.mixed;
    }

    public boolean isGroup() {
        return this.group;
    }

    public String getInstalledBy() {
        return this.installedBy;
    }

    public List<Object> getErrorHandlers() {
        return this.errorHandlers;
    }

    public List<String> getErrorOverrides() {
        return this.errorOverrides;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isStream() {
        return this.stream;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public boolean isOracleSqlPlus() {
        return this.oracleSqlPlus;
    }

    public boolean isOracleSqlplusWarn() {
        return this.oracleSqlplusWarn;
    }

    public String getOracleKerberosConfigFile() {
        return this.oracleKerberosConfigFile;
    }

    public String getOracleKerberosCacheFile() {
        return this.oracleKerberosCacheFile;
    }

    public boolean isOutputQueryResults() {
        return this.outputQueryResults;
    }

    public int getConnectRetries() {
        return this.connectRetries;
    }

    public int getLockRetryCount() {
        return this.lockRetryCount;
    }

    public String getConjurUrl() {
        return this.conjurUrl;
    }

    public String getConjurToken() {
        return this.conjurToken;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public String getVaultToken() {
        return this.vaultToken;
    }

    public List<String> getVaultSecrets() {
        return this.vaultSecrets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlywayConfigSnapshot that = (FlywayConfigSnapshot)o;
        return this.skipDefaultResolvers == that.skipDefaultResolvers && this.skipDefaultCallbacks == that.skipDefaultCallbacks && this.skipExecutingMigrations == that.skipExecutingMigrations && this.placeholderReplacement == that.placeholderReplacement && this.baselineOnMigrate == that.baselineOnMigrate && this.outOfOrder == that.outOfOrder && this.ignoreMissingMigrations == that.ignoreMissingMigrations && this.ignoreIgnoredMigrations == that.ignoreIgnoredMigrations && this.ignorePendingMigrations == that.ignorePendingMigrations && this.ignoreFutureMigrations == that.ignoreFutureMigrations && this.validateMigrationNaming == that.validateMigrationNaming && this.validateOnMigrate == that.validateOnMigrate && this.cleanOnValidationError == that.cleanOnValidationError && this.cleanDisabled == that.cleanDisabled && this.allowMixedMigrations == that.allowMixedMigrations && this.createSchemas == that.createSchemas && this.mixed == that.mixed && this.group == that.group && this.dryRun == that.dryRun && this.stream == that.stream && this.batch == that.batch && this.oracleSqlPlus == that.oracleSqlPlus && this.oracleSqlplusWarn == that.oracleSqlplusWarn && this.outputQueryResults == that.outputQueryResults && this.connectRetries == that.connectRetries && this.lockRetryCount == that.lockRetryCount && Objects.equals(this.resolvers, that.resolvers) && Objects.equals(this.errorHandlers, that.errorHandlers) && Objects.equals(this.resourceProvider, that.resourceProvider) && Objects.equals(this.javaMigrationClassProvider, that.javaMigrationClassProvider) && Objects.equals(this.baselineVersion, that.baselineVersion) && Objects.equals(this.target, that.target) && Objects.equals(this.locations, that.locations) && Objects.equals(this.schemas, that.schemas) && Objects.equals(this.sqlMigrationSuffixes, that.sqlMigrationSuffixes) && Objects.equals(this.javaMigrations, that.javaMigrations) && Objects.equals(this.errorOverrides, that.errorOverrides) && Objects.equals(this.placeholders, that.placeholders) && Objects.equals(this.jdbcProperties, that.jdbcProperties) && Objects.equals(this.cherryPick, that.cherryPick) && Objects.equals(this.table, that.table) && Objects.equals(this.tablespace, that.tablespace) && Objects.equals(this.defaultSchemaName, that.defaultSchemaName) && Objects.equals(this.baselineDescription, that.baselineDescription) && Objects.equals(this.undoSqlMigrationPrefix, that.undoSqlMigrationPrefix) && Objects.equals(this.repeatableSqlMigrationPrefix, that.repeatableSqlMigrationPrefix) && Objects.equals(this.sqlMigrationSeparator, that.sqlMigrationSeparator) && Objects.equals(this.sqlMigrationPrefix, that.sqlMigrationPrefix) && Objects.equals(this.placeholderPrefix, that.placeholderPrefix) && Objects.equals(this.placeholderSuffix, that.placeholderSuffix) && Objects.equals(this.encoding, that.encoding) && Objects.equals(this.initSql, that.initSql) && Objects.equals(this.licenseKey, that.licenseKey) && Objects.equals(this.installedBy, that.installedBy) && Objects.equals(this.url, that.url) && Objects.equals(this.user, that.user) && Objects.equals(this.password, that.password) && Objects.equals(this.oracleKerberosConfigFile, that.oracleKerberosConfigFile) && Objects.equals(this.oracleKerberosCacheFile, that.oracleKerberosCacheFile) && Objects.equals(this.conjurUrl, that.conjurUrl) && Objects.equals(this.conjurToken, that.conjurToken) && Objects.equals(this.vaultUrl, that.vaultUrl) && Objects.equals(this.vaultToken, that.vaultToken) && Objects.equals(this.vaultSecrets, that.vaultSecrets);
    }

    public int hashCode() {
        return Objects.hash(this.resolvers, this.errorHandlers, this.resourceProvider, this.javaMigrationClassProvider, this.baselineVersion, this.target, this.locations, this.schemas, this.sqlMigrationSuffixes, this.javaMigrations, this.errorOverrides, this.placeholders, this.jdbcProperties, this.cherryPick, this.table, this.tablespace, this.defaultSchemaName, this.baselineDescription, this.undoSqlMigrationPrefix, this.repeatableSqlMigrationPrefix, this.sqlMigrationSeparator, this.sqlMigrationPrefix, this.placeholderPrefix, this.placeholderSuffix, this.encoding, this.initSql, this.licenseKey, this.url, this.user, this.password, this.skipDefaultResolvers, this.skipDefaultCallbacks, this.skipExecutingMigrations, this.placeholderReplacement, this.baselineOnMigrate, this.outOfOrder, this.ignoreMissingMigrations, this.ignoreIgnoredMigrations, this.ignorePendingMigrations, this.ignoreFutureMigrations, this.validateMigrationNaming, this.validateOnMigrate, this.cleanOnValidationError, this.cleanDisabled, this.allowMixedMigrations, this.createSchemas, this.mixed, this.group, this.installedBy, this.dryRun, this.stream, this.batch, this.oracleSqlPlus, this.oracleSqlplusWarn, this.oracleKerberosConfigFile, this.oracleKerberosCacheFile, this.outputQueryResults, this.connectRetries, this.lockRetryCount, this.conjurUrl, this.conjurToken, this.vaultUrl, this.vaultToken, this.vaultSecrets);
    }
}

