/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.flyway;

import com.google.common.collect.ObjectArrays;
import io.zonky.test.db.flyway.FlywayClassUtils;
import io.zonky.test.db.flyway.FlywayDataSourceContext;
import io.zonky.test.db.logging.EmbeddedDatabaseReporter;
import io.zonky.test.db.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.lang3.ArrayUtils;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.util.scanner.Scanner;
import org.flywaydb.test.annotation.FlywayTest;
import org.flywaydb.test.annotation.FlywayTests;
import org.flywaydb.test.junit.FlywayTestExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.TestContext;
import org.springframework.util.ClassUtils;

public class OptimizedFlywayTestExecutionListener
extends FlywayTestExecutionListener
implements Ordered {
    private static final Logger logger = LoggerFactory.getLogger(OptimizedFlywayTestExecutionListener.class);
    private static final ClassLoader classLoader = OptimizedFlywayTestExecutionListener.class.getClassLoader();
    private static final boolean flywayNameAttributePresent = FlywayClassUtils.isFlywayNameAttributePresent();
    private static final boolean flywayBaselineAttributePresent = FlywayClassUtils.isFlywayBaselineAttributePresent();
    private static final boolean repeatableAnnotationPresent = FlywayClassUtils.isRepeatableFlywayTestAnnotationPresent();
    private static final int flywayVersion = FlywayClassUtils.getFlywayVersion();
    private int order = 3900;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void beforeTestClass(TestContext testContext) throws Exception {
        Class testClass = testContext.getTestClass();
        FlywayTest[] annotations = this.findFlywayTestAnnotations(testClass);
        if (annotations.length > 1) {
            logger.warn("Optimized database loading is not supported when using multiple flyway test annotations");
        }
        for (FlywayTest annotation : annotations) {
            this.optimizedDbReset(testContext, testClass, annotation);
        }
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        Method testMethod = testContext.getTestMethod();
        FlywayTest[] annotations = this.findFlywayTestAnnotations(testMethod);
        if (annotations.length > 1) {
            logger.warn("Optimized database loading is not supported when using multiple flyway test annotations");
        }
        for (FlywayTest annotation : annotations) {
            this.optimizedDbReset(testContext, testMethod, annotation);
        }
    }

    protected FlywayTest[] findFlywayTestAnnotations(AnnotatedElement element) {
        FlywayTests containerAnnotation;
        if (repeatableAnnotationPresent && (containerAnnotation = OptimizedFlywayTestExecutionListener.findAnnotation(element, FlywayTests.class)) != null) {
            return containerAnnotation.value();
        }
        FlywayTest annotation = OptimizedFlywayTestExecutionListener.findAnnotation(element, FlywayTest.class);
        if (annotation != null) {
            return new FlywayTest[]{annotation};
        }
        return new FlywayTest[0];
    }

    protected synchronized void optimizedDbReset(TestContext testContext, AnnotatedElement element, FlywayTest annotation) throws Exception {
        try {
            FlywayDataSourceContext dataSourceContext;
            ApplicationContext applicationContext;
            Flyway flywayBean;
            if (annotation != null && annotation.invokeCleanDB() && annotation.invokeMigrateDB() && (!flywayBaselineAttributePresent || !annotation.invokeBaselineDB()) && (flywayBean = this.getFlywayBean(applicationContext = testContext.getApplicationContext(), annotation)) != null && (dataSourceContext = OptimizedFlywayTestExecutionListener.getDataSourceContext(applicationContext, flywayBean)) != null) {
                dataSourceContext.getTarget();
                DataSource dataSource = OptimizedFlywayTestExecutionListener.reloadDataSource(dataSourceContext, flywayBean, annotation);
                EmbeddedDatabaseReporter.reportDataSource(dataSource, element);
                FlywayTest adjustedAnnotation = OptimizedFlywayTestExecutionListener.copyAnnotation(annotation, false, false, true);
                this.originalDbReset(testContext, adjustedAnnotation);
                return;
            }
            this.originalDbReset(testContext, annotation);
        }
        catch (NoSuchMethodError e) {
            logger.error("\n\nHINT: Check that you are using compatible versions of org.flywaydb:flyway-core and org.flywaydb.flyway-test-extensions:flyway-spring-test dependencies!!!\n");
            throw e;
        }
    }

    protected void originalDbReset(TestContext testContext, FlywayTest annotation) {
        try {
            String dbResetMethodName = repeatableAnnotationPresent ? "dbResetWithAnnotation" : "dbResetWithAnotation";
            ReflectionUtils.invokeMethod((Object)this, dbResetMethodName, testContext, annotation);
        }
        catch (FlywayException e) {
            String errorCode;
            if (e.getCause() instanceof SQLException && (errorCode = ((SQLException)e.getCause()).getSQLState()) != null && errorCode.matches("(42723|42P06|42P07|42712|42710)")) {
                logger.error("\n\nHINT: Check that you have correctly set org.flywaydb.core.Flyway#schemaNames property!!!\n");
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DataSource reloadDataSource(FlywayDataSourceContext dataSourceContext, Flyway flywayBean, FlywayTest annotation) throws Exception {
        if (OptimizedFlywayTestExecutionListener.isAppendable(flywayBean, annotation)) {
            return (DataSource)dataSourceContext.reload(flywayBean).get();
        }
        Object[] oldLocations = OptimizedFlywayTestExecutionListener.getFlywayLocations(flywayBean);
        try {
            if (annotation.overrideLocations()) {
                OptimizedFlywayTestExecutionListener.setFlywayLocations(flywayBean, annotation.locationsForMigrate());
            } else {
                OptimizedFlywayTestExecutionListener.setFlywayLocations(flywayBean, (String[])ObjectArrays.concat((Object[])oldLocations, (Object[])annotation.locationsForMigrate(), String.class));
            }
            DataSource dataSource = (DataSource)dataSourceContext.reload(flywayBean).get();
            return dataSource;
        }
        finally {
            OptimizedFlywayTestExecutionListener.setFlywayLocations(flywayBean, (String[])oldLocations);
        }
    }

    protected static boolean isAppendable(Flyway flyway, FlywayTest annotation) throws ClassNotFoundException {
        if (annotation.overrideLocations()) {
            return false;
        }
        if (ArrayUtils.isEmpty((Object[])annotation.locationsForMigrate())) {
            return true;
        }
        MigrationVersion testVersion = OptimizedFlywayTestExecutionListener.findFirstVersion(flyway, annotation.locationsForMigrate());
        if (testVersion == MigrationVersion.EMPTY) {
            return true;
        }
        MigrationVersion coreVersion = OptimizedFlywayTestExecutionListener.findLastVersion(flyway, OptimizedFlywayTestExecutionListener.getFlywayLocations(flyway));
        return coreVersion.compareTo(testVersion) < 0;
    }

    protected static MigrationVersion findFirstVersion(Flyway flyway, String ... locations) throws ClassNotFoundException {
        Collection<ResolvedMigration> migrations = OptimizedFlywayTestExecutionListener.resolveMigrations(flyway, locations);
        return migrations.stream().filter(migration -> migration.getVersion() != null).findFirst().map(ResolvedMigration::getVersion).orElse(MigrationVersion.EMPTY);
    }

    protected static MigrationVersion findLastVersion(Flyway flyway, String ... locations) throws ClassNotFoundException {
        Collection<ResolvedMigration> migrations = OptimizedFlywayTestExecutionListener.resolveMigrations(flyway, locations);
        return migrations.stream().filter(migration -> migration.getVersion() != null).reduce((first, second) -> second).map(ResolvedMigration::getVersion).orElse(MigrationVersion.EMPTY);
    }

    protected static Collection<ResolvedMigration> resolveMigrations(Flyway flyway, String ... locations) throws ClassNotFoundException {
        MigrationResolver resolver = OptimizedFlywayTestExecutionListener.createMigrationResolver(flyway, locations);
        if (flywayVersion >= 52) {
            Object configInstance = ReflectionUtils.getField(flyway, "configuration");
            Class contextType = ClassUtils.forName((String)"org.flywaydb.core.api.resolver.Context", (ClassLoader)classLoader);
            Object contextInstance = ProxyFactory.getProxy((Class)contextType, (Interceptor)((MethodInterceptor)invocation -> "getConfiguration".equals(invocation.getMethod().getName()) ? configInstance : invocation.proceed()));
            return (Collection)ReflectionUtils.invokeMethod(resolver, "resolveMigrations", contextInstance);
        }
        return resolver.resolveMigrations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MigrationResolver createMigrationResolver(Flyway flyway, String ... locations) throws ClassNotFoundException {
        String[] oldLocations = OptimizedFlywayTestExecutionListener.getFlywayLocations(flyway);
        try {
            OptimizedFlywayTestExecutionListener.setFlywayLocations(flyway, locations);
            if (flywayVersion >= 63) {
                Object scanner = OptimizedFlywayTestExecutionListener.createScanner(flyway);
                Object sqlScriptFactory = OptimizedFlywayTestExecutionListener.createMock("org.flywaydb.core.internal.sqlscript.SqlScriptFactory");
                Object sqlScriptExecutorFactory = OptimizedFlywayTestExecutionListener.createMock("org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory");
                Object parsingContext = ReflectionUtils.invokeConstructor("org.flywaydb.core.internal.parser.ParsingContext", new Object[0]);
                MigrationResolver migrationResolver = (MigrationResolver)ReflectionUtils.invokeMethod(flyway, "createMigrationResolver", scanner, scanner, sqlScriptExecutorFactory, sqlScriptFactory, parsingContext);
                return migrationResolver;
            }
            if (flywayVersion >= 60) {
                Object scanner = OptimizedFlywayTestExecutionListener.createScanner(flyway);
                Object sqlScriptFactory = OptimizedFlywayTestExecutionListener.createMock("org.flywaydb.core.internal.sqlscript.SqlScriptFactory");
                Object sqlScriptExecutorFactory = OptimizedFlywayTestExecutionListener.createMock("org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory");
                MigrationResolver migrationResolver = (MigrationResolver)ReflectionUtils.invokeMethod(flyway, "createMigrationResolver", scanner, scanner, sqlScriptExecutorFactory, sqlScriptFactory);
                return migrationResolver;
            }
            if (flywayVersion >= 52) {
                Object scanner = OptimizedFlywayTestExecutionListener.createScanner(flyway);
                Object placeholderReplacer = OptimizedFlywayTestExecutionListener.createMock("org.flywaydb.core.internal.placeholder.PlaceholderReplacer");
                Object factory = ReflectionUtils.invokeConstructor("org.flywaydb.core.internal.database.postgresql.PostgreSQLSqlStatementBuilderFactory", placeholderReplacer);
                MigrationResolver migrationResolver = (MigrationResolver)ReflectionUtils.invokeMethod(flyway, "createMigrationResolver", null, scanner, scanner, factory);
                return migrationResolver;
            }
            if (flywayVersion >= 51) {
                Object scanner = OptimizedFlywayTestExecutionListener.createScanner(flyway);
                Object placeholderReplacer = ReflectionUtils.invokeMethod(flyway, "createPlaceholderReplacer", new Object[0]);
                MigrationResolver migrationResolver = (MigrationResolver)ReflectionUtils.invokeMethod(flyway, "createMigrationResolver", null, scanner, placeholderReplacer);
                return migrationResolver;
            }
            if (flywayVersion >= 40) {
                Scanner scanner = new Scanner(flyway.getClassLoader());
                MigrationResolver migrationResolver = (MigrationResolver)ReflectionUtils.invokeMethod(flyway, "createMigrationResolver", null, scanner);
                return migrationResolver;
            }
            MigrationResolver migrationResolver = (MigrationResolver)ReflectionUtils.invokeMethod(flyway, "createMigrationResolver", new Object[]{null});
            return migrationResolver;
        }
        finally {
            OptimizedFlywayTestExecutionListener.setFlywayLocations(flyway, oldLocations);
        }
    }

    protected static Object createScanner(Flyway flyway) throws ClassNotFoundException {
        Object configuration;
        block10: {
            configuration = ReflectionUtils.getField(flyway, "configuration");
            if (flywayVersion >= 70) {
                return ReflectionUtils.invokeConstructor("org.flywaydb.core.internal.scanner.Scanner", ClassUtils.forName((String)"org.flywaydb.core.api.migration.JavaMigration", (ClassLoader)classLoader), Arrays.asList((Object[])ReflectionUtils.invokeMethod(configuration, "getLocations", new Object[0])), ReflectionUtils.invokeMethod(configuration, "getClassLoader", new Object[0]), ReflectionUtils.invokeMethod(configuration, "getEncoding", new Object[0]), false, ReflectionUtils.getField(flyway, "resourceNameCache"), ReflectionUtils.getField(flyway, "locationScannerCache"));
            }
            if (flywayVersion >= 63) {
                try {
                    return ReflectionUtils.invokeConstructor("org.flywaydb.core.internal.scanner.Scanner", ClassUtils.forName((String)"org.flywaydb.core.api.migration.JavaMigration", (ClassLoader)classLoader), Arrays.asList((Object[])ReflectionUtils.invokeMethod(configuration, "getLocations", new Object[0])), ReflectionUtils.invokeMethod(configuration, "getClassLoader", new Object[0]), ReflectionUtils.invokeMethod(configuration, "getEncoding", new Object[0]), ReflectionUtils.getField(flyway, "resourceNameCache"), ReflectionUtils.getField(flyway, "locationScannerCache"));
                }
                catch (RuntimeException ex) {
                    if (flywayVersion <= 63) break block10;
                    throw ex;
                }
            }
        }
        if (flywayVersion >= 61) {
            return ReflectionUtils.invokeConstructor("org.flywaydb.core.internal.scanner.Scanner", ClassUtils.forName((String)"org.flywaydb.core.api.migration.JavaMigration", (ClassLoader)classLoader), Arrays.asList((Object[])ReflectionUtils.invokeMethod(configuration, "getLocations", new Object[0])), ReflectionUtils.invokeMethod(configuration, "getClassLoader", new Object[0]), ReflectionUtils.invokeMethod(configuration, "getEncoding", new Object[0]), ReflectionUtils.getField(flyway, "resourceNameCache"));
        }
        if (flywayVersion >= 60) {
            try {
                return ReflectionUtils.invokeConstructor("org.flywaydb.core.internal.scanner.Scanner", ClassUtils.forName((String)"org.flywaydb.core.api.migration.JavaMigration", (ClassLoader)classLoader), Arrays.asList((Object[])ReflectionUtils.invokeMethod(configuration, "getLocations", new Object[0])), ReflectionUtils.invokeMethod(configuration, "getClassLoader", new Object[0]), ReflectionUtils.invokeMethod(configuration, "getEncoding", new Object[0]));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (flywayVersion >= 52) {
            return ReflectionUtils.invokeConstructor("org.flywaydb.core.internal.scanner.Scanner", Arrays.asList((Object[])ReflectionUtils.invokeMethod(configuration, "getLocations", new Object[0])), ReflectionUtils.invokeMethod(configuration, "getClassLoader", new Object[0]), ReflectionUtils.invokeMethod(configuration, "getEncoding", new Object[0]));
        }
        if (flywayVersion >= 51) {
            return ReflectionUtils.invokeConstructor(Scanner.class, configuration);
        }
        throw new IllegalStateException("Unsupported flyway version: " + flywayVersion);
    }

    protected static Object createMock(String className) throws ClassNotFoundException {
        Class proxyInterface = ClassUtils.forName((String)className, (ClassLoader)classLoader);
        return ProxyFactory.getProxy((Class)proxyInterface, (Interceptor)((MethodInterceptor)invocation -> null));
    }

    protected Flyway getFlywayBean(ApplicationContext applicationContext, FlywayTest annotation) {
        if (flywayNameAttributePresent) {
            return (Flyway)ReflectionUtils.invokeMethod((Object)this, "getBean", applicationContext, Flyway.class, annotation.flywayName());
        }
        return (Flyway)ReflectionUtils.invokeMethod((Object)this, "getBean", applicationContext, Flyway.class);
    }

    protected static String[] getFlywayLocations(Flyway flyway) {
        if (flywayVersion >= 51) {
            Object configuration = ReflectionUtils.getField(flyway, "configuration");
            return (String[])Arrays.stream((Object[])ReflectionUtils.invokeMethod(configuration, "getLocations", new Object[0])).map(location -> ReflectionUtils.invokeMethod(location, "getDescriptor", new Object[0])).toArray(String[]::new);
        }
        return flyway.getLocations();
    }

    protected static void setFlywayLocations(Flyway flyway, String[] locations) {
        if (flywayVersion >= 51) {
            Object configuration = ReflectionUtils.getField(flyway, "configuration");
            ReflectionUtils.invokeMethod(configuration, "setLocationsAsStrings", new Object[]{locations});
        } else {
            flyway.setLocations(locations);
        }
    }

    protected static FlywayDataSourceContext getDataSourceContext(ApplicationContext context, Flyway flywayBean) {
        Map flywayBeans = context.getBeansOfType(Flyway.class);
        String flywayBeanName = flywayBeans.entrySet().stream().filter(e -> e.getValue() == flywayBean).map(Map.Entry::getKey).findFirst().orElse("default");
        try {
            return (FlywayDataSourceContext)context.getBean(flywayBeanName + "DataSourceContext", FlywayDataSourceContext.class);
        }
        catch (BeansException beansException) {
            try {
                return (FlywayDataSourceContext)context.getBean(FlywayDataSourceContext.class);
            }
            catch (BeansException beansException2) {
                return null;
            }
        }
    }

    protected static <A extends Annotation> A findAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType) {
        if (annotatedElement instanceof Class) {
            return (A)AnnotationUtils.findAnnotation((Class)((Class)annotatedElement), annotationType);
        }
        if (annotatedElement instanceof Method) {
            return (A)AnnotationUtils.findAnnotation((Method)((Method)annotatedElement), annotationType);
        }
        return (A)AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, annotationType);
    }

    private static FlywayTest copyAnnotation(FlywayTest annotation, boolean invokeCleanDB, boolean invokeBaselineDB, boolean invokeMigrateDB) {
        Map attributes = AnnotationUtils.getAnnotationAttributes((Annotation)annotation);
        attributes.put("invokeCleanDB", invokeCleanDB);
        attributes.put("invokeBaselineDB", invokeBaselineDB);
        attributes.put("invokeMigrateDB", invokeMigrateDB);
        return (FlywayTest)AnnotationUtils.synthesizeAnnotation((Map)attributes, FlywayTest.class, null);
    }
}

