/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db;

import io.zonky.test.db.AutoConfigureEmbeddedDatabase;
import io.zonky.test.db.config.EmbeddedDatabaseAutoConfiguration;
import io.zonky.test.db.context.DatabaseContext;
import io.zonky.test.db.context.DefaultDatabaseContext;
import io.zonky.test.db.context.EmbeddedDatabaseFactoryBean;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableMap;
import io.zonky.test.db.support.DatabaseDefinition;
import io.zonky.test.db.support.DatabaseProviders;
import io.zonky.test.db.support.ProviderDescriptor;
import io.zonky.test.db.support.ProviderResolver;
import io.zonky.test.db.util.AnnotationUtils;
import io.zonky.test.db.util.PropertyUtils;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class EmbeddedDatabaseContextCustomizerFactory
implements ContextCustomizerFactory {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedDatabaseContextCustomizerFactory.class);

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        Set<AutoConfigureEmbeddedDatabase> annotations = AnnotationUtils.getDatabaseAnnotations(testClass);
        if (!annotations.isEmpty()) {
            Set definitions = annotations.stream().filter(annotation -> annotation.replace() != AutoConfigureEmbeddedDatabase.Replace.NONE).map(a -> new DatabaseDefinition(a.beanName(), a.type(), a.provider())).collect(Collectors.toCollection(LinkedHashSet::new));
            return new EmbeddedDatabaseContextCustomizer(definitions);
        }
        return null;
    }

    protected static AutoConfigureEmbeddedDatabase.Replace getDatabaseReplaceMode(Environment environment, Set<DatabaseDefinition> databaseDefinitions) {
        return databaseDefinitions.isEmpty() ? AutoConfigureEmbeddedDatabase.Replace.NONE : PropertyUtils.getEnumProperty(environment, "zonky.test.database.replace", AutoConfigureEmbeddedDatabase.Replace.class, AutoConfigureEmbeddedDatabase.Replace.ANY);
    }

    protected static BeanDefinitionRegistry getBeanDefinitionRegistry(ApplicationContext context) {
        if (context instanceof BeanDefinitionRegistry) {
            return (BeanDefinitionRegistry)context;
        }
        if (context instanceof AbstractApplicationContext) {
            return (BeanDefinitionRegistry)((AbstractApplicationContext)context).getBeanFactory();
        }
        throw new IllegalStateException("Could not locate BeanDefinitionRegistry");
    }

    protected static BeanDefinitionHolder getDataSourceBeanDefinition(ConfigurableListableBeanFactory beanFactory, DatabaseDefinition databaseDefinition) {
        if (StringUtils.hasText((String)databaseDefinition.getBeanName())) {
            if (beanFactory.containsBean(databaseDefinition.getBeanName())) {
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition(databaseDefinition.getBeanName());
                return new BeanDefinitionHolder(beanDefinition, databaseDefinition.getBeanName());
            }
            return new BeanDefinitionHolder((BeanDefinition)new RootBeanDefinition(), databaseDefinition.getBeanName());
        }
        Object[] beanNames = beanFactory.getBeanNamesForType(DataSource.class);
        if (ObjectUtils.isEmpty((Object[])beanNames)) {
            return new BeanDefinitionHolder((BeanDefinition)new RootBeanDefinition(), "dataSource");
        }
        if (beanNames.length == 1) {
            Object beanName = beanNames[0];
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
            return new BeanDefinitionHolder(beanDefinition, (String)beanName);
        }
        for (Object beanName : beanNames) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
            if (!beanDefinition.isPrimary()) continue;
            return new BeanDefinitionHolder(beanDefinition, (String)beanName);
        }
        throw new IllegalStateException("No primary DataSource found, embedded version will not be used");
    }

    protected static class EmbeddedDatabaseRegistrar
    implements BeanDefinitionRegistryPostProcessor,
    EnvironmentAware {
        protected static final String BEAN_NAME = EmbeddedDatabaseRegistrar.class.getName();
        private final Set<DatabaseDefinition> databaseDefinitions;
        private Environment environment;

        public EmbeddedDatabaseRegistrar(Set<DatabaseDefinition> databaseDefinitions) {
            this.databaseDefinitions = databaseDefinitions;
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
            AutoConfigureEmbeddedDatabase.Replace replace;
            Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)registry, (String)"Embedded Database Auto-configuration can only be used with a ConfigurableListableBeanFactory");
            ConfigurableListableBeanFactory beanFactory = (ConfigurableListableBeanFactory)registry;
            if (registry.containsBeanDefinition("embeddedDataSource1")) {
                registry.removeBeanDefinition("embeddedDataSource1");
            }
            if (registry.containsBeanDefinition("embeddedDataSource2")) {
                registry.removeBeanDefinition("embeddedDataSource2");
            }
            if ((replace = EmbeddedDatabaseContextCustomizerFactory.getDatabaseReplaceMode(this.environment, this.databaseDefinitions)) == AutoConfigureEmbeddedDatabase.Replace.NONE) {
                logger.info("The use of the embedded database has been disabled");
                return;
            }
            for (DatabaseDefinition databaseDefinition : this.databaseDefinitions) {
                BeanDefinitionHolder dataSourceInfo = EmbeddedDatabaseContextCustomizerFactory.getDataSourceBeanDefinition(beanFactory, databaseDefinition);
                String dataSourceBeanName = dataSourceInfo.getBeanName();
                String contextBeanName = dataSourceBeanName + "Context";
                RootBeanDefinition contextDefinition = new RootBeanDefinition();
                contextDefinition.setBeanClass(DefaultDatabaseContext.class);
                contextDefinition.setPrimary(dataSourceInfo.getBeanDefinition().isPrimary());
                contextDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, () -> {
                    ProviderResolver providerResolver = (ProviderResolver)beanFactory.getBean(ProviderResolver.class);
                    DatabaseProviders databaseProviders = (DatabaseProviders)beanFactory.getBean(DatabaseProviders.class);
                    ProviderDescriptor providerDescriptor = providerResolver.getDescriptor(databaseDefinition);
                    return databaseProviders.getProvider(providerDescriptor);
                });
                RootBeanDefinition dataSourceDefinition = new RootBeanDefinition();
                dataSourceDefinition.setBeanClass(EmbeddedDatabaseFactoryBean.class);
                dataSourceDefinition.setPrimary(dataSourceInfo.getBeanDefinition().isPrimary());
                dataSourceDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, () -> (DatabaseContext)beanFactory.getBean(contextBeanName, DatabaseContext.class));
                logger.info("Replacing '{}' DataSource bean with embedded version", (Object)dataSourceBeanName);
                if (registry.containsBeanDefinition(dataSourceBeanName)) {
                    registry.removeBeanDefinition(dataSourceBeanName);
                }
                registry.registerBeanDefinition(contextBeanName, (BeanDefinition)contextDefinition);
                registry.registerBeanDefinition(dataSourceBeanName, (BeanDefinition)dataSourceDefinition);
            }
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        }
    }

    @Configuration
    @Import(value={Selector.class})
    protected static class EmbeddedDatabaseConfiguration {
        protected static final String BEAN_NAME = EmbeddedDatabaseConfiguration.class.getName();

        protected EmbeddedDatabaseConfiguration() {
        }

        protected static class Selector
        implements DeferredImportSelector,
        Ordered {
            protected Selector() {
            }

            public String[] selectImports(AnnotationMetadata importingClassMetadata) {
                return new String[]{EmbeddedDatabaseAutoConfiguration.class.getName()};
            }

            public int getOrder() {
                return Integer.MAX_VALUE;
            }
        }
    }

    @Configuration
    protected static class SecondaryDataSourceAutoConfiguration {
        protected SecondaryDataSourceAutoConfiguration() {
        }

        @Bean
        @ConditionalOnSingleCandidate
        public DataSource embeddedDataSource2() {
            return null;
        }
    }

    @Configuration
    protected static class PrimaryDataSourceAutoConfiguration {
        protected PrimaryDataSourceAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public DataSource embeddedDataSource1() {
            return null;
        }
    }

    protected static class PreAutoConfigurationImportSelector
    implements DeferredImportSelector,
    Ordered {
        protected PreAutoConfigurationImportSelector() {
        }

        public String[] selectImports(AnnotationMetadata annotationMetadata) {
            if (!ClassUtils.isPresent((String)"org.springframework.boot.autoconfigure.condition.ConditionalOnBean", null)) {
                return new String[0];
            }
            String className = annotationMetadata.getClassName();
            if (SingleDatabaseConfiguration.BEAN_NAME.equals(className)) {
                return new String[]{PrimaryDataSourceAutoConfiguration.class.getName()};
            }
            if (MultipleDatabasesConfiguration.BEAN_NAME.equals(className)) {
                return new String[]{PrimaryDataSourceAutoConfiguration.class.getName(), SecondaryDataSourceAutoConfiguration.class.getName()};
            }
            throw new IllegalStateException("Unexpected selector configuration class: " + className);
        }

        public int getOrder() {
            return 0x7FFFFFFC;
        }
    }

    @Configuration
    @Import(value={PreAutoConfigurationImportSelector.class})
    protected static class MultipleDatabasesConfiguration {
        protected static final String BEAN_NAME = MultipleDatabasesConfiguration.class.getName();

        protected MultipleDatabasesConfiguration() {
        }
    }

    @Configuration
    @Import(value={PreAutoConfigurationImportSelector.class})
    protected static class SingleDatabaseConfiguration {
        protected static final String BEAN_NAME = SingleDatabaseConfiguration.class.getName();

        protected SingleDatabaseConfiguration() {
        }
    }

    protected static class EnvironmentPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        private final ConfigurableEnvironment environment;

        public EnvironmentPostProcessor(ConfigurableEnvironment environment) {
            this.environment = environment;
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
            this.environment.getPropertySources().addFirst((PropertySource)new MapPropertySource(EmbeddedDatabaseContextCustomizer.class.getSimpleName(), ImmutableMap.of("spring.test.database.replace", "NONE")));
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        }
    }

    protected static class EmbeddedDatabaseContextCustomizer
    implements ContextCustomizer {
        private final Set<DatabaseDefinition> databaseDefinitions;

        public EmbeddedDatabaseContextCustomizer(Set<DatabaseDefinition> databaseDefinitions) {
            this.databaseDefinitions = databaseDefinitions;
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
            RootBeanDefinition preConfigDefinition;
            context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new EnvironmentPostProcessor(context.getEnvironment()));
            BeanDefinitionRegistry registry = EmbeddedDatabaseContextCustomizerFactory.getBeanDefinitionRegistry((ApplicationContext)context);
            if (this.databaseDefinitions.size() == 1) {
                preConfigDefinition = new RootBeanDefinition(SingleDatabaseConfiguration.class);
                registry.registerBeanDefinition(SingleDatabaseConfiguration.BEAN_NAME, (BeanDefinition)preConfigDefinition);
            } else if (this.databaseDefinitions.size() > 1) {
                preConfigDefinition = new RootBeanDefinition(MultipleDatabasesConfiguration.class);
                registry.registerBeanDefinition(MultipleDatabasesConfiguration.BEAN_NAME, (BeanDefinition)preConfigDefinition);
            }
            RootBeanDefinition mainConfigDefinition = new RootBeanDefinition(EmbeddedDatabaseConfiguration.class);
            registry.registerBeanDefinition(EmbeddedDatabaseConfiguration.BEAN_NAME, (BeanDefinition)mainConfigDefinition);
            RootBeanDefinition registrarDefinition = new RootBeanDefinition(EmbeddedDatabaseRegistrar.class);
            registrarDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, this.databaseDefinitions);
            registry.registerBeanDefinition(EmbeddedDatabaseRegistrar.BEAN_NAME, (BeanDefinition)registrarDefinition);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EmbeddedDatabaseContextCustomizer that = (EmbeddedDatabaseContextCustomizer)o;
            return this.databaseDefinitions.equals(that.databaseDefinitions);
        }

        public int hashCode() {
            return this.databaseDefinitions.hashCode();
        }
    }
}

