/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.flyway;

import io.zonky.test.db.context.DatabaseContext;
import io.zonky.test.db.flyway.FlywayClassUtils;
import io.zonky.test.db.flyway.FlywayDescriptor;
import io.zonky.test.db.flyway.FlywayWrapper;
import io.zonky.test.db.flyway.preparer.BaselineFlywayDatabasePreparer;
import io.zonky.test.db.flyway.preparer.CleanFlywayDatabasePreparer;
import io.zonky.test.db.flyway.preparer.FlywayDatabasePreparer;
import io.zonky.test.db.flyway.preparer.MigrateFlywayDatabasePreparer;
import io.zonky.test.db.shaded.com.google.common.base.Preconditions;
import io.zonky.test.db.shaded.com.google.common.collect.HashMultimap;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableList;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableSet;
import io.zonky.test.db.shaded.com.google.common.collect.Iterables;
import io.zonky.test.db.shaded.com.google.common.collect.Lists;
import io.zonky.test.db.shaded.com.google.common.collect.Multimap;
import io.zonky.test.db.util.AopProxyUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.NameMatchMethodPointcutAdvisor;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class FlywayDatabaseExtension
implements BeanPostProcessor {
    private static final int flywayVersion = FlywayClassUtils.getFlywayVersion();
    private static final ConcurrentMap<FlywayDescriptor, Collection<ResolvedMigration>> resolvedMigrationsCache = new ConcurrentHashMap<FlywayDescriptor, Collection<ResolvedMigration>>();
    protected final Multimap<DatabaseContext, Flyway> flywayBeans = HashMultimap.create();
    protected final BlockingQueue<FlywayOperation> pendingOperations = new LinkedBlockingQueue<FlywayOperation>();

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        Flyway flyway;
        FlywayWrapper wrapper;
        DatabaseContext context;
        if (bean instanceof AopInfrastructureBean) {
            return bean;
        }
        if (bean instanceof Flyway && (context = AopProxyUtils.getDatabaseContext((wrapper = FlywayWrapper.forBean(flyway = (Flyway)bean)).getDataSource())) != null) {
            this.flywayBeans.put(context, flyway);
            if (bean instanceof Advised && !((Advised)bean).isFrozen()) {
                ((Advised)bean).addAdvisor(0, this.createAdvisor(wrapper));
                return bean;
            }
            ProxyFactory proxyFactory = new ProxyFactory(bean);
            proxyFactory.addAdvisor(this.createAdvisor(wrapper));
            proxyFactory.setProxyTargetClass(true);
            return proxyFactory.getProxy();
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }

    void processPendingOperations() {
        LinkedList pendingOperations = new LinkedList();
        this.pendingOperations.drainTo(pendingOperations);
        Map<DatabaseContext, List<FlywayOperation>> databaseOperations = pendingOperations.stream().collect(Collectors.groupingBy(operation -> this.getDatabaseContext(operation.getFlywayWrapper())));
        for (Map.Entry<DatabaseContext, List<FlywayOperation>> entry : databaseOperations.entrySet()) {
            DatabaseContext databaseContext = entry.getKey();
            List<FlywayOperation> flywayOperations = entry.getValue();
            Function<FlywayOperation, Set> schemaExtractor = op -> ImmutableSet.copyOf(op.getFlywayWrapper().getSchemas());
            if (this.flywayBeans.get(databaseContext).size() == 1 && flywayOperations.stream().map(schemaExtractor).distinct().count() == 1L && (flywayOperations = this.squashOperations(flywayOperations)).size() == 2 && flywayOperations.get(0).isClean() && flywayOperations.get(1).isMigrate()) {
                FlywayOperation flywayOperation = flywayOperations.get(1);
                databaseContext.reset();
                if (this.isAppendable(flywayOperation)) {
                    this.applyTestMigrations(flywayOperation);
                    continue;
                }
            }
            flywayOperations.forEach(operation -> databaseContext.apply(operation.getPreparer()));
        }
    }

    protected Advisor createAdvisor(FlywayWrapper wrapper) {
        FlywayDatabaseExtensionInterceptor advice = new FlywayDatabaseExtensionInterceptor(wrapper);
        NameMatchMethodPointcutAdvisor advisor = new NameMatchMethodPointcutAdvisor((Advice)advice);
        advisor.setMappedNames(new String[]{"clean", "baseline", "migrate"});
        return advisor;
    }

    protected DatabaseContext getDatabaseContext(FlywayWrapper wrapper) {
        DatabaseContext context = AopProxyUtils.getDatabaseContext(wrapper.getDataSource());
        Preconditions.checkState(context != null, "Data source context cannot be resolved");
        return context;
    }

    protected List<FlywayOperation> squashOperations(List<FlywayOperation> operations) {
        if (operations.stream().anyMatch(FlywayOperation::isBaseline)) {
            return operations;
        }
        int reverseIndex = Iterables.indexOf(Lists.reverse(operations), FlywayOperation::isClean);
        if (reverseIndex == -1) {
            return operations;
        }
        return operations.subList(operations.size() - 1 - reverseIndex, operations.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyTestMigrations(FlywayOperation operation) {
        FlywayWrapper flywayWrapper = operation.getFlywayWrapper();
        DatabaseContext databaseContext = this.getDatabaseContext(flywayWrapper);
        MigrateFlywayDatabasePreparer migratePreparer = (MigrateFlywayDatabasePreparer)operation.getPreparer();
        List<String> preparerLocations = migratePreparer.getDescriptor().getLocations();
        List<String> testLocations = this.resolveTestLocations(flywayWrapper, preparerLocations);
        if (!testLocations.isEmpty()) {
            List<String> defaultLocations = flywayWrapper.getLocations();
            boolean ignoreMissingMigrations = flywayWrapper.isIgnoreMissingMigrations();
            try {
                if (flywayVersion >= 41) {
                    flywayWrapper.setLocations(testLocations);
                    flywayWrapper.setIgnoreMissingMigrations(true);
                    FlywayDescriptor descriptor = FlywayDescriptor.from(flywayWrapper);
                    databaseContext.apply(new MigrateFlywayDatabasePreparer(descriptor));
                } else {
                    flywayWrapper.setLocations((List<String>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(defaultLocations)).addAll(testLocations)).build()));
                    FlywayDescriptor descriptor = FlywayDescriptor.from(flywayWrapper);
                    databaseContext.apply(new MigrateFlywayDatabasePreparer(descriptor, 100L));
                }
            }
            finally {
                flywayWrapper.setLocations(defaultLocations);
                flywayWrapper.setIgnoreMissingMigrations(ignoreMissingMigrations);
            }
        }
    }

    protected boolean isAppendable(FlywayOperation operation) {
        FlywayWrapper flywayWrapper = operation.getFlywayWrapper();
        MigrateFlywayDatabasePreparer migratePreparer = (MigrateFlywayDatabasePreparer)operation.getPreparer();
        return this.isAppendable(flywayWrapper, migratePreparer.getDescriptor().getLocations());
    }

    protected boolean isAppendable(FlywayWrapper flyway, List<String> locations) {
        List<String> defaultLocations = flyway.getLocations();
        if (!locations.containsAll(defaultLocations)) {
            return false;
        }
        List<String> testLocations = this.resolveTestLocations(flyway, locations);
        if (testLocations.isEmpty()) {
            return true;
        }
        MigrationVersion testFirstVersion = this.findFirstVersion(flyway, testLocations);
        if (testFirstVersion == MigrationVersion.EMPTY) {
            return true;
        }
        MigrationVersion coreLastVersion = this.findLastVersion(flyway, defaultLocations);
        return coreLastVersion.compareTo(testFirstVersion) < 0;
    }

    protected List<String> resolveTestLocations(FlywayWrapper flyway, List<String> locations) {
        List<String> defaultLocations = flyway.getLocations();
        ArrayList<String> testLocations = Lists.newArrayList(locations);
        testLocations.removeAll(defaultLocations);
        return testLocations;
    }

    protected MigrationVersion findFirstVersion(FlywayWrapper flyway, List<String> locations) {
        Collection<ResolvedMigration> migrations = this.resolveMigrations(flyway, locations);
        return migrations.stream().filter(migration -> migration.getVersion() != null).findFirst().map(ResolvedMigration::getVersion).orElse(MigrationVersion.EMPTY);
    }

    protected MigrationVersion findLastVersion(FlywayWrapper flyway, List<String> locations) {
        Collection<ResolvedMigration> migrations = this.resolveMigrations(flyway, locations);
        return migrations.stream().filter(migration -> migration.getVersion() != null).reduce((first, second) -> second).map(ResolvedMigration::getVersion).orElse(MigrationVersion.EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ResolvedMigration> resolveMigrations(FlywayWrapper flyway, List<String> locations) {
        List<String> oldLocations = flyway.getLocations();
        try {
            flyway.setLocations(locations);
            FlywayDescriptor descriptor = FlywayDescriptor.from(flyway);
            Collection collection = resolvedMigrationsCache.computeIfAbsent(descriptor, key -> flyway.getMigrations());
            return collection;
        }
        finally {
            flyway.setLocations(oldLocations);
        }
    }

    protected static class FlywayOperation {
        private final FlywayWrapper flywayWrapper;
        private final FlywayDatabasePreparer preparer;

        public FlywayOperation(FlywayWrapper flywayWrapper, FlywayDatabasePreparer preparer) {
            this.flywayWrapper = flywayWrapper;
            this.preparer = preparer;
        }

        public FlywayWrapper getFlywayWrapper() {
            return this.flywayWrapper;
        }

        public FlywayDatabasePreparer getPreparer() {
            return this.preparer;
        }

        public boolean isClean() {
            return this.preparer instanceof CleanFlywayDatabasePreparer;
        }

        public boolean isBaseline() {
            return this.preparer instanceof BaselineFlywayDatabasePreparer;
        }

        public boolean isMigrate() {
            return this.preparer instanceof MigrateFlywayDatabasePreparer;
        }
    }

    protected class FlywayDatabaseExtensionInterceptor
    implements MethodInterceptor {
        protected final FlywayWrapper flywayWrapper;

        protected FlywayDatabaseExtensionInterceptor(FlywayWrapper flywayWrapper) {
            this.flywayWrapper = flywayWrapper;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            switch (invocation.getMethod().getName()) {
                case "clean": {
                    return this.apply(CleanFlywayDatabasePreparer::new);
                }
                case "baseline": {
                    return this.apply(BaselineFlywayDatabasePreparer::new);
                }
                case "migrate": {
                    return this.apply(MigrateFlywayDatabasePreparer::new);
                }
            }
            return invocation.proceed();
        }

        protected Object apply(Function<FlywayDescriptor, FlywayDatabasePreparer> creator) {
            boolean standardListenerProcessing;
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            boolean contextLoading = Arrays.stream(stackTrace).anyMatch(e -> e.getClassName().endsWith("TestContext") && e.getMethodName().equals("getApplicationContext"));
            boolean listenerProcessing = !contextLoading && Arrays.stream(stackTrace).anyMatch(e -> e.getClassName().endsWith("FlywayTestExecutionListener") && (e.getMethodName().equals("dbResetWithAnnotation") || e.getMethodName().equals("dbResetWithAnotation")));
            boolean optimizedListenerProcessing = listenerProcessing && Arrays.stream(stackTrace).anyMatch(e -> e.getClassName().endsWith("OptimizedFlywayTestExecutionListener"));
            boolean bl = standardListenerProcessing = listenerProcessing && !optimizedListenerProcessing;
            if (standardListenerProcessing) {
                throw new IllegalStateException("Using org.flywaydb.test.FlywayTestExecutionListener and org.flywaydb.test.junit.FlywayTestExecutionListener is forbidden, use io.zonky.test.db.flyway.OptimizedFlywayTestExecutionListener instead");
            }
            FlywayDescriptor descriptor = FlywayDescriptor.from(this.flywayWrapper);
            FlywayDatabasePreparer preparer = creator.apply(descriptor);
            if (optimizedListenerProcessing) {
                FlywayDatabaseExtension.this.pendingOperations.add(new FlywayOperation(this.flywayWrapper, preparer));
            } else {
                DatabaseContext databaseContext = FlywayDatabaseExtension.this.getDatabaseContext(this.flywayWrapper);
                databaseContext.apply(preparer);
            }
            try {
                return preparer.getResult().get(0L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e2) {
                if (preparer instanceof MigrateFlywayDatabasePreparer && flywayVersion < 70) {
                    return 0;
                }
                return null;
            }
        }
    }
}

