/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.util;

import io.zonky.test.db.AutoConfigureEmbeddedDatabase;
import io.zonky.test.db.util.ReflectionUtils;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;

public class AnnotationUtils {
    private static final Class<?> testContextAnnotationUtilsClass;

    private AnnotationUtils() {
    }

    public static Set<AutoConfigureEmbeddedDatabase> getDatabaseAnnotations(Class<?> annotatedElement) {
        Set annotations = testContextAnnotationUtilsClass != null ? (Set)ReflectionUtils.invokeStaticMethod(testContextAnnotationUtilsClass, "getMergedRepeatableAnnotations", annotatedElement, AutoConfigureEmbeddedDatabase.class) : AnnotatedElementUtils.getMergedRepeatableAnnotations(annotatedElement, AutoConfigureEmbeddedDatabase.class);
        return annotations.stream().filter(AnnotationUtils.distinctByKey(AutoConfigureEmbeddedDatabase::beanName)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    static {
        Class targetClass;
        try {
            ClassLoader classLoader = AnnotationUtils.class.getClassLoader();
            targetClass = ClassUtils.forName((String)"org.springframework.test.context.TestContextAnnotationUtils", (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException e) {
            targetClass = null;
        }
        testContextAnnotationUtilsClass = targetClass;
    }
}

