/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db;

import io.zonky.test.db.AutoConfigureEmbeddedDatabase;
import io.zonky.test.db.context.DatabaseContext;
import io.zonky.test.db.preparer.DatabasePreparer;
import io.zonky.test.db.util.AnnotationUtils;
import io.zonky.test.db.util.PropertyUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Conventions;
import org.springframework.core.env.Environment;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.StringUtils;

public class EmbeddedDatabaseTestExecutionListener
extends AbstractTestExecutionListener {
    private static final String TEST_PREPARERS_ATTRIBUTE_PREFIX = Conventions.getQualifiedAttributeName(EmbeddedDatabaseTestExecutionListener.class, (String)"testClassPreparers");

    public int getOrder() {
        return 3800;
    }

    public void beforeTestClass(TestContext testContext) {
        this.resetDatabases(testContext, AutoConfigureEmbeddedDatabase.RefreshMode.BEFORE_CLASS, AutoConfigureEmbeddedDatabase.RefreshMode.BEFORE_EACH_TEST_METHOD);
    }

    public void prepareTestInstance(TestContext testContext) {
        this.captureTestClassPreparers(testContext, AutoConfigureEmbeddedDatabase.RefreshMode.BEFORE_EACH_TEST_METHOD, AutoConfigureEmbeddedDatabase.RefreshMode.AFTER_EACH_TEST_METHOD);
    }

    public void beforeTestMethod(TestContext testContext) {
        this.resetDatabasesAndApplyTestClassPreparers(testContext, AutoConfigureEmbeddedDatabase.RefreshMode.BEFORE_EACH_TEST_METHOD);
    }

    public void afterTestMethod(TestContext testContext) {
        this.resetDatabasesAndApplyTestClassPreparers(testContext, AutoConfigureEmbeddedDatabase.RefreshMode.AFTER_EACH_TEST_METHOD);
    }

    public void afterTestClass(TestContext testContext) {
        this.resetDatabases(testContext, AutoConfigureEmbeddedDatabase.RefreshMode.AFTER_CLASS, AutoConfigureEmbeddedDatabase.RefreshMode.AFTER_EACH_TEST_METHOD);
    }

    private void resetDatabases(TestContext testContext, AutoConfigureEmbeddedDatabase.RefreshMode ... refreshModes) {
        this.forEachDatabase(testContext, refreshModes, (context, annotation) -> context.reset());
    }

    private void resetDatabasesAndApplyTestClassPreparers(TestContext testContext, AutoConfigureEmbeddedDatabase.RefreshMode ... refreshModes) {
        this.forEachDatabase(testContext, refreshModes, (context, annotation) -> {
            context.reset();
            String attributeFullName = this.getTestPreparersAttributeName(testContext, annotation.beanName());
            if (testContext.hasAttribute(attributeFullName)) {
                List testPreparers = (List)testContext.getAttribute(attributeFullName);
                for (DatabasePreparer testPreparer : testPreparers) {
                    context.apply(testPreparer);
                }
            }
        });
    }

    private void captureTestClassPreparers(TestContext testContext, AutoConfigureEmbeddedDatabase.RefreshMode ... refreshModes) {
        this.forEachDatabase(testContext, refreshModes, (context, annotation) -> {
            String attributeFullName = this.getTestPreparersAttributeName(testContext, annotation.beanName());
            if (!testContext.hasAttribute(attributeFullName)) {
                List<DatabasePreparer> testPreparers = context.getTestPreparers();
                testContext.setAttribute(attributeFullName, testPreparers);
            }
        });
    }

    private void forEachDatabase(TestContext testContext, AutoConfigureEmbeddedDatabase.RefreshMode[] refreshModes, BiConsumer<DatabaseContext, AutoConfigureEmbeddedDatabase> action) {
        Set<AutoConfigureEmbeddedDatabase> annotations = AnnotationUtils.getDatabaseAnnotations(testContext.getTestClass());
        ApplicationContext applicationContext = testContext.getApplicationContext();
        Environment environment = applicationContext.getEnvironment();
        annotations.stream().filter(annotation -> this.isEnabled((AutoConfigureEmbeddedDatabase)annotation, environment)).filter(annotation -> this.hasAnyRefreshMode((AutoConfigureEmbeddedDatabase)annotation, refreshModes, environment)).forEach(annotation -> {
            DatabaseContext databaseContext = this.getDatabaseContext(applicationContext, annotation.beanName());
            action.accept(databaseContext, (AutoConfigureEmbeddedDatabase)annotation);
        });
    }

    private boolean isEnabled(AutoConfigureEmbeddedDatabase annotation, Environment environment) {
        AutoConfigureEmbeddedDatabase.Replace replace = annotation.replace() == AutoConfigureEmbeddedDatabase.Replace.NONE ? AutoConfigureEmbeddedDatabase.Replace.NONE : PropertyUtils.getEnumProperty(environment, "zonky.test.database.replace", AutoConfigureEmbeddedDatabase.Replace.class, AutoConfigureEmbeddedDatabase.Replace.ANY);
        return replace != AutoConfigureEmbeddedDatabase.Replace.NONE;
    }

    private boolean hasAnyRefreshMode(AutoConfigureEmbeddedDatabase annotation, AutoConfigureEmbeddedDatabase.RefreshMode[] refreshModes, Environment environment) {
        AutoConfigureEmbeddedDatabase.RefreshMode currentMode = annotation.refresh() != AutoConfigureEmbeddedDatabase.RefreshMode.NEVER ? annotation.refresh() : PropertyUtils.getEnumProperty(environment, "zonky.test.database.refresh", AutoConfigureEmbeddedDatabase.RefreshMode.class, AutoConfigureEmbeddedDatabase.RefreshMode.NEVER);
        return Arrays.stream(refreshModes).anyMatch(mode -> mode == currentMode);
    }

    private DatabaseContext getDatabaseContext(ApplicationContext applicationContext, String beanName) {
        if (StringUtils.hasText((String)beanName)) {
            String databaseContextBeanName = beanName + "Context";
            return (DatabaseContext)applicationContext.getBean(databaseContextBeanName, DatabaseContext.class);
        }
        return (DatabaseContext)applicationContext.getBean(DatabaseContext.class);
    }

    private String getTestPreparersAttributeName(TestContext testContext, String beanName) {
        String attributeQualifier = Conventions.getQualifiedAttributeName((Class)testContext.getTestClass(), (String)beanName);
        return TEST_PREPARERS_ATTRIBUTE_PREFIX + '.' + attributeQualifier;
    }
}

