/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.init;

import io.zonky.test.db.preparer.DatabasePreparer;
import io.zonky.test.db.shaded.com.google.common.base.MoreObjects;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;

public class ScriptDatabasePreparer
implements DatabasePreparer {
    private final List<String> scriptLocations;
    private final boolean continueOnError;
    private final String separator;
    private final Charset encoding;

    public ScriptDatabasePreparer(List<String> scriptLocations) {
        this.scriptLocations = scriptLocations;
        this.continueOnError = false;
        this.separator = ";";
        this.encoding = null;
    }

    public ScriptDatabasePreparer(List<String> scriptLocations, boolean continueOnError, String separator, Charset encoding) {
        this.scriptLocations = scriptLocations;
        this.continueOnError = continueOnError;
        this.separator = separator;
        this.encoding = encoding;
    }

    @Override
    public long estimatedDuration() {
        return 10L;
    }

    @Override
    public void prepare(DataSource dataSource) throws SQLException {
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        populator.setContinueOnError(this.continueOnError);
        populator.setSeparator(this.separator);
        if (this.encoding != null) {
            populator.setSqlScriptEncoding(this.encoding.name());
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (String scriptLocation : this.scriptLocations) {
            Resource resource = resolver.getResource(scriptLocation);
            populator.addScript(resource);
        }
        DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)dataSource);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptDatabasePreparer that = (ScriptDatabasePreparer)o;
        return this.continueOnError == that.continueOnError && Objects.equals(this.scriptLocations, that.scriptLocations) && Objects.equals(this.separator, that.separator) && Objects.equals(this.encoding, that.encoding);
    }

    public int hashCode() {
        return Objects.hash(this.scriptLocations, this.continueOnError, this.separator, this.encoding);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("scriptLocation", this.scriptLocations).add("continueOnError", this.continueOnError).add("separator", this.separator).add("encoding", this.encoding).toString();
    }
}

