/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.JSONUtils;
import com.onesignal.LocationGMS;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalPrefs;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class UserState {
    static final int DEVICE_TYPE_ANDROID = 1;
    static final int DEVICE_TYPE_FIREOS = 2;
    static final int PUSH_STATUS_SUBSCRIBED = 1;
    static final int PUSH_STATUS_NO_PERMISSION = 0;
    static final int PUSH_STATUS_UNSUBSCRIBE = -2;
    static final int PUSH_STATUS_MISSING_ANDROID_SUPPORT_LIBRARY = -3;
    static final int PUSH_STATUS_MISSING_FIREBASE_FCM_LIBRARY = -4;
    static final int PUSH_STATUS_OUTDATED_ANDROID_SUPPORT_LIBRARY = -5;
    static final int PUSH_STATUS_INVALID_FCM_SENDER_ID = -6;
    static final int PUSH_STATUS_OUTDATED_GOOGLE_PLAY_SERVICES_APP = -7;
    static final int PUSH_STATUS_FIREBASE_FCM_INIT_ERROR = -8;
    static final int PUSH_STATUS_FIREBASE_FCM_ERROR_SERVICE_NOT_AVAILABLE = -9;
    static final int PUSH_STATUS_FIREBASE_FCM_ERROR_IOEXCEPTION = -11;
    static final int PUSH_STATUS_FIREBASE_FCM_ERROR_MISC_EXCEPTION = -12;
    private static final String[] LOCATION_FIELDS = new String[]{"lat", "long", "loc_acc", "loc_type", "loc_bg", "loc_time_stamp", "ad_id"};
    private static final Set<String> LOCATION_FIELDS_SET = new HashSet<String>(Arrays.asList(LOCATION_FIELDS));
    private static final Object syncLock = new Object(){};
    private String persistKey;
    JSONObject dependValues;
    JSONObject syncValues;

    UserState(String inPersistKey, boolean load) {
        this.persistKey = inPersistKey;
        if (load) {
            this.loadState();
        } else {
            this.dependValues = new JSONObject();
            this.syncValues = new JSONObject();
        }
    }

    abstract UserState newInstance(String var1);

    UserState deepClone(String persistKey) {
        UserState clonedUserState = this.newInstance(persistKey);
        try {
            clonedUserState.dependValues = new JSONObject(this.dependValues.toString());
            clonedUserState.syncValues = new JSONObject(this.syncValues.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return clonedUserState;
    }

    protected abstract void addDependFields();

    abstract boolean isSubscribed();

    private Set<String> getGroupChangeFields(UserState changedTo) {
        try {
            if (this.dependValues.optLong("loc_time_stamp") != changedTo.dependValues.getLong("loc_time_stamp")) {
                changedTo.syncValues.put("loc_bg", changedTo.dependValues.opt("loc_bg"));
                changedTo.syncValues.put("loc_time_stamp", changedTo.dependValues.opt("loc_time_stamp"));
                return LOCATION_FIELDS_SET;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    void setLocation(LocationGMS.LocationPoint point) {
        try {
            this.syncValues.put("lat", (Object)point.lat);
            this.syncValues.put("long", (Object)point.log);
            this.syncValues.put("loc_acc", (Object)point.accuracy);
            this.syncValues.put("loc_type", (Object)point.type);
            this.dependValues.put("loc_bg", (Object)point.bg);
            this.dependValues.put("loc_time_stamp", (Object)point.timeStamp);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    void clearLocation() {
        try {
            this.syncValues.put("lat", null);
            this.syncValues.put("long", null);
            this.syncValues.put("loc_acc", null);
            this.syncValues.put("loc_type", null);
            this.syncValues.put("loc_bg", null);
            this.syncValues.put("loc_time_stamp", null);
            this.dependValues.put("loc_bg", null);
            this.dependValues.put("loc_time_stamp", null);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    JSONObject generateJsonDiff(UserState newState, boolean isSessionCall) {
        this.addDependFields();
        newState.addDependFields();
        Set<String> includeFields = this.getGroupChangeFields(newState);
        JSONObject sendJson = UserState.generateJsonDiff(this.syncValues, newState.syncValues, null, includeFields);
        if (!isSessionCall && sendJson.toString().equals("{}")) {
            return null;
        }
        try {
            if (!sendJson.has("app_id")) {
                sendJson.put("app_id", (Object)this.syncValues.optString("app_id"));
            }
            if (this.syncValues.has("email_auth_hash")) {
                sendJson.put("email_auth_hash", (Object)this.syncValues.optString("email_auth_hash"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return sendJson;
    }

    void set(String key, Object value) {
        try {
            this.syncValues.put(key, value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void loadState() {
        String dependValuesStr = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_USERSTATE_DEPENDVALYES_" + this.persistKey, null);
        if (dependValuesStr == null) {
            this.dependValues = new JSONObject();
            try {
                boolean userSubscribePref = true;
                int subscribableStatus = this.persistKey.equals("CURRENT_STATE") ? OneSignalPrefs.getInt(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_SUBSCRIPTION", 1) : OneSignalPrefs.getInt(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_SYNCED_SUBSCRIPTION", 1);
                if (subscribableStatus == -2) {
                    subscribableStatus = 1;
                    userSubscribePref = false;
                }
                this.dependValues.put("subscribableStatus", subscribableStatus);
                this.dependValues.put("userSubscribePref", userSubscribePref);
            }
            catch (JSONException e) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "cannot write prefs value in dependValues", e);
            }
        } else {
            try {
                this.dependValues = new JSONObject(dependValuesStr);
            }
            catch (JSONException e) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "cannot write prefs value in dependValues", e);
            }
        }
        if (this.dependValues == null) {
            this.dependValues = new JSONObject();
        }
        String syncValuesStr = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_USERSTATE_SYNCVALYES_" + this.persistKey, null);
        try {
            if (syncValuesStr == null) {
                this.syncValues = new JSONObject();
                String gtRegistrationId = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "GT_REGISTRATION_ID", null);
                this.syncValues.put("identifier", (Object)gtRegistrationId);
            } else {
                this.syncValues = new JSONObject(syncValuesStr);
            }
        }
        catch (JSONException e) {
            this.syncValues = new JSONObject();
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "cannot write prefs value in syncValues", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistState() {
        Object object = syncLock;
        synchronized (object) {
            this.modifySyncValuesJsonArray("pkgs");
            OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_USERSTATE_SYNCVALYES_" + this.persistKey, this.syncValues.toString());
            OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_USERSTATE_DEPENDVALYES_" + this.persistKey, this.dependValues.toString());
        }
    }

    private void modifySyncValuesJsonArray(String baseKey) {
        try {
            int i;
            JSONArray orgArray = this.syncValues.has(baseKey) ? this.syncValues.getJSONArray(baseKey) : new JSONArray();
            JSONArray tempArray = new JSONArray();
            if (this.syncValues.has(baseKey + "_d")) {
                String remArrayStr = JSONUtils.toStringNE(this.syncValues.getJSONArray(baseKey + "_d"));
                for (i = 0; i < orgArray.length(); ++i) {
                    if (remArrayStr.contains(orgArray.getString(i))) continue;
                    tempArray.put(orgArray.get(i));
                }
            } else {
                tempArray = orgArray;
            }
            if (this.syncValues.has(baseKey + "_a")) {
                JSONArray newArray = this.syncValues.getJSONArray(baseKey + "_a");
                for (i = 0; i < newArray.length(); ++i) {
                    tempArray.put(newArray.get(i));
                }
            }
            this.syncValues.put(baseKey, (Object)tempArray);
            this.syncValues.remove(baseKey + "_a");
            this.syncValues.remove(baseKey + "_d");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void persistStateAfterSync(JSONObject inDependValues, JSONObject inSyncValues) {
        if (inDependValues != null) {
            UserState.generateJsonDiff(this.dependValues, inDependValues, this.dependValues, null);
        }
        if (inSyncValues != null) {
            UserState.generateJsonDiff(this.syncValues, inSyncValues, this.syncValues, null);
            this.mergeTags(inSyncValues, null);
        }
        if (inDependValues != null || inSyncValues != null) {
            this.persistState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeTags(JSONObject inSyncValues, JSONObject omitKeys) {
        Object object = syncLock;
        synchronized (object) {
            if (inSyncValues.has("tags")) {
                JSONObject newTags;
                if (this.syncValues.has("tags")) {
                    try {
                        newTags = new JSONObject(this.syncValues.optString("tags"));
                    }
                    catch (JSONException e) {
                        newTags = new JSONObject();
                    }
                } else {
                    newTags = new JSONObject();
                }
                JSONObject curTags = inSyncValues.optJSONObject("tags");
                Iterator keys = curTags.keys();
                try {
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        if ("".equals(curTags.optString(key))) {
                            newTags.remove(key);
                            continue;
                        }
                        if (omitKeys != null && omitKeys.has(key)) continue;
                        newTags.put(key, (Object)curTags.optString(key));
                    }
                    if (newTags.toString().equals("{}")) {
                        this.syncValues.remove("tags");
                    } else {
                        this.syncValues.put("tags", (Object)newTags);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject generateJsonDiff(JSONObject cur, JSONObject changedTo, JSONObject baseOutput, Set<String> includeFields) {
        Object object = syncLock;
        synchronized (object) {
            return JSONUtils.generateJsonDiff(cur, changedTo, baseOutput, includeFields);
        }
    }
}

