/*
 * Decompiled with CFR 0.152.
 */
package com.ghasemkiani.gui.calendar;

import com.ghasemkiani.gui.layout.Bagger;
import com.ghasemkiani.util.icu.PersianCalendar;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.BuddhistCalendar;
import com.ibm.icu.util.ChineseCalendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.HebrewCalendar;
import com.ibm.icu.util.IslamicCalendar;
import com.ibm.icu.util.JapaneseCalendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JPanelCalendar
extends JPanel {
    private static final String[] FIELD_NAMES = new String[]{"Year", "Month", "Week of Month", "Week of Year", "Day of Month", "Day of Week", "Day of Week in Month", "Day of Year", "AM/PM", "Hour of day", "Hour", "Minute", "Second"};
    private static final int[] FIELDS = new int[]{1, 2, 4, 3, 5, 7, 8, 6, 9, 11, 10, 12, 13};
    private static final String[] STYLE_NAMES = new String[]{"Default", "Short", "Medium", "Long", "Full"};
    private static final int[] STYLES = new int[]{2, 3, 2, 1, 0};
    private static final String RTL_LANGUAGES = "fa,ar,iw,he";
    private static final Color LIGHTYELLOW = new Color(255, 255, 224);
    private static final Color LAVENDER = new Color(230, 230, 250);
    private JComboBox jComboBoxTimeZone;
    private JComboBox jComboBoxLocale;
    private JComboBox jComboBoxCalendarType;
    private JTextField jTextFieldTimeInMillis;
    private JCheckBox jCheckBoxApplyTimeInMillis;
    private JTextField jTextFieldYear;
    private JTextField jTextFieldMonth;
    private JTextField jTextFieldDay;
    private JTextField jTextFieldHour;
    private JTextField jTextFieldMinute;
    private JTextField jTextFieldSecond;
    private JCheckBox jCheckBoxApplyDate;
    private JComboBox jComboBoxFieldAdd;
    private JTextField jTextFieldAmountAdd;
    private JCheckBox jCheckBoxApplyAdd;
    private JComboBox jComboBoxFieldRoll;
    private JTextField jTextFieldAmountRoll;
    private JCheckBox jCheckBoxApplyRoll;
    private JComboBox jComboBoxFormatDate;
    private JComboBox jComboBoxFormatTime;
    private JTextField jTextFieldPattern;
    private JCheckBox jCheckBoxApplyPattern;
    private JButton jButtonRefresh;
    private JTextField jTextFieldDisplay;

    public void setJComboBoxTimeZone(JComboBox jComboBoxTimeZone) {
        this.jComboBoxTimeZone = jComboBoxTimeZone;
    }

    public JComboBox getJComboBoxTimeZone() {
        if (this.jComboBoxTimeZone == null) {
            this.jComboBoxTimeZone = new JComboBox<String>(TimeZone.getAvailableIDs());
        }
        return this.jComboBoxTimeZone;
    }

    public void setJComboBoxLocale(JComboBox jComboBoxLocale) {
        this.jComboBoxLocale = jComboBoxLocale;
    }

    public JComboBox getJComboBoxLocale() {
        if (this.jComboBoxLocale == null) {
            this.jComboBoxLocale = new JComboBox<ULocale>(ULocale.getAvailableLocales());
        }
        return this.jComboBoxLocale;
    }

    public void setJComboBoxCalendarType(JComboBox jComboBoxCalendarType) {
        this.jComboBoxCalendarType = jComboBoxCalendarType;
    }

    public JComboBox getJComboBoxCalendarType() {
        if (this.jComboBoxCalendarType == null) {
            this.jComboBoxCalendarType = new JComboBox<String>(new String[]{"Gregorian", "Persian", "Islamic", "Japanese", "Chinese", "Buddhist", "Hebrew"});
        }
        return this.jComboBoxCalendarType;
    }

    public void setJTextFieldTimeInMillis(JTextField jTextFieldTimeInMillis) {
        this.jTextFieldTimeInMillis = jTextFieldTimeInMillis;
    }

    public JTextField getJTextFieldTimeInMillis() {
        if (this.jTextFieldTimeInMillis == null) {
            this.jTextFieldTimeInMillis = new JTextField();
        }
        return this.jTextFieldTimeInMillis;
    }

    public void setJCheckBoxApplyTimeInMillis(JCheckBox jCheckBoxApplyTimeInMillis) {
        this.jCheckBoxApplyTimeInMillis = jCheckBoxApplyTimeInMillis;
    }

    public JCheckBox getJCheckBoxApplyTimeInMillis() {
        if (this.jCheckBoxApplyTimeInMillis == null) {
            this.jCheckBoxApplyTimeInMillis = new JCheckBox("Apply");
        }
        return this.jCheckBoxApplyTimeInMillis;
    }

    public void setJTextFieldYear(JTextField jTextFieldYear) {
        this.jTextFieldYear = jTextFieldYear;
    }

    public JTextField getJTextFieldYear() {
        if (this.jTextFieldYear == null) {
            this.jTextFieldYear = new JTextField();
        }
        return this.jTextFieldYear;
    }

    public void setJTextFieldMonth(JTextField jTextFieldMonth) {
        this.jTextFieldMonth = jTextFieldMonth;
    }

    public JTextField getJTextFieldMonth() {
        if (this.jTextFieldMonth == null) {
            this.jTextFieldMonth = new JTextField();
        }
        return this.jTextFieldMonth;
    }

    public void setJTextFieldDay(JTextField jTextFieldDay) {
        this.jTextFieldDay = jTextFieldDay;
    }

    public JTextField getJTextFieldDay() {
        if (this.jTextFieldDay == null) {
            this.jTextFieldDay = new JTextField();
        }
        return this.jTextFieldDay;
    }

    public void setJTextFieldHour(JTextField jTextFieldHour) {
        this.jTextFieldHour = jTextFieldHour;
    }

    public JTextField getJTextFieldHour() {
        if (this.jTextFieldHour == null) {
            this.jTextFieldHour = new JTextField();
        }
        return this.jTextFieldHour;
    }

    public void setJTextFieldMinute(JTextField jTextFieldMinute) {
        this.jTextFieldMinute = jTextFieldMinute;
    }

    public JTextField getJTextFieldMinute() {
        if (this.jTextFieldMinute == null) {
            this.jTextFieldMinute = new JTextField();
        }
        return this.jTextFieldMinute;
    }

    public void setJTextFieldSecond(JTextField jTextFieldSecond) {
        this.jTextFieldSecond = jTextFieldSecond;
    }

    public JTextField getJTextFieldSecond() {
        if (this.jTextFieldSecond == null) {
            this.jTextFieldSecond = new JTextField();
        }
        return this.jTextFieldSecond;
    }

    public void setJCheckBoxApplyDate(JCheckBox jCheckBoxApplyDate) {
        this.jCheckBoxApplyDate = jCheckBoxApplyDate;
    }

    public JCheckBox getJCheckBoxApplyDate() {
        if (this.jCheckBoxApplyDate == null) {
            this.jCheckBoxApplyDate = new JCheckBox("Apply");
        }
        return this.jCheckBoxApplyDate;
    }

    public void setJComboBoxFieldAdd(JComboBox jComboBoxFieldAdd) {
        this.jComboBoxFieldAdd = jComboBoxFieldAdd;
    }

    public JComboBox getJComboBoxFieldAdd() {
        if (this.jComboBoxFieldAdd == null) {
            this.jComboBoxFieldAdd = new JComboBox<String>(FIELD_NAMES);
        }
        return this.jComboBoxFieldAdd;
    }

    public void setJTextFieldAmountAdd(JTextField jTextFieldAmountAdd) {
        this.jTextFieldAmountAdd = jTextFieldAmountAdd;
    }

    public JTextField getJTextFieldAmountAdd() {
        if (this.jTextFieldAmountAdd == null) {
            this.jTextFieldAmountAdd = new JTextField();
        }
        return this.jTextFieldAmountAdd;
    }

    public void setJCheckBoxApplyAdd(JCheckBox jCheckBoxApplyAdd) {
        this.jCheckBoxApplyAdd = jCheckBoxApplyAdd;
    }

    public JCheckBox getJCheckBoxApplyAdd() {
        if (this.jCheckBoxApplyAdd == null) {
            this.jCheckBoxApplyAdd = new JCheckBox("Apply");
        }
        return this.jCheckBoxApplyAdd;
    }

    public void setJComboBoxFieldRoll(JComboBox jComboBoxFieldRoll) {
        this.jComboBoxFieldRoll = jComboBoxFieldRoll;
    }

    public JComboBox getJComboBoxFieldRoll() {
        if (this.jComboBoxFieldRoll == null) {
            this.jComboBoxFieldRoll = new JComboBox<String>(FIELD_NAMES);
        }
        return this.jComboBoxFieldRoll;
    }

    public void setJTextFieldAmountRoll(JTextField jTextFieldAmountRoll) {
        this.jTextFieldAmountRoll = jTextFieldAmountRoll;
    }

    public JTextField getJTextFieldAmountRoll() {
        if (this.jTextFieldAmountRoll == null) {
            this.jTextFieldAmountRoll = new JTextField();
        }
        return this.jTextFieldAmountRoll;
    }

    public void setJCheckBoxApplyRoll(JCheckBox jCheckBoxApplyRoll) {
        this.jCheckBoxApplyRoll = jCheckBoxApplyRoll;
    }

    public JCheckBox getJCheckBoxApplyRoll() {
        if (this.jCheckBoxApplyRoll == null) {
            this.jCheckBoxApplyRoll = new JCheckBox("Apply");
        }
        return this.jCheckBoxApplyRoll;
    }

    public void setJComboBoxFormatDate(JComboBox jComboBoxFormatDate) {
        this.jComboBoxFormatDate = jComboBoxFormatDate;
    }

    public JComboBox getJComboBoxFormatDate() {
        if (this.jComboBoxFormatDate == null) {
            this.jComboBoxFormatDate = new JComboBox<String>(STYLE_NAMES);
        }
        return this.jComboBoxFormatDate;
    }

    public void setJComboBoxFormatTime(JComboBox jComboBoxFormatTime) {
        this.jComboBoxFormatTime = jComboBoxFormatTime;
    }

    public JComboBox getJComboBoxFormatTime() {
        if (this.jComboBoxFormatTime == null) {
            this.jComboBoxFormatTime = new JComboBox<String>(STYLE_NAMES);
        }
        return this.jComboBoxFormatTime;
    }

    public void setJTextFieldPattern(JTextField jTextFieldPattern) {
        this.jTextFieldPattern = jTextFieldPattern;
    }

    public JTextField getJTextFieldPattern() {
        if (this.jTextFieldPattern == null) {
            this.jTextFieldPattern = new JTextField();
        }
        return this.jTextFieldPattern;
    }

    public void setJCheckBoxApplyPattern(JCheckBox jCheckBoxApplyPattern) {
        this.jCheckBoxApplyPattern = jCheckBoxApplyPattern;
    }

    public JCheckBox getJCheckBoxApplyPattern() {
        if (this.jCheckBoxApplyPattern == null) {
            this.jCheckBoxApplyPattern = new JCheckBox("Apply");
        }
        return this.jCheckBoxApplyPattern;
    }

    public void setJButtonRefresh(JButton jButtonRefresh) {
        this.jButtonRefresh = jButtonRefresh;
    }

    public JButton getJButtonRefresh() {
        if (this.jButtonRefresh == null) {
            this.jButtonRefresh = new JButton("Refresh");
        }
        return this.jButtonRefresh;
    }

    public void setJTextFieldDisplay(JTextField jTextFieldDisplay) {
        this.jTextFieldDisplay = jTextFieldDisplay;
    }

    public JTextField getJTextFieldDisplay() {
        if (this.jTextFieldDisplay == null) {
            this.jTextFieldDisplay = new JTextField();
        }
        return this.jTextFieldDisplay;
    }

    public JPanelCalendar() {
        this.init();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        Bagger b = new Bagger();
        this.add((Component)b.getJPanel(), "Center");
        b.lineStart();
        b.xspan(3);
        Bagger b1 = b.bagger();
        b1.pad(0, 0);
        b1.inset(0);
        b1.xfill();
        JLabel jLabelTop1 = new JLabel("PERSIAN CALENDAR DEMO", 0);
        jLabelTop1.setFont(new Font("Times New Roman", 1, 24));
        jLabelTop1.setOpaque(true);
        jLabelTop1.setBackground(LIGHTYELLOW);
        b1.add(jLabelTop1);
        b1.row();
        b1.xfill();
        JLabel jLabelTop2 = new JLabel("Ghasem Kiani, M.D.", 0);
        jLabelTop2.setFont(new Font("Times New Roman", 2, 14));
        jLabelTop2.setOpaque(true);
        jLabelTop2.setBackground(LIGHTYELLOW);
        b1.add(jLabelTop2);
        b.row();
        b.xfill(0.2);
        b.add(this.createJLabelFor("Time &Zone", this.getJComboBoxTimeZone()));
        b.add(this.getJComboBoxTimeZone());
        b.row();
        b.xfill(0.2);
        b.add(this.createJLabelFor("&Locale", this.getJComboBoxLocale()));
        b.add(this.getJComboBoxLocale());
        b.row();
        b.xfill(0.2);
        b.add(this.createJLabelFor("&Calendar Type", this.getJComboBoxCalendarType()));
        b.add(this.getJComboBoxCalendarType());
        b.row();
        b.xfill(0.2);
        b.add(this.createJLabelFor("&Time in Millis", this.getJTextFieldTimeInMillis()));
        b.xfill(0.6);
        b.add(this.getJTextFieldTimeInMillis());
        b.add(this.getJCheckBoxApplyTimeInMillis());
        b.row();
        b.xfill(0.2);
        b.add(this.createJLabelFor("&Date", this.getJTextFieldYear()));
        b1 = b.bagger(0.6);
        b1.xfill(0.25);
        b1.add(this.getJTextFieldYear());
        b1.add(new JLabel("/"));
        b1.xfill(0.15);
        b1.add(this.getJTextFieldMonth());
        b1.add(new JLabel("/"));
        b1.xfill(0.15);
        b1.add(this.getJTextFieldDay());
        b1.add(new JLabel(" "));
        b1.xfill(0.15);
        b1.add(this.getJTextFieldHour());
        b1.add(new JLabel(":"));
        b1.xfill(0.15);
        b1.add(this.getJTextFieldMinute());
        b1.add(new JLabel(":"));
        b1.xfill(0.15);
        b1.add(this.getJTextFieldSecond());
        b.add(this.getJCheckBoxApplyDate());
        b.row();
        b.xfill(0.2);
        b.add(this.createJLabelFor("&Add", this.getJComboBoxFieldAdd()));
        b1 = b.bagger(0.6);
        b1.add(this.getJComboBoxFieldAdd());
        b1.add(new JLabel(" by "));
        b1.xfill(0.2);
        b1.add(this.getJTextFieldAmountAdd());
        b.add(this.getJCheckBoxApplyAdd());
        b.row();
        b.xfill(0.2);
        b.add(this.createJLabelFor("&Roll", this.getJComboBoxFieldRoll()));
        b1 = b.bagger(0.6);
        b1.add(this.getJComboBoxFieldRoll());
        b1.add(new JLabel(" by "));
        b1.xfill(0.2);
        b1.add(this.getJTextFieldAmountRoll());
        b.add(this.getJCheckBoxApplyRoll());
        b.row();
        b.xfill(0.2);
        b.add(new JLabel("Style"));
        b1 = b.bagger(0.6);
        b1.lineStart();
        b1.add(this.createJLabelFor("Dat&e", this.getJComboBoxFormatDate()));
        b1.add(this.getJComboBoxFormatDate());
        b1.add(this.createJLabelFor("T&ime", this.getJComboBoxFormatTime()));
        b1.add(this.getJComboBoxFormatTime());
        b1.bagger();
        b.row();
        b.xfill(0.2);
        b.add(this.createJLabelFor("&Pattern", this.getJTextFieldPattern()));
        b.xfill(0.6);
        b.add(this.getJTextFieldPattern());
        b.add(this.getJCheckBoxApplyPattern());
        b.row();
        b.xspan(3);
        b.yfill();
        b1 = b.bagger();
        b1.pageStart();
        b1.add(this.getJButtonRefresh());
        b.row();
        this.getJTextFieldDisplay().setEditable(false);
        b.xspan(3);
        b.xfill();
        b.add(this.getJTextFieldDisplay());
        b.row();
        this.getJComboBoxTimeZone().setSelectedItem(TimeZone.getDefault().getID());
        this.getJComboBoxLocale().setSelectedItem(ULocale.getDefault());
        this.getJTextFieldAmountAdd().setText("0");
        this.getJTextFieldAmountRoll().setText("0");
        this.getJTextFieldDisplay().setFont(new Font("Tahoma", 0, 12));
        this.getJTextFieldDisplay().setBackground(LAVENDER);
        this.getJButtonRefresh().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JPanelCalendar.this.doRefresh();
            }
        });
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createLineBorder(Color.red, 1)));
        this.doRefresh();
    }

    protected JLabel createJLabelFor(String text, Component target) {
        JLabel jLabel = new JLabel();
        if (text != null && text.length() > 0) {
            int c = 0;
            int amp = text.indexOf("&");
            if (amp >= 0) {
                c = amp;
                text = text.substring(0, amp) + text.substring(amp + 1);
            }
            jLabel.setText(text);
            jLabel.setDisplayedMnemonicIndex(c);
            jLabel.setDisplayedMnemonic(text.charAt(c));
        }
        jLabel.setLabelFor(target);
        return jLabel;
    }

    public void doRefresh() {
        try {
            TimeZone timeZone = TimeZone.getTimeZone((String)String.valueOf(this.getJComboBoxTimeZone().getSelectedItem()));
            ULocale uLocale = ULocale.createCanonical((String)String.valueOf(this.getJComboBoxLocale().getSelectedItem()));
            String calendarType = String.valueOf(this.getJComboBoxCalendarType().getSelectedItem());
            Object calendar = "Persian".equals(calendarType) ? new PersianCalendar(timeZone, uLocale) : ("Islamic".equals(calendarType) ? new IslamicCalendar(timeZone, uLocale) : ("Gregorian".equals(calendarType) ? new GregorianCalendar(timeZone, uLocale) : ("Japanese".equals(calendarType) ? new JapaneseCalendar(timeZone, uLocale) : ("Chinese".equals(calendarType) ? new ChineseCalendar(timeZone, uLocale) : ("Buddhist".equals(calendarType) ? new BuddhistCalendar(timeZone, uLocale) : ("Hebrew".equals(calendarType) ? new HebrewCalendar(timeZone, uLocale) : new GregorianCalendar(timeZone, uLocale)))))));
            if (this.getJCheckBoxApplyTimeInMillis().isSelected()) {
                try {
                    calendar.setTimeInMillis(Long.parseLong(this.getJTextFieldTimeInMillis().getText()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.getJCheckBoxApplyDate().isSelected()) {
                try {
                    calendar.set(19, Integer.parseInt(this.getJTextFieldYear().getText()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    calendar.set(2, Integer.parseInt(this.getJTextFieldMonth().getText()) - 1);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    calendar.set(5, Integer.parseInt(this.getJTextFieldDay().getText()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    calendar.set(11, Integer.parseInt(this.getJTextFieldHour().getText()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    calendar.set(12, Integer.parseInt(this.getJTextFieldMinute().getText()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    calendar.set(13, Integer.parseInt(this.getJTextFieldSecond().getText()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.getJCheckBoxApplyAdd().isSelected()) {
                try {
                    calendar.add(FIELDS[this.getJComboBoxFieldAdd().getSelectedIndex()], Integer.parseInt(this.getJTextFieldAmountAdd().getText()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.getJCheckBoxApplyRoll().isSelected()) {
                try {
                    calendar.roll(FIELDS[this.getJComboBoxFieldRoll().getSelectedIndex()], Integer.parseInt(this.getJTextFieldAmountRoll().getText()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.getJTextFieldTimeInMillis().setText(String.valueOf(calendar.getTimeInMillis()));
            this.getJTextFieldYear().setText(String.valueOf(calendar.get(19)));
            this.getJTextFieldMonth().setText(String.valueOf(calendar.get(2) + 1));
            this.getJTextFieldDay().setText(String.valueOf(calendar.get(5)));
            this.getJTextFieldHour().setText(String.valueOf(calendar.get(11)));
            this.getJTextFieldMinute().setText(String.valueOf(calendar.get(12)));
            this.getJTextFieldSecond().setText(String.valueOf(calendar.get(13)));
            SimpleDateFormat sdf = (SimpleDateFormat)calendar.getDateTimeFormat(STYLES[this.getJComboBoxFormatDate().getSelectedIndex()], STYLES[this.getJComboBoxFormatTime().getSelectedIndex()], uLocale);
            if (this.getJCheckBoxApplyPattern().isSelected()) {
                sdf.applyPattern(this.getJTextFieldPattern().getText());
            }
            if (RTL_LANGUAGES.indexOf(uLocale.getLanguage()) >= 0) {
                this.getJTextFieldDisplay().applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            } else {
                this.getJTextFieldDisplay().applyComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            }
            this.getJTextFieldDisplay().setText(sdf.format(calendar.getTime()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

