/*
 * Decompiled with CFR 0.152.
 */
package com.ghasemkiani.test.util;

import com.ghasemkiani.test.TestUtils;
import com.ghasemkiani.util.DateFields;
import com.ghasemkiani.util.SimplePersianCalendar;
import com.ghasemkiani.util.icu.PersianCalendar;
import com.ibm.icu.util.TimeZone;

public class TestSimplePersianCalendar {
    public static void main(String[] args) {
        System.out.println("");
        System.out.println("This test compares PersianCalendar and SimplePersianCalendar classes for 2000000 days.");
        System.out.println("The timezone of both calendars is arbitrarily set to America/Los_Angeles.");
        System.out.println("");
        boolean error = false;
        PersianCalendar pc = new PersianCalendar();
        SimplePersianCalendar spc = new SimplePersianCalendar();
        pc.setTimeZone(TimeZone.getTimeZone((String)"America/Los_Angeles"));
        long pct1 = 0L;
        long spct1 = 0L;
        long pct2 = 0L;
        long spct2 = 0L;
        for (int i = -1000000; i < 1000000; ++i) {
            if (i % 100000 == 0) {
                System.out.println("Day #" + i);
            }
            int j = (int)((long)i + 1948321L);
            long t = System.nanoTime();
            pc.set(20, j);
            int pcy = pc.get(19);
            int pcm = pc.get(2);
            int pcd = pc.get(5);
            pct1 += System.nanoTime() - t;
            t = System.nanoTime();
            spc.setJulianDay(j);
            DateFields df = spc.getDateFields();
            int spcy = df.getYear();
            int spcm = df.getMonth();
            int spcd = df.getDay();
            spct1 += System.nanoTime() - t;
            if (pcy != (spcy > 0 ? spcy : spcy + 1) || pcm != spcm || pcd != spcd) {
                error = true;
                System.out.println("Error 1");
            }
            t = System.nanoTime();
            pc.set(19, pcy);
            pc.set(2, pcm);
            pc.set(5, pcd);
            int pcj = pc.get(20);
            pct2 += System.nanoTime() - t;
            t = System.nanoTime();
            DateFields df1 = new DateFields(spcy, spcm, spcd);
            spc.setDateFields(df1);
            long spcj = spc.getJulianDay();
            spct2 += System.nanoTime() - t;
            if ((long)pcj != spcj) {
                error = true;
                System.out.println("Error 2");
            }
            if (pcj == j) continue;
            error = true;
            System.out.println("Error 3");
        }
        System.out.println("");
        System.out.println(error ? "Test FAILED!" : "Test SUCCEEDED!");
        System.out.println("");
        System.out.println("Time spent by PersianCalendar:");
        System.out.println("jp: " + pct1 / 1000000L + " ms");
        System.out.println("pj: " + pct2 / 1000000L + " ms");
        System.out.println("Time spent by SimplePersianCalendar:");
        System.out.println("jp: " + spct1 / 1000000L + " ms");
        System.out.println("pj: " + spct2 / 1000000L + " ms");
        TestUtils.printInfo();
    }
}

