/*
 * Decompiled with CFR 0.152.
 */
package ir.siaray.volleyplus;

import android.content.Context;
import android.text.TextUtils;
import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.ClientError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkError;
import com.android.volley.NoConnectionError;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.RetryPolicy;
import com.android.volley.ServerError;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.Volley;
import ir.siaray.volleyplus.listener.ParseVolleyErrorListener;
import ir.siaray.volleyplus.util.LruBitmapCache;
import java.io.UnsupportedEncodingException;

public class VolleyPlus {
    private static final String TAG = VolleyPlus.class.getSimpleName();
    private static VolleyPlus mInstance;
    private Context mContext;
    private RequestQueue mRequestQueue;
    private ImageLoader mImageLoader;

    private VolleyPlus(Context context) {
        this.mContext = context.getApplicationContext();
        mInstance = this;
    }

    public static VolleyPlus initialize(Context context) {
        return new VolleyPlus(context);
    }

    public static VolleyPlus getInstance() {
        return mInstance;
    }

    public RequestQueue getRequestQueue() {
        if (this.mRequestQueue == null) {
            this.mRequestQueue = Volley.newRequestQueue((Context)this.mContext);
        }
        return this.mRequestQueue;
    }

    public ImageLoader getImageLoader() {
        this.getRequestQueue();
        if (this.mImageLoader == null) {
            this.mImageLoader = new ImageLoader(this.mRequestQueue, (ImageLoader.ImageCache)new LruBitmapCache());
        }
        return this.mImageLoader;
    }

    public <T> void addToRequestQueue(Request<T> req, String tag) {
        req.setTag((Object)(TextUtils.isEmpty((CharSequence)tag) ? TAG : tag));
        this.getRequestQueue().add(req);
    }

    public <T> void addToRequestQueue(Request<T> req) {
        req.setTag((Object)TAG);
        this.getRequestQueue().add(req);
    }

    public boolean cancelPendingRequests(Object tag) {
        if (this.mRequestQueue != null) {
            this.mRequestQueue.cancelAll(tag);
            return true;
        }
        return false;
    }

    public static String getCache(String url) {
        Cache cache = VolleyPlus.getInstance().getRequestQueue().getCache();
        Cache.Entry entry = cache.get(url);
        if (entry != null) {
            try {
                String data = new String(entry.data, "UTF-8");
                return data;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void invalidateVolleyCache(String url) {
        VolleyPlus.getInstance().getRequestQueue().getCache().invalidate(url, true);
    }

    public static void disableCache(Request request) {
        request.setShouldCache(false);
    }

    public static void clearCache(String url) {
        VolleyPlus.getInstance().getRequestQueue().getCache().remove(url);
    }

    public static void clearCache() {
        VolleyPlus.getInstance().getRequestQueue().getCache().clear();
    }

    public static boolean cancelRequest(String request) {
        return request != null && VolleyPlus.getInstance().cancelPendingRequests(request);
    }

    public static void setTimeoutRequest(Request request, int initialTimeoutMs, int maxNumRetries, float backoffMultiplier) {
        if (initialTimeoutMs <= 0) {
            initialTimeoutMs = 2500;
        }
        if (maxNumRetries <= 0) {
            maxNumRetries = 1;
        }
        if (backoffMultiplier <= 0.0f) {
            backoffMultiplier = 1.0f;
        }
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(initialTimeoutMs, maxNumRetries, backoffMultiplier));
    }

    public static void parseVolleyError(VolleyError error, ParseVolleyErrorListener listener) {
        if (listener == null) {
            return;
        }
        if (error instanceof TimeoutError) {
            listener.onTimeoutError(error);
        } else if (error instanceof NoConnectionError) {
            listener.onNoConnectionError(error);
        } else if (error instanceof AuthFailureError) {
            listener.onAuthFailureError(error);
        } else if (error instanceof ClientError) {
            listener.onClientError(error);
        } else if (error instanceof ServerError) {
            listener.onServerError(error);
        } else if (error instanceof NetworkError) {
            listener.onNetworkError(error);
        } else if (error instanceof ParseError) {
            listener.onParseError(error);
        }
    }
}

