/*
 * Decompiled with CFR 0.152.
 */
package ir.siaray.volleyplus.request;

import android.content.Context;
import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.android.volley.Response;
import ir.siaray.volleyplus.VolleyPlus;
import ir.siaray.volleyplus.request.Request;
import java.util.Map;
import org.json.JSONArray;

public class JsonArrayRequest
extends Request {
    private String mUrl;
    private Context mContext;
    private int mMethod = 0;
    private String mTag = JsonArrayRequest.class.getSimpleName();
    private Map<String, String> mHeader;
    private Request.Priority mPriority = Request.Priority.NORMAL;
    private int mTimeout = 2500;
    private int mNumberOfRetries = 1;
    private float mBackoffMultiplier = 1.0f;
    private JSONArray mParams;
    private Response.Listener<JSONArray> mListener;
    private Response.ErrorListener mErrorListener;
    private byte[] mBody;

    private JsonArrayRequest(Context context, String url) {
        super(context);
        this.mContext = context;
        this.mUrl = url;
    }

    public static JsonArrayRequest getInstance(Context context, String url) {
        return new JsonArrayRequest(context, url);
    }

    public JsonArrayRequest setMethod(int method) {
        this.mMethod = method;
        return this;
    }

    public JsonArrayRequest setTag(String tag) {
        this.mTag = tag;
        return this;
    }

    public JsonArrayRequest setHeader(Map<String, String> header) {
        this.mHeader = header;
        return this;
    }

    public JsonArrayRequest setPriority(Request.Priority priority) {
        this.mPriority = priority;
        return this;
    }

    public JsonArrayRequest setTimeout(int timeout) {
        this.mTimeout = timeout;
        return this;
    }

    public JsonArrayRequest setNumberOfRetries(int numberOfRetries) {
        this.mNumberOfRetries = numberOfRetries;
        return this;
    }

    public JsonArrayRequest setBackoffMultiplier(float backoffMultiplier) {
        this.mBackoffMultiplier = backoffMultiplier;
        return this;
    }

    public JsonArrayRequest setBody(byte[] body) {
        this.mBody = body;
        return this;
    }

    public JsonArrayRequest setParams(JSONArray params) {
        this.mParams = params;
        return this;
    }

    public JsonArrayRequest setListener(Response.Listener<JSONArray> listener, Response.ErrorListener errorListener) {
        this.mListener = listener;
        this.mErrorListener = errorListener;
        return this;
    }

    public void send() {
        this.sendRequest();
    }

    private void sendRequest() {
        com.android.volley.toolbox.JsonArrayRequest jsonObjReq = new com.android.volley.toolbox.JsonArrayRequest(this.mMethod, this.mUrl, this.mParams, this.mListener, this.mErrorListener){

            public Request.Priority getPriority() {
                return JsonArrayRequest.this.mPriority;
            }

            public Map<String, String> getHeaders() throws AuthFailureError {
                return JsonArrayRequest.this.mHeader != null ? JsonArrayRequest.this.mHeader : super.getHeaders();
            }

            public byte[] getBody() {
                return JsonArrayRequest.this.mBody != null ? JsonArrayRequest.this.mBody : super.getBody();
            }
        };
        VolleyPlus.setTimeoutRequest((com.android.volley.Request)jsonObjReq, this.mTimeout, this.mNumberOfRetries, this.mBackoffMultiplier);
        VolleyPlus.getInstance().addToRequestQueue(jsonObjReq, this.mTag);
    }
}

