/*
 * Decompiled with CFR 0.152.
 */
package ir.siaray.volleyplus.request;

import android.content.Context;
import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.android.volley.Response;
import ir.siaray.volleyplus.VolleyPlus;
import ir.siaray.volleyplus.request.Request;
import java.util.Map;
import org.json.JSONObject;

public class JsonObjectRequest
extends Request {
    private String mUrl;
    private Context mContext;
    private int mMethod = 0;
    private String mTag = JsonObjectRequest.class.getSimpleName();
    private Map<String, String> mHeader;
    private Request.Priority mPriority = Request.Priority.NORMAL;
    private int mTimeout = 2500;
    private int mNumberOfRetries = 1;
    private float mBackoffMultiplier = 1.0f;
    private JSONObject mParams;
    private Response.Listener<JSONObject> mListener;
    private Response.ErrorListener mErrorListener;
    private byte[] mBody;

    private JsonObjectRequest(Context context, String url) {
        super(context);
        this.mContext = context;
        this.mUrl = url;
    }

    public static JsonObjectRequest getInstance(Context context, String url) {
        return new JsonObjectRequest(context, url);
    }

    public JsonObjectRequest setMethod(int method) {
        this.mMethod = method;
        return this;
    }

    public JsonObjectRequest setTag(String tag) {
        this.mTag = tag;
        return this;
    }

    public JsonObjectRequest setHeader(Map<String, String> header) {
        this.mHeader = header;
        return this;
    }

    public JsonObjectRequest setPriority(Request.Priority priority) {
        this.mPriority = priority;
        return this;
    }

    public JsonObjectRequest setTimeout(int timeout) {
        this.mTimeout = timeout;
        return this;
    }

    public JsonObjectRequest setNumberOfRetries(int numberOfRetries) {
        this.mNumberOfRetries = numberOfRetries;
        return this;
    }

    public JsonObjectRequest setBackoffMultiplier(float backoffMultiplier) {
        this.mBackoffMultiplier = backoffMultiplier;
        return this;
    }

    public JsonObjectRequest setBody(byte[] body) {
        this.mBody = body;
        return this;
    }

    public JsonObjectRequest setParams(JSONObject params) {
        this.mParams = params;
        return this;
    }

    public JsonObjectRequest setListener(Response.Listener<JSONObject> listener, Response.ErrorListener errorListener) {
        this.mListener = listener;
        this.mErrorListener = errorListener;
        return this;
    }

    public void send() {
        this.sendRequest();
    }

    private void sendRequest() {
        com.android.volley.toolbox.JsonObjectRequest jsonObjReq = new com.android.volley.toolbox.JsonObjectRequest(this.mMethod, this.mUrl, this.mParams, this.mListener, this.mErrorListener){

            public Request.Priority getPriority() {
                return JsonObjectRequest.this.mPriority;
            }

            public Map<String, String> getHeaders() throws AuthFailureError {
                return JsonObjectRequest.this.mHeader != null ? JsonObjectRequest.this.mHeader : super.getHeaders();
            }

            public byte[] getBody() {
                return JsonObjectRequest.this.mBody != null ? JsonObjectRequest.this.mBody : super.getBody();
            }
        };
        VolleyPlus.setTimeoutRequest((com.android.volley.Request)jsonObjReq, this.mTimeout, this.mNumberOfRetries, this.mBackoffMultiplier);
        VolleyPlus.getInstance().addToRequestQueue(jsonObjReq, this.mTag);
    }
}

