/*
 * Decompiled with CFR 0.152.
 */
package ir.siaray.volleyplus.request;

import android.content.Context;
import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.android.volley.Response;
import ir.siaray.volleyplus.VolleyPlus;
import ir.siaray.volleyplus.request.Request;
import ir.siaray.volleyplus.util.VolleyUtils;
import java.util.Map;

public class StringRequest
extends Request {
    private String mUrl;
    private Context mContext;
    private int mMethod = 0;
    private String mTag;
    private Map<String, String> mHeader;
    private Request.Priority mPriority = Request.Priority.NORMAL;
    private int mTimeout = 2500;
    private int mNumberOfRetries = 1;
    private float mBackoffMultiplier = 1.0f;
    private Map<String, String> mParams;
    private Response.Listener<String> mListener;
    private Response.ErrorListener mErrorListener;
    private byte[] mBody;

    private StringRequest(Context context, String url) {
        super(context);
        this.mContext = context;
        this.mUrl = url;
    }

    public static StringRequest getInstance(Context context, String url) {
        return new StringRequest(context, url);
    }

    public StringRequest setMethod(int method) {
        this.mMethod = method;
        return this;
    }

    public StringRequest setTag(String tag) {
        this.mTag = tag;
        return this;
    }

    public StringRequest setHeader(Map<String, String> header) {
        this.mHeader = header;
        return this;
    }

    public StringRequest setPriority(Request.Priority priority) {
        this.mPriority = priority;
        return this;
    }

    public StringRequest setTimeout(int timeout) {
        this.mTimeout = timeout;
        return this;
    }

    public StringRequest setNumberOfRetries(int numberOfRetries) {
        this.mNumberOfRetries = numberOfRetries;
        return this;
    }

    public StringRequest setBackoffMultiplier(float backoffMultiplier) {
        this.mBackoffMultiplier = backoffMultiplier;
        return this;
    }

    public StringRequest setParams(Map<String, String> params) {
        this.mParams = params;
        return this;
    }

    public StringRequest setListener(Response.Listener<String> listener, Response.ErrorListener errorListener) {
        this.mListener = listener;
        this.mErrorListener = errorListener;
        return this;
    }

    public StringRequest setBody(byte[] body) {
        this.mBody = body;
        return this;
    }

    public void send() {
        this.sendRequest();
    }

    private void sendRequest() {
        this.addParamsToGetRequest();
        com.android.volley.toolbox.StringRequest jsonStrReq = new com.android.volley.toolbox.StringRequest(this.mMethod, this.mUrl, this.mListener, this.mErrorListener){

            protected Map<String, String> getParams() throws AuthFailureError {
                return StringRequest.this.mParams != null ? StringRequest.this.mParams : super.getParams();
            }

            public Request.Priority getPriority() {
                return StringRequest.this.mPriority;
            }

            public Map<String, String> getHeaders() throws AuthFailureError {
                return StringRequest.this.mHeader != null ? StringRequest.this.mHeader : super.getHeaders();
            }

            public byte[] getBody() throws AuthFailureError {
                return StringRequest.this.mBody != null ? StringRequest.this.mBody : super.getBody();
            }
        };
        VolleyPlus.setTimeoutRequest((com.android.volley.Request)jsonStrReq, this.mTimeout, this.mNumberOfRetries, this.mBackoffMultiplier);
        VolleyPlus.getInstance().addToRequestQueue(jsonStrReq, this.mTag);
    }

    private void addParamsToGetRequest() {
        if (this.mMethod == 0) {
            this.mUrl = VolleyUtils.buildGetRequestUrl(this.mUrl, this.mParams);
        }
    }
}

