/*
 * Decompiled with CFR 0.152.
 */
package ir.siaray.volleyplus.util;

import android.graphics.Bitmap;
import android.support.v4.util.LruCache;
import com.android.volley.toolbox.ImageLoader;

public class LruBitmapCache
extends LruCache<String, Bitmap>
implements ImageLoader.ImageCache {
    public static int getDefaultLruCacheSize() {
        int maxMemory = (int)(Runtime.getRuntime().maxMemory() / 1024L);
        int cacheSize = maxMemory / 8;
        return cacheSize;
    }

    public LruBitmapCache() {
        this(LruBitmapCache.getDefaultLruCacheSize());
    }

    public LruBitmapCache(int sizeInKiloBytes) {
        super(sizeInKiloBytes);
    }

    protected int sizeOf(String key, Bitmap value) {
        return value.getRowBytes() * value.getHeight() / 1024;
    }

    public Bitmap getBitmap(String url) {
        return (Bitmap)this.get(url);
    }

    public void putBitmap(String url, Bitmap bitmap) {
        this.put(url, bitmap);
    }
}

