/*
 * Decompiled with CFR 0.152.
 */
package ir.siaray.volleyplus;

import android.content.Context;
import android.text.TextUtils;
import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.ClientError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkError;
import com.android.volley.NoConnectionError;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.RetryPolicy;
import com.android.volley.ServerError;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.Volley;
import ir.siaray.volleyplus.listener.ParseVolleyErrorListener;
import ir.siaray.volleyplus.util.LruBitmapCache;
import ir.siaray.volleyplus.util.VolleyUtils;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class VolleyPlus {
    private static final String TAG = VolleyPlus.class.getSimpleName();
    private static VolleyPlus mInstance;
    private static Context mContext;
    private RequestQueue mRequestQueue;
    private ImageLoader mImageLoader;

    private VolleyPlus(Context context) {
        mContext = context.getApplicationContext();
        mInstance = this;
    }

    public static Context getContext() {
        return mContext;
    }

    public static VolleyPlus getInstance(Context context) {
        if (mInstance == null || mContext == null) {
            return new VolleyPlus(context);
        }
        return mInstance;
    }

    public static VolleyPlus getInstance() {
        return mInstance;
    }

    public RequestQueue getRequestQueue() {
        if (this.mRequestQueue == null) {
            this.mRequestQueue = Volley.newRequestQueue((Context)mContext);
        }
        return this.mRequestQueue;
    }

    public ImageLoader getImageLoader() {
        this.getRequestQueue();
        if (this.mImageLoader == null) {
            this.mImageLoader = new ImageLoader(this.mRequestQueue, (ImageLoader.ImageCache)new LruBitmapCache());
        }
        return this.mImageLoader;
    }

    public <T> void addToRequestQueue(Request<T> req, String tag) {
        req.setTag((Object)(TextUtils.isEmpty((CharSequence)tag) ? TAG : tag));
        this.getRequestQueue().add(req);
    }

    public <T> void addToRequestQueue(Request<T> req) {
        req.setTag((Object)TAG);
        this.getRequestQueue().add(req);
    }

    public boolean cancelPendingRequests(Object tag) {
        if (this.mRequestQueue != null) {
            this.mRequestQueue.cancelAll(tag);
            return true;
        }
        return false;
    }

    public static String getCache(Context context, String url) {
        Cache cache = VolleyPlus.getInstance(context).getRequestQueue().getCache();
        Cache.Entry entry = cache.get(url);
        if (entry != null) {
            try {
                String data = new String(entry.data, "UTF-8");
                data = VolleyUtils.unescapeString(data);
                return data;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getCacheForGetRequest(Context context, String url, Map<String, String> params) {
        return VolleyPlus.getCache(context, VolleyUtils.buildGetRequestUrl(url, params));
    }

    public static String getCacheForGetRequest(Context context, String url, JSONObject params) {
        return VolleyPlus.getCache(context, VolleyUtils.buildGetRequestUrl(url, params));
    }

    public static String getCacheForGetRequest(Context context, String url, JSONArray params) {
        return VolleyPlus.getCache(context, VolleyUtils.buildGetRequestUrl(url, params));
    }

    public static void invalidateCache(Context context, String url) {
        VolleyPlus.getInstance(context).getRequestQueue().getCache().invalidate(url, true);
    }

    public static void invalidateCacheForGetRequest(Context context, String url, Map<String, String> params) {
        VolleyPlus.getInstance(context).getRequestQueue().getCache().invalidate(VolleyUtils.buildGetRequestUrl(url, params), true);
    }

    public static void invalidateCacheForGetRequest(Context context, String url, JSONObject params) {
        VolleyPlus.getInstance(context).getRequestQueue().getCache().invalidate(VolleyUtils.buildGetRequestUrl(url, params), true);
    }

    public static void invalidateCacheForGetRequest(Context context, String url, JSONArray params) {
        VolleyPlus.getInstance(context).getRequestQueue().getCache().invalidate(VolleyUtils.buildGetRequestUrl(url, params), true);
    }

    public static void disableCache(Request request) {
        request.setShouldCache(false);
    }

    public static void clearCache(Context context, String url) {
        VolleyPlus.getInstance(context).getRequestQueue().getCache().remove(url);
    }

    public static void clearCacheForGetRequest(Context context, String url, Map<String, String> params) {
        VolleyPlus.getInstance(context).getRequestQueue().getCache().remove(VolleyUtils.buildGetRequestUrl(url, params));
    }

    public static void clearCacheForGetRequest(Context context, String url, JSONObject params) {
        VolleyPlus.getInstance(context).getRequestQueue().getCache().remove(VolleyUtils.buildGetRequestUrl(url, params));
    }

    public static void clearCacheForGetRequest(Context context, String url, JSONArray params) {
        VolleyPlus.getInstance(context).getRequestQueue().getCache().remove(VolleyUtils.buildGetRequestUrl(url, params));
    }

    public static boolean clearCache(Context context) {
        Cache cache;
        RequestQueue queue;
        VolleyPlus instance = VolleyPlus.getInstance(context);
        if (instance != null && (queue = instance.getRequestQueue()) != null && (cache = queue.getCache()) != null) {
            cache.clear();
            return true;
        }
        return false;
    }

    public static boolean cancelRequest(Context context, String request) {
        return request != null && VolleyPlus.getInstance(context).cancelPendingRequests(request);
    }

    public static void setTimeoutRequest(Request request, int initialTimeoutMs, int maxNumRetries, float backoffMultiplier) {
        if (initialTimeoutMs <= 0) {
            initialTimeoutMs = 2500;
        }
        if (maxNumRetries <= 0) {
            maxNumRetries = 1;
        }
        if (backoffMultiplier <= 0.0f) {
            backoffMultiplier = 1.0f;
        }
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(initialTimeoutMs, maxNumRetries, backoffMultiplier));
    }

    public static void parseVolleyError(VolleyError error, ParseVolleyErrorListener listener) {
        if (listener == null) {
            return;
        }
        if (error instanceof TimeoutError) {
            listener.onTimeoutError(error);
        } else if (error instanceof NoConnectionError) {
            listener.onNoConnectionError(error);
        } else if (error instanceof AuthFailureError) {
            listener.onAuthFailureError(error);
        } else if (error instanceof ClientError) {
            listener.onClientError(error);
        } else if (error instanceof ServerError) {
            listener.onServerError(error);
        } else if (error instanceof NetworkError) {
            listener.onNetworkError(error);
        } else if (error instanceof ParseError) {
            listener.onParseError(error);
        }
    }
}

