/*
 * Decompiled with CFR 0.152.
 */
package ir.siaray.volleyplus.request;

import android.content.Context;
import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.android.volley.Response;
import ir.siaray.volleyplus.VolleyPlus;
import ir.siaray.volleyplus.request.Request;
import ir.siaray.volleyplus.util.VolleyUtils;
import java.util.Map;
import org.json.JSONArray;

public class JsonArrayRequest
extends Request {
    private String mUrl;
    private Context mContext;
    private int mMethod = 0;
    private String mTag = JsonArrayRequest.class.getSimpleName();
    private Map<String, String> mHeader;
    private Request.Priority mPriority = Request.Priority.NORMAL;
    private int mTimeoutMs = 2500;
    private int mNumberOfRetries = 1;
    private float mBackoffMultiplier = 1.0f;
    private Map<String, String> mObjectParams;
    private JSONArray mParams;
    private Response.Listener<JSONArray> mListener;
    private Response.ErrorListener mErrorListener;
    private byte[] mBody;
    private boolean mShouldCache = true;

    private JsonArrayRequest(Context context, String url) {
        super(context);
        this.mContext = context;
        this.mUrl = url;
    }

    public static JsonArrayRequest getInstance(Context context, String url) {
        return new JsonArrayRequest(context, url);
    }

    public JsonArrayRequest setMethod(int method) {
        this.mMethod = method;
        return this;
    }

    public JsonArrayRequest setTag(String tag) {
        this.mTag = tag;
        return this;
    }

    public JsonArrayRequest setHeader(Map<String, String> header) {
        this.mHeader = header;
        return this;
    }

    public JsonArrayRequest setPriority(Request.Priority priority) {
        this.mPriority = priority;
        return this;
    }

    public JsonArrayRequest setTimeout(int timeoutMs) {
        this.mTimeoutMs = timeoutMs;
        return this;
    }

    public JsonArrayRequest setNumberOfRetries(int numberOfRetries) {
        this.mNumberOfRetries = numberOfRetries;
        return this;
    }

    public JsonArrayRequest setBackoffMultiplier(float backoffMultiplier) {
        this.mBackoffMultiplier = backoffMultiplier;
        return this;
    }

    public JsonArrayRequest setBody(byte[] body) {
        this.mBody = body;
        return this;
    }

    public JsonArrayRequest setParams(JSONArray params) {
        this.mParams = params;
        return this;
    }

    public JsonArrayRequest setParams(Map<String, String> params) {
        if (params != null && params.size() > 0) {
            this.mObjectParams = params;
            JSONArray jsonArray = new JSONArray();
            for (String key : params.keySet()) {
                jsonArray.put((Object)params.get(key));
            }
            this.mParams = jsonArray;
        }
        return this;
    }

    public JsonArrayRequest setListener(Response.Listener<JSONArray> listener, Response.ErrorListener errorListener) {
        this.mListener = listener;
        this.mErrorListener = errorListener;
        return this;
    }

    public void send() {
        this.sendRequest();
    }

    private void sendRequest() {
        this.addParamsToGetRequest();
        com.android.volley.toolbox.JsonArrayRequest jsonArrayReq = new com.android.volley.toolbox.JsonArrayRequest(this.mMethod, this.mUrl, this.mParams, this.mListener, this.mErrorListener){

            public Request.Priority getPriority() {
                return JsonArrayRequest.this.mPriority;
            }

            public Map<String, String> getHeaders() throws AuthFailureError {
                return JsonArrayRequest.this.mHeader != null ? JsonArrayRequest.this.mHeader : super.getHeaders();
            }

            public byte[] getBody() {
                return JsonArrayRequest.this.mBody != null ? JsonArrayRequest.this.mBody : super.getBody();
            }
        };
        jsonArrayReq.setShouldCache(this.mShouldCache);
        VolleyPlus.setTimeoutRequest((com.android.volley.Request)jsonArrayReq, this.mTimeoutMs, this.mNumberOfRetries, this.mBackoffMultiplier);
        VolleyPlus.getInstance(this.mContext).addToRequestQueue(jsonArrayReq, this.mTag);
    }

    private void addParamsToGetRequest() {
        if (this.mMethod == 0) {
            this.mUrl = this.mObjectParams != null ? VolleyUtils.buildGetRequestUrl(this.mUrl, this.mObjectParams) : VolleyUtils.buildGetRequestUrl(this.mUrl, this.mParams);
        }
    }

    public JsonArrayRequest setShouldCache(boolean shouldCache) {
        this.mShouldCache = shouldCache;
        return this;
    }
}

