/*
 * Decompiled with CFR 0.152.
 */
package ir.siaray.volleyplus.util;

import android.text.TextUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VolleyUtils {
    public static String buildGetRequestUrl(String url, Map<String, String> params) {
        if (!TextUtils.isEmpty((CharSequence)url) && params != null && params.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (String key : params.keySet()) {
                String value = params.get(key);
                if (value == null) continue;
                try {
                    value = URLEncoder.encode(String.valueOf(value), "UTF-8");
                    if (builder.length() > 0) {
                        builder.append("&");
                    }
                    builder.append(key).append("=").append((Object)value);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            url = url + "?" + builder.toString();
        }
        return url;
    }

    public static String buildGetRequestUrl(String url, JSONObject params) {
        if (!TextUtils.isEmpty((CharSequence)url) && params != null && params.keys() != null) {
            StringBuilder builder = new StringBuilder();
            Iterator it = params.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object value = null;
                try {
                    value = params.get(key);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (value == null) continue;
                try {
                    value = URLEncoder.encode(String.valueOf(value), "UTF-8");
                    if (builder.length() > 0) {
                        builder.append("&");
                    }
                    builder.append(key).append("=").append(value);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            url = url + "?" + builder.toString();
        }
        return url;
    }

    public static String buildGetRequestUrl(String url, JSONArray params) {
        if (!TextUtils.isEmpty((CharSequence)url) && params != null && params.length() > 0) {
            StringBuilder builder = new StringBuilder();
            for (int index = 0; index < params.length(); ++index) {
                Object value = null;
                try {
                    value = params.get(index);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (value == null) continue;
                try {
                    value = URLEncoder.encode(String.valueOf(value), "UTF-8");
                    if (builder.length() > 0) {
                        builder.append("&");
                    }
                    builder.append(index).append("=").append(value);
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            url = url + "?" + builder.toString();
        }
        return url;
    }

    public static String unescapeString(String text) {
        return StringEscapeUtils.unescapeJava((String)text);
    }
}

