/*
 * Decompiled with CFR 0.152.
 */
package ciris.internal.digest;

import ciris.internal.digest.GeneralDigest;
import ciris.internal.digest.Pack$;
import ciris.internal.digest.SHA1Digest$;

public final class SHA1Digest
extends GeneralDigest {
    private int H1 = 0;
    private int H2 = 0;
    private int H3 = 0;
    private int H4 = 0;
    private int H5 = 0;
    private final int[] X = new int[80];
    private int xOff = 0;

    public static int Y1() {
        return SHA1Digest$.MODULE$.Y1();
    }

    public static int Y2() {
        return SHA1Digest$.MODULE$.Y2();
    }

    public static int Y3() {
        return SHA1Digest$.MODULE$.Y3();
    }

    public static int Y4() {
        return SHA1Digest$.MODULE$.Y4();
    }

    public static int digestLength() {
        return SHA1Digest$.MODULE$.digestLength();
    }

    public SHA1Digest() {
        this.reset();
    }

    public int digestSize() {
        return SHA1Digest$.MODULE$.digestLength();
    }

    @Override
    public void processWord(byte[] in, int inOff) {
        int off = inOff;
        int n = in[off] << 24;
        n |= (in[++off] & 0xFF) << 16;
        n |= (in[++off] & 0xFF) << 8;
        this.X[this.xOff] = n |= in[++off] & 0xFF;
        ++this.xOff;
        if (this.xOff == 16) {
            this.processBlock();
            return;
        }
    }

    @Override
    public void processLength(long bitLength) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.X[14] = (int)(bitLength >>> 32);
        this.X[15] = (int)bitLength;
    }

    public int doFinal(byte[] out, int outOff) {
        this.finish();
        Pack$.MODULE$.intToBigEndian(this.H1, out, outOff);
        Pack$.MODULE$.intToBigEndian(this.H2, out, outOff + 4);
        Pack$.MODULE$.intToBigEndian(this.H3, out, outOff + 8);
        Pack$.MODULE$.intToBigEndian(this.H4, out, outOff + 12);
        Pack$.MODULE$.intToBigEndian(this.H5, out, outOff + 16);
        this.reset();
        return SHA1Digest$.MODULE$.digestLength();
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = 1732584193;
        this.H2 = -271733879;
        this.H3 = -1732584194;
        this.H4 = 271733878;
        this.H5 = -1009589776;
        this.xOff = 0;
        for (int i = 0; i != this.X.length; ++i) {
            this.X[i] = 0;
        }
    }

    private int f(int u, int v, int w) {
        return u & v | ~u & w;
    }

    private int h(int u, int v, int w) {
        return u ^ v ^ w;
    }

    private int g(int u, int v, int w) {
        return u & v | u & w | v & w;
    }

    @Override
    public void processBlock() {
        int j;
        int i;
        for (i = 16; i < 80; ++i) {
            int t = this.X[i - 3] ^ this.X[i - 8] ^ this.X[i - 14] ^ this.X[i - 16];
            this.X[i] = t << 1 | t >>> 31;
        }
        int A = this.H1;
        int B = this.H2;
        int C = this.H3;
        int D = this.H4;
        int E = this.H5;
        int idx = 0;
        for (j = 0; j < 4; ++j) {
            E += (A << 5 | A >>> 27) + this.f(B, C, D) + this.X[idx] + SHA1Digest$.MODULE$.Y1();
            B = B << 30 | B >>> 2;
            D += (E << 5 | E >>> 27) + this.f(A, B, C) + this.X[++idx] + SHA1Digest$.MODULE$.Y1();
            A = A << 30 | A >>> 2;
            C += (D << 5 | D >>> 27) + this.f(E, A, B) + this.X[++idx] + SHA1Digest$.MODULE$.Y1();
            E = E << 30 | E >>> 2;
            B += (C << 5 | C >>> 27) + this.f(D, E, A) + this.X[++idx] + SHA1Digest$.MODULE$.Y1();
            D = D << 30 | D >>> 2;
            A += (B << 5 | B >>> 27) + this.f(C, D, E) + this.X[++idx] + SHA1Digest$.MODULE$.Y1();
            C = C << 30 | C >>> 2;
            ++idx;
        }
        for (j = 0; j < 4; ++j) {
            E += (A << 5 | A >>> 27) + this.h(B, C, D) + this.X[idx] + SHA1Digest$.MODULE$.Y2();
            B = B << 30 | B >>> 2;
            D += (E << 5 | E >>> 27) + this.h(A, B, C) + this.X[++idx] + SHA1Digest$.MODULE$.Y2();
            A = A << 30 | A >>> 2;
            C += (D << 5 | D >>> 27) + this.h(E, A, B) + this.X[++idx] + SHA1Digest$.MODULE$.Y2();
            E = E << 30 | E >>> 2;
            B += (C << 5 | C >>> 27) + this.h(D, E, A) + this.X[++idx] + SHA1Digest$.MODULE$.Y2();
            D = D << 30 | D >>> 2;
            A += (B << 5 | B >>> 27) + this.h(C, D, E) + this.X[++idx] + SHA1Digest$.MODULE$.Y2();
            C = C << 30 | C >>> 2;
            ++idx;
        }
        for (j = 0; j < 4; ++j) {
            E += (A << 5 | A >>> 27) + this.g(B, C, D) + this.X[idx] + SHA1Digest$.MODULE$.Y3();
            B = B << 30 | B >>> 2;
            D += (E << 5 | E >>> 27) + this.g(A, B, C) + this.X[++idx] + SHA1Digest$.MODULE$.Y3();
            A = A << 30 | A >>> 2;
            C += (D << 5 | D >>> 27) + this.g(E, A, B) + this.X[++idx] + SHA1Digest$.MODULE$.Y3();
            E = E << 30 | E >>> 2;
            B += (C << 5 | C >>> 27) + this.g(D, E, A) + this.X[++idx] + SHA1Digest$.MODULE$.Y3();
            D = D << 30 | D >>> 2;
            A += (B << 5 | B >>> 27) + this.g(C, D, E) + this.X[++idx] + SHA1Digest$.MODULE$.Y3();
            C = C << 30 | C >>> 2;
            ++idx;
        }
        for (j = 0; j <= 3; ++j) {
            E += (A << 5 | A >>> 27) + this.h(B, C, D) + this.X[idx] + SHA1Digest$.MODULE$.Y4();
            B = B << 30 | B >>> 2;
            D += (E << 5 | E >>> 27) + this.h(A, B, C) + this.X[++idx] + SHA1Digest$.MODULE$.Y4();
            A = A << 30 | A >>> 2;
            C += (D << 5 | D >>> 27) + this.h(E, A, B) + this.X[++idx] + SHA1Digest$.MODULE$.Y4();
            E = E << 30 | E >>> 2;
            B += (C << 5 | C >>> 27) + this.h(D, E, A) + this.X[++idx] + SHA1Digest$.MODULE$.Y4();
            D = D << 30 | D >>> 2;
            A += (B << 5 | B >>> 27) + this.h(C, D, E) + this.X[++idx] + SHA1Digest$.MODULE$.Y4();
            C = C << 30 | C >>> 2;
            ++idx;
        }
        this.H1 += A;
        this.H2 += B;
        this.H3 += C;
        this.H4 += D;
        this.H5 += E;
        this.xOff = 0;
        for (i = 0; i < 16; ++i) {
            this.X[i] = 0;
        }
    }
}

