/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.darwin.connector.confluent;

import it.agilelab.darwin.common.DarwinConcurrentHashMap;
import it.agilelab.darwin.common.DarwinConcurrentHashMap$;
import it.agilelab.darwin.manager.exception.DarwinException;
import it.agilelab.darwin.manager.util.ByteArrayUtils;
import it.agilelab.darwin.manager.util.ByteArrayUtils$;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.avro.Schema;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;

public final class ConfluentSingleObjectEncoding$ {
    public static final ConfluentSingleObjectEncoding$ MODULE$;
    private final byte[] V1_HEADER;
    private final int ID_SIZE;
    private final int HEADER_LENGTH;
    private final DarwinConcurrentHashMap<Schema, Object> schemaMap;

    static {
        new ConfluentSingleObjectEncoding$();
    }

    private byte[] V1_HEADER() {
        return this.V1_HEADER;
    }

    private int ID_SIZE() {
        return this.ID_SIZE;
    }

    private int HEADER_LENGTH() {
        return this.HEADER_LENGTH;
    }

    private DarwinConcurrentHashMap<Schema, Object> schemaMap() {
        return this.schemaMap;
    }

    public DarwinException parseException() {
        return new DarwinException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Byte array is not in correct format."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" First ", " bytes are not equal to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.V1_HEADER().length), this.byteArray2HexString(this.V1_HEADER())}))).toString());
    }

    public boolean isAvroSingleObjectEncoded(byte[] data) {
        if (data.length < this.V1_HEADER().length) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"At least ", " bytes "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.V1_HEADER().length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"required to store the Single-Object Encoder header"})).s((Seq)Nil$.MODULE$)).toString());
        }
        return this.isAvroSingleObjectEncoded(ByteBuffer.wrap(data));
    }

    public boolean isAvroSingleObjectEncoded(ByteBuffer data) {
        try {
            int originalPosition = data.position();
            byte[] buffer = new byte[this.V1_HEADER().length];
            data.get(buffer);
            data.position(originalPosition);
            return Arrays.equals(buffer, this.V1_HEADER());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"At least ", " bytes "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.V1_HEADER().length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"required to store the Single-Object Encoder header"})).s((Seq)Nil$.MODULE$)).toString(), indexOutOfBoundsException);
        }
    }

    public byte[] generateAvroSingleObjectEncoded(byte[] avroPayload, long schemaId, ByteOrder endianness) {
        return (byte[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.V1_HEADER(), ByteArrayUtils.EnrichedInt$.MODULE$.intToByteArray$extension(ByteArrayUtils$.MODULE$.EnrichedInt((int)schemaId), endianness), avroPayload}), ClassTag$.MODULE$.Byte());
    }

    public OutputStream writeHeaderToStream(OutputStream byteStream, long schemaId, ByteOrder endianness) {
        byteStream.write(this.V1_HEADER());
        ByteArrayUtils.EnrichedInt$.MODULE$.writeIntToStream$extension(ByteArrayUtils$.MODULE$.EnrichedInt((int)schemaId), byteStream, endianness);
        return byteStream;
    }

    public OutputStream generateAvroSingleObjectEncoded(OutputStream byteStream, byte[] avroValue, long schemaId, ByteOrder endianness) {
        this.writeHeaderToStream(byteStream, schemaId, endianness);
        byteStream.write(avroValue);
        return byteStream;
    }

    public OutputStream generateAvroSingleObjectEncoded(OutputStream byteStream, long schemaId, ByteOrder endianness, Function1<OutputStream, OutputStream> avroWriter) {
        byteStream.write(this.V1_HEADER());
        ByteArrayUtils.EnrichedInt$.MODULE$.writeIntToStream$extension(ByteArrayUtils$.MODULE$.EnrichedInt((int)schemaId), byteStream, endianness);
        return (OutputStream)avroWriter.apply((Object)byteStream);
    }

    public long extractId(byte[] avroSingleObjectEncoded, ByteOrder endianness) {
        return this.extractId(ByteBuffer.wrap(avroSingleObjectEncoded), endianness);
    }

    public long extractId(ByteBuffer avroSingleObjectEncoded, ByteOrder endianness) {
        if (avroSingleObjectEncoded.remaining() < this.HEADER_LENGTH()) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"At least ", " bytes "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.V1_HEADER().length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"required to store the Single-Object Encoder header"})).s((Seq)Nil$.MODULE$)).toString());
        }
        avroSingleObjectEncoded.position(avroSingleObjectEncoded.position() + this.V1_HEADER().length);
        return this.readInt(avroSingleObjectEncoded, endianness);
    }

    public long readInt(ByteBuffer buf, ByteOrder endianness) {
        long l;
        ByteOrder byteOrder = buf.order();
        ByteOrder byteOrder2 = endianness;
        if (!(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null)) {
            l = buf.getInt();
        } else {
            ByteOrder lastEndianness = buf.order();
            buf.order(endianness);
            int toRet = buf.getInt();
            buf.order(lastEndianness);
            l = toRet;
        }
        return l;
    }

    public Either<byte[], Object> extractId(InputStream inputStream, ByteOrder endianness) {
        Left left;
        int bytesReadMagicBytes;
        byte[] buffer = new byte[this.HEADER_LENGTH()];
        if (inputStream.markSupported()) {
            inputStream.mark(1);
        }
        if ((bytesReadMagicBytes = inputStream.read(buffer, 0, this.V1_HEADER().length)) == 1) {
            if (ByteArrayUtils$.MODULE$.arrayEquals(buffer, this.V1_HEADER(), 0, 0, 1)) {
                int bytesReadFingerPrint = inputStream.read(buffer, 1, this.ID_SIZE());
                if (bytesReadFingerPrint + bytesReadMagicBytes == this.HEADER_LENGTH()) {
                    ByteBuffer buf = ByteBuffer.wrap(buffer, 0, this.HEADER_LENGTH());
                    left = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)this.extractId(buf, endianness)));
                } else {
                    left = package$.MODULE$.Left().apply(Predef$.MODULE$.byteArrayOps(buffer).slice(0, bytesReadFingerPrint + bytesReadMagicBytes));
                }
            } else {
                if (inputStream.markSupported()) {
                    inputStream.reset();
                    inputStream.mark(0);
                }
                left = package$.MODULE$.Left().apply(Predef$.MODULE$.byteArrayOps(buffer).slice(0, this.V1_HEADER().length));
            }
        } else {
            if (inputStream.markSupported()) {
                inputStream.reset();
                inputStream.mark(0);
            }
            left = package$.MODULE$.Left().apply(Predef$.MODULE$.byteArrayOps(buffer).slice(0, bytesReadMagicBytes));
        }
        return left;
    }

    public byte[] dropHeader(byte[] avroSingleObjectEncoded) {
        return (byte[])Predef$.MODULE$.byteArrayOps(avroSingleObjectEncoded).drop(this.HEADER_LENGTH());
    }

    public long getId(Schema schema, Function1<Schema, Object> fingerprinter) {
        return BoxesRunTime.unboxToLong((Object)this.schemaMap().getOrElseUpdate((Object)schema, (Function0)new Serializable(schema, fingerprinter){
            public static final long serialVersionUID = 0L;
            private final Schema schema$1;
            private final Function1 fingerprinter$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return BoxesRunTime.unboxToLong((Object)this.fingerprinter$1.apply((Object)this.schema$1));
            }
            {
                this.schema$1 = schema$1;
                this.fingerprinter$1 = fingerprinter$1;
            }
        }));
    }

    public String byteArray2HexString(byte[] bytes) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.byteArrayOps(bytes).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(byte x$1) {
                return new StringOps(Predef$.MODULE$.augmentString("%02X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$1)}));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("[", " ", "]");
    }

    private ConfluentSingleObjectEncoding$() {
        MODULE$ = this;
        this.V1_HEADER = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)0}), ClassTag$.MODULE$.Byte());
        this.ID_SIZE = 4;
        this.HEADER_LENGTH = this.V1_HEADER().length + this.ID_SIZE();
        this.schemaMap = DarwinConcurrentHashMap$.MODULE$.empty();
    }
}

