/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.darwin.connector.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import it.agilelab.darwin.common.Connector;
import it.agilelab.darwin.common.Logging;
import it.agilelab.darwin.connector.mongo.ConfigurationMongoModels;
import it.agilelab.darwin.manager.SchemaPayloadPair;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.avro.Schema;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.MongoClient;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.Observable;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.package$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\u0007\u000f\u0001eA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\tg\u0001\u0011\t\u0011)A\u0005i!)\u0001\n\u0001C\u0001\u0013\")a\n\u0001C\u0005\u001f\")\u0011\r\u0001C!E\")a\u000f\u0001C\u0005o\"9\u0011q\f\u0001\u0005B\u0005\u0005\u0004bBA7\u0001\u0011%\u0011q\u000e\u0005\b\u0003\u000b\u0003A\u0011IAD\u0011\u001d\tI\t\u0001C!\u0003\u0017Cq!a%\u0001\t\u0003\n)\nC\u0004\u0002\u0018\u0002!\t%!'\u0003\u001d5{gnZ8D_:tWm\u0019;pe*\u0011q\u0002E\u0001\u0006[>twm\u001c\u0006\u0003#I\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005M!\u0012A\u00023be^LgN\u0003\u0002\u0016-\u0005A\u0011mZ5mK2\f'MC\u0001\u0018\u0003\tIGo\u0001\u0001\u0014\t\u0001Q\u0002E\n\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r\u0012\u0012AB2p[6|g.\u0003\u0002&E\tI1i\u001c8oK\u000e$xN\u001d\t\u0003C\u001dJ!\u0001\u000b\u0012\u0003\u000f1{wmZ5oO\u0006YQn\u001c8h_\u000ec\u0017.\u001a8u!\tY\u0013'D\u0001-\u0015\tiRF\u0003\u0002/_\u00059Qn\u001c8h_\u0012\u0014'\"\u0001\u0019\u0002\u0007=\u0014x-\u0003\u00023Y\tYQj\u001c8h_\u000ec\u0017.\u001a8u\u0003-iwN\\4p\u0007>tg-[4\u0011\u0005U*eB\u0001\u001cD\u001d\t9$I\u0004\u00029\u0003:\u0011\u0011\b\u0011\b\u0003u}r!a\u000f \u000e\u0003qR!!\u0010\r\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0012BA\u000b\u0017\u0013\t\u0019B#\u0003\u0002\u0012%%\u0011q\u0002E\u0005\u0003\t:\t\u0001dQ8oM&<WO]1uS>tWj\u001c8h_6{G-\u001a7t\u0013\t1uIA\bCCN,Wj\u001c8h_\u000e{gNZ5h\u0015\t!e\"\u0001\u0004=S:LGO\u0010\u000b\u0004\u00152k\u0005CA&\u0001\u001b\u0005q\u0001\"B\u0015\u0004\u0001\u0004Q\u0003\"B\u001a\u0004\u0001\u0004!\u0014A\u00029beN,'/F\u0001Q!\t\tfL\u0004\u0002S7:\u00111\u000b\u0017\b\u0003)Zs!aO+\n\u0003AJ!aV\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tI&,\u0001\u0003bmJ|'BA,0\u0013\taV,\u0001\u0004TG\",W.\u0019\u0006\u00033jK!a\u00181\u0003\rA\u000b'o]3s\u0015\taV,\u0001\u0005gk2dGj\\1e)\u0005\u0019\u0007c\u00013jY:\u0011Qm\u001a\b\u0003w\u0019L\u0011!H\u0005\u0003Qr\tq\u0001]1dW\u0006<W-\u0003\u0002kW\n\u00191+Z9\u000b\u0005!d\u0002\u0003B\u000en_JL!A\u001c\u000f\u0003\rQ+\b\u000f\\33!\tY\u0002/\u0003\u0002r9\t!Aj\u001c8h!\t\u0019H/D\u0001^\u0013\t)XL\u0001\u0004TG\",W.Y\u0001\bKb$(/Y2u+\rA\u00181\u0001\u000b\bs\u0006U\u0011QFA!!\rQXp`\u0007\u0002w*\u0011A\u0010H\u0001\u0005kRLG.\u0003\u0002\u007fw\n\u0019AK]=\u0011\t\u0005\u0005\u00111\u0001\u0007\u0001\t\u001d\t)A\u0002b\u0001\u0003\u000f\u0011\u0011!Q\t\u0005\u0003\u0013\ty\u0001E\u0002\u001c\u0003\u0017I1!!\u0004\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aGA\t\u0013\r\t\u0019\u0002\b\u0002\u0004\u0003:L\bbBA\f\r\u0001\u0007\u0011\u0011D\u0001\u0002IB!\u00111DA\u0014\u001d\u0011\ti\"!\n\u000f\t\u0005}\u00111\u0005\b\u0004)\u0006\u0005\u0012B\u0001\u00180\u0013\tiR&\u0003\u0002iY%!\u0011\u0011FA\u0016\u0005!!unY;nK:$(B\u00015-\u0011\u001d\tyC\u0002a\u0001\u0003c\t\u0011BZ5fY\u0012t\u0015-\\3\u0011\t\u0005M\u00121\b\b\u0005\u0003k\t9\u0004\u0005\u0002<9%\u0019\u0011\u0011\b\u000f\u0002\rA\u0013X\rZ3g\u0013\u0011\ti$a\u0010\u0003\rM#(/\u001b8h\u0015\r\tI\u0004\b\u0005\b\u0003\u00072\u0001\u0019AA#\u0003\u00051\u0007CB\u000e\u0002H\u0005-s0C\u0002\u0002Jq\u0011\u0011BR;oGRLwN\\\u0019\u0011\t\u00055\u0013\u0011\f\b\u0005\u0003\u001f\n)F\u0004\u0003\u0002\u001e\u0005E\u0013bAA*Y\u0005!!m]8o\u0013\rA\u0017q\u000b\u0006\u0004\u0003'b\u0013\u0002BA.\u0003;\u0012\u0011BQ:p]Z\u000bG.^3\u000b\u0007!\f9&\u0001\u0004j]N,'\u000f\u001e\u000b\u0005\u0003G\nI\u0007E\u0002\u001c\u0003KJ1!a\u001a\u001d\u0005\u0011)f.\u001b;\t\r\u0005-t\u00011\u0001d\u0003\u001d\u00198\r[3nCN\f\u0011#\u001b8tKJ$\u0018J\u001a(pi\u0016C\u0018n\u001d;t)\u0019\t\u0019'!\u001d\u0002|!9\u00111\u000f\u0005A\u0002\u0005U\u0014AC2pY2,7\r^5p]B)1&a\u001e\u0002\u001a%\u0019\u0011\u0011\u0010\u0017\u0003\u001f5{gnZ8D_2dWm\u0019;j_:Dq!! \t\u0001\u0004\ty(\u0001\u0005e_\u000e,X.\u001a8u!\u0011\ti%!!\n\t\u0005\r\u0015Q\f\u0002\r\u0005N|g\u000eR8dk6,g\u000e^\u0001\fGJ,\u0017\r^3UC\ndW\r\u0006\u0002\u0002d\u0005YA/\u00192mK\u0016C\u0018n\u001d;t)\t\ti\tE\u0002\u001c\u0003\u001fK1!!%\u001d\u0005\u001d\u0011un\u001c7fC:\f\u0011\u0003^1cY\u0016\u001c%/Z1uS>t\u0007*\u001b8u)\t\t\t$\u0001\u0006gS:$7k\u00195f[\u0006$B!a'\u0002\"B!1$!(s\u0013\r\ty\n\b\u0002\u0007\u001fB$\u0018n\u001c8\t\r\u0005\rF\u00021\u0001p\u0003\tIG\r")
public class MongoConnector
implements Connector,
Logging {
    private final MongoClient mongoClient;
    private final ConfigurationMongoModels.BaseMongoConfig mongoConfig;
    private Logger it$agilelab$darwin$common$Logging$$_log;
    private volatile boolean bitmap$0;

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public long fingerprint(Schema schema) {
        return Connector.fingerprint$((Connector)this, (Schema)schema);
    }

    public OutputStream writeHeaderToStream(OutputStream byteStream, long schemaId, ByteOrder endianness) {
        return Connector.writeHeaderToStream$((Connector)this, (OutputStream)byteStream, (long)schemaId, (ByteOrder)endianness);
    }

    public byte[] generateAvroSingleObjectEncoded(byte[] avroPayload, Schema schema, ByteOrder endianness, Function1<Schema, Object> getId) {
        return Connector.generateAvroSingleObjectEncoded$((Connector)this, (byte[])avroPayload, (Schema)schema, (ByteOrder)endianness, getId);
    }

    public OutputStream generateAvroSingleObjectEncoded(OutputStream byteStream, byte[] avroValue, long schemaId, ByteOrder endianness) {
        return Connector.generateAvroSingleObjectEncoded$((Connector)this, (OutputStream)byteStream, (byte[])avroValue, (long)schemaId, (ByteOrder)endianness);
    }

    public OutputStream generateAvroSingleObjectEncoded(OutputStream byteStream, long schemaId, ByteOrder endianness, Function1<OutputStream, OutputStream> avroWriter) {
        return Connector.generateAvroSingleObjectEncoded$((Connector)this, (OutputStream)byteStream, (long)schemaId, (ByteOrder)endianness, avroWriter);
    }

    public Tuple2<Schema, byte[]> retrieveSchemaAndAvroPayload(byte[] avroSingleObjectEncoded, ByteOrder endianness, Function1<Object, Option<Schema>> getSchema) {
        return Connector.retrieveSchemaAndAvroPayload$((Connector)this, (byte[])avroSingleObjectEncoded, (ByteOrder)endianness, getSchema);
    }

    public Schema retrieveSchemaAndAvroPayload(ByteBuffer avroSingleObjectEncoded, ByteOrder endianness, Function1<Object, Option<Schema>> getSchema) {
        return Connector.retrieveSchemaAndAvroPayload$((Connector)this, (ByteBuffer)avroSingleObjectEncoded, (ByteOrder)endianness, getSchema);
    }

    public Either<byte[], Schema> extractSchema(InputStream inputStream, ByteOrder endianness, Function1<Object, Option<Schema>> getSchema) {
        return Connector.extractSchema$((Connector)this, (InputStream)inputStream, (ByteOrder)endianness, getSchema);
    }

    public Either<Exception, Schema> extractSchema(byte[] array, ByteOrder endianness, Function1<Object, Option<Schema>> getSchema) {
        return Connector.extractSchema$((Connector)this, (byte[])array, (ByteOrder)endianness, getSchema);
    }

    public long extractId(byte[] array, ByteOrder endianness) {
        return Connector.extractId$((Connector)this, (byte[])array, (ByteOrder)endianness);
    }

    public Either<byte[], Object> extractId(InputStream inputStream, ByteOrder endianness) {
        return Connector.extractId$((Connector)this, (InputStream)inputStream, (ByteOrder)endianness);
    }

    public long extractId(ByteBuffer avroSingleObjectEncoded, ByteOrder endianness) {
        return Connector.extractId$((Connector)this, (ByteBuffer)avroSingleObjectEncoded, (ByteOrder)endianness);
    }

    public SchemaPayloadPair retrieveSchemaAndPayload(byte[] avroSingleObjectEncoded, ByteOrder endianness, Function1<Object, Option<Schema>> getSchema) {
        return Connector.retrieveSchemaAndPayload$((Connector)this, (byte[])avroSingleObjectEncoded, (ByteOrder)endianness, getSchema);
    }

    private Logger it$agilelab$darwin$common$Logging$$_log$lzycompute() {
        MongoConnector mongoConnector = this;
        synchronized (mongoConnector) {
            if (!this.bitmap$0) {
                this.it$agilelab$darwin$common$Logging$$_log = Logging.it$agilelab$darwin$common$Logging$$_log$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.it$agilelab$darwin$common$Logging$$_log;
    }

    public Logger it$agilelab$darwin$common$Logging$$_log() {
        return !this.bitmap$0 ? this.it$agilelab$darwin$common$Logging$$_log$lzycompute() : this.it$agilelab$darwin$common$Logging$$_log;
    }

    private Schema.Parser parser() {
        return new Schema.Parser();
    }

    public Seq<Tuple2<Object, Schema>> fullLoad() {
        this.log().debug(new StringBuilder(36).append("loading all schemas from collection ").append(this.mongoConfig.collection()).toString());
        MongoCollection collection = this.mongoClient.getDatabase(this.mongoConfig.database()).getCollection(this.mongoConfig.collection(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
        Seq schemas = (Seq)Await$.MODULE$.result((Awaitable)package$.MODULE$.ScalaObservable(package$.MODULE$.ScalaObservable((Observable)collection.find(DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))).map((Function1 & Serializable & scala.Serializable)document -> this.extract((Document)document, "_id", (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)MongoConnector.$anonfun$fullLoad$2(x$1))).flatMap((Function1 & Serializable & scala.Serializable)key -> MongoConnector.$anonfun$fullLoad$3(this, document, BoxesRunTime.unboxToLong((Object)key))))).toFuture(), this.mongoConfig.timeout());
        this.log().debug(new StringBuilder(20).append(schemas.size()).append(" loaded from MongoDB").toString());
        return (Seq)schemas.map((Function1 & Serializable & scala.Serializable)x$3 -> (Tuple2)x$3.get(), Seq$.MODULE$.canBuildFrom());
    }

    private <A> Try<A> extract(Document d, String fieldName, Function1<BsonValue, A> f) {
        return (Try)((TraversableLike)d.filterKeys((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)MongoConnector.$anonfun$extract$1(fieldName, k)))).headOption().fold((Function0 & Serializable & scala.Serializable)() -> new Failure((Throwable)new RuntimeException(new StringBuilder(30).append("Cannot find ").append(fieldName).append(" field in document").toString())), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BsonValue value = (BsonValue)tuple2._2();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> f.apply((Object)value)).recoverWith((PartialFunction)new scala.Serializable(null, fieldName){
                public static final long serialVersionUID = 0L;
                private final String fieldName$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        A1 A12 = A1;
                        object = new Failure((Throwable)new RuntimeException(new StringBuilder(25).append(this.fieldName$1).append(" was not of expected type").toString(), A12));
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = throwable != null;
                    return bl;
                }
                {
                    this.fieldName$1 = fieldName$1;
                }
            });
            return try_;
        });
    }

    public void insert(Seq<Tuple2<Object, Schema>> schemas) {
        this.log().debug(new StringBuilder(43).append("inclusion of new schemas in the collection ").append(this.mongoConfig.collection()).toString());
        schemas.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MongoConnector.$anonfun$insert$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void insertIfNotExists(MongoCollection<Document> collection, BsonDocument document) {
        Object object;
        try {
            object = Await$.MODULE$.result((Awaitable)package$.MODULE$.ScalaSingleObservable(collection.insertOne((Object)package$.MODULE$.bsonDocumentToDocument(document))).toFuture(), this.mongoConfig.timeout());
        }
        catch (Throwable throwable) {
            block5: {
                block4: {
                    Throwable throwable2 = throwable;
                    if (!(throwable2 instanceof MongoWriteException)) break block4;
                    MongoWriteException mongoWriteException = (MongoWriteException)throwable2;
                    ErrorCategory errorCategory = mongoWriteException.getError().getCategory();
                    ErrorCategory errorCategory2 = ErrorCategory.DUPLICATE_KEY;
                    if (!(errorCategory != null ? !errorCategory.equals(errorCategory2) : errorCategory2 != null)) break block5;
                }
                throw throwable;
            }
            this.log().info("document already present, doing nothing");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            object = boxedUnit;
        }
    }

    public void createTable() {
        this.log().debug(new StringBuilder(20).append("Creating collection ").append(this.mongoConfig.collection()).toString());
        try {
            Await$.MODULE$.result((Awaitable)package$.MODULE$.ScalaSingleObservable(this.mongoClient.getDatabase(this.mongoConfig.database()).createCollection(this.mongoConfig.collection())).toFuture(), this.mongoConfig.timeout());
            this.log().info(new StringBuilder(38).append("collection ").append(this.mongoConfig.collection()).append(" has been correctly created").toString());
        }
        catch (Exception e) {
            this.log().info(new StringBuilder(31).append("collection ").append(this.mongoConfig.collection()).append(" was not created. \n ").append(e.getMessage()).toString());
        }
    }

    public boolean tableExists() {
        return BoxesRunTime.unboxToInt((Object)Await$.MODULE$.result((Awaitable)package$.MODULE$.ScalaObservable(package$.MODULE$.ScalaObservable(this.mongoClient.getDatabase(this.mongoConfig.database()).listCollectionNames()).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)MongoConnector.$anonfun$tableExists$1(this, x)))).toFuture().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()), ExecutionContext.Implicits$.MODULE$.global()), this.mongoConfig.timeout())) == 1;
    }

    public String tableCreationHint() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("To create the collection from shell perform the following command:\n       |db.createCollection(").append(this.mongoConfig.collection()).append(")\n     ").toString())).stripMargin();
    }

    public Option<Schema> findSchema(long id) {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)BsonInt64$.MODULE$.apply(id));
        Future documents = package$.MODULE$.ScalaObservable((Observable)this.mongoClient.getDatabase(this.mongoConfig.database()).getCollection(this.mongoConfig.collection(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)).find((Bson)query, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))).toFuture();
        Seq schemaValue = (Seq)((TraversableLike)Await$.MODULE$.result((Awaitable)documents, this.mongoConfig.timeout())).flatMap((Function1 & Serializable & scala.Serializable)document -> (Traversable)document.withFilter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)MongoConnector.$anonfun$findSchema$2(field))).map((Function1 & Serializable & scala.Serializable)field -> ((BsonValue)field._2()).asString().getValue(), Traversable$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Schema.Parser parser = this.parser();
        return schemaValue.headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> parser.parse(x$1));
    }

    public static final /* synthetic */ long $anonfun$fullLoad$2(BsonValue x$1) {
        return x$1.asInt64().getValue();
    }

    public static final /* synthetic */ Try $anonfun$fullLoad$3(MongoConnector $this, Document document$1, long key) {
        return $this.extract(document$1, "schema", (Function1 & Serializable & scala.Serializable)x$2 -> x$2.asString().getValue()).flatMap((Function1 & Serializable & scala.Serializable)schemaStr -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.parser().parse(schemaStr)).map((Function1 & Serializable & scala.Serializable)schema -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)key)), schema)));
    }

    public static final /* synthetic */ boolean $anonfun$extract$1(String fieldName$1, String k) {
        String string = k;
        String string2 = fieldName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$insert$1(MongoConnector $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long id = tuple2._1$mcJ$sp();
        Schema schema = (Schema)tuple2._2();
        BsonDocument document = new BsonDocument();
        document.put("_id", (BsonValue)BsonInt64$.MODULE$.apply(id));
        document.put("schema", (BsonValue)BsonString$.MODULE$.apply(schema.toString()));
        document.put("name", (BsonValue)BsonString$.MODULE$.apply(schema.getName()));
        document.put("namespace", (BsonValue)BsonString$.MODULE$.apply(schema.getNamespace()));
        $this.insertIfNotExists((MongoCollection<Document>)$this.mongoClient.getDatabase($this.mongoConfig.database()).getCollection($this.mongoConfig.collection(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)), document);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$tableExists$1(MongoConnector $this, String x) {
        String string = x;
        String string2 = $this.mongoConfig.collection();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findSchema$2(Tuple2 field) {
        Object object = field._1();
        String string = "schema";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public MongoConnector(MongoClient mongoClient, ConfigurationMongoModels.BaseMongoConfig mongoConfig) {
        this.mongoClient = mongoClient;
        this.mongoConfig = mongoConfig;
        Connector.$init$((Connector)this);
        Logging.$init$((Logging)this);
    }
}

