/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.darwin.connector.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import it.agilelab.darwin.common.Connector;
import it.agilelab.darwin.common.Logging;
import it.agilelab.darwin.connector.mongo.ConfigurationMongoModels;
import it.agilelab.darwin.manager.SchemaPayloadPair;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.avro.Schema;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.MongoClient;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.Observable;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.package$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001\u0002\b\u0010\u0001iA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\ti\u0001\u0011\t\u0011)A\u0005k!)\u0011\n\u0001C\u0001\u0015\")q\n\u0001C\u0005!\")!\r\u0001C!G\")q\u000f\u0001C\u0005q\"9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA8\u0001\u0011%\u0011\u0011\u000f\u0005\b\u0003\u000f\u0003A\u0011IAE\u0011\u001d\tY\t\u0001C!\u0003\u001bCq!!&\u0001\t\u0003\n9\nC\u0004\u0002\u001a\u0002!\t%a'\t\u000f\u0005\u001d\u0006\u0001\"\u0011\u0002*\nqQj\u001c8h_\u000e{gN\\3di>\u0014(B\u0001\t\u0012\u0003\u0015iwN\\4p\u0015\t\u00112#A\u0005d_:tWm\u0019;pe*\u0011A#F\u0001\u0007I\u0006\u0014x/\u001b8\u000b\u0005Y9\u0012\u0001C1hS2,G.\u00192\u000b\u0003a\t!!\u001b;\u0004\u0001M!\u0001aG\u0011(!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fMB\u0011!%J\u0007\u0002G)\u0011AeE\u0001\u0007G>lWn\u001c8\n\u0005\u0019\u001a#!C\"p]:,7\r^8s!\t\u0011\u0003&\u0003\u0002*G\t9Aj\\4hS:<\u0017aC7p]\u001e|7\t\\5f]R\u0004\"\u0001\f\u001a\u000e\u00035R!A\b\u0018\u000b\u0005=\u0002\u0014aB7p]\u001e|GM\u0019\u0006\u0002c\u0005\u0019qN]4\n\u0005Mj#aC'p]\u001e|7\t\\5f]R\f1\"\\8oO>\u001cuN\u001c4jOB\u0011aG\u0012\b\u0003o\u0011s!\u0001O\"\u000f\u0005e\u0012eB\u0001\u001eB\u001d\tY\u0004I\u0004\u0002=\u007f5\tQH\u0003\u0002?3\u00051AH]8pizJ\u0011\u0001G\u0005\u0003-]I!\u0001F\u000b\n\u0005I\u0019\u0012B\u0001\t\u0012\u0013\t)u\"\u0001\rD_:4\u0017nZ;sCRLwN\\'p]\u001e|Wj\u001c3fYNL!a\u0012%\u0003\u001f\t\u000b7/Z'p]\u001e|7i\u001c8gS\u001eT!!R\b\u0002\rqJg.\u001b;?)\rYUJ\u0014\t\u0003\u0019\u0002i\u0011a\u0004\u0005\u0006U\r\u0001\ra\u000b\u0005\u0006i\r\u0001\r!N\u0001\u0007a\u0006\u00148/\u001a:\u0016\u0003E\u0003\"AU0\u000f\u0005McfB\u0001+Z\u001d\t)vK\u0004\u0002=-&\t\u0011'\u0003\u0002Ya\u00051\u0011\r]1dQ\u0016L!AW.\u0002\t\u00054(o\u001c\u0006\u00031BJ!!\u00180\u0002\rM\u001b\u0007.Z7b\u0015\tQ6,\u0003\u0002aC\n1\u0001+\u0019:tKJT!!\u00180\u0002\u0011\u0019,H\u000e\u001c'pC\u0012$\u0012\u0001\u001a\t\u0004K*lgB\u00014i\u001d\tat-C\u0001\u001f\u0013\tIW$A\u0004qC\u000e\\\u0017mZ3\n\u0005-d'aA*fc*\u0011\u0011.\b\t\u000599\u00048/\u0003\u0002p;\t1A+\u001e9mKJ\u0002\"\u0001H9\n\u0005Il\"\u0001\u0002'p]\u001e\u0004\"\u0001^;\u000e\u0003yK!A\u001e0\u0003\rM\u001b\u0007.Z7b\u0003\u001d)\u0007\u0010\u001e:bGR,2!_A\u0003)\u001dQ\u0018qCA\u0018\u0003\u0007\u0002Ba\u001f@\u0002\u00025\tAP\u0003\u0002~;\u0005!Q\u000f^5m\u0013\tyHPA\u0002Uef\u0004B!a\u0001\u0002\u00061\u0001AaBA\u0004\r\t\u0007\u0011\u0011\u0002\u0002\u0002\u0003F!\u00111BA\t!\ra\u0012QB\u0005\u0004\u0003\u001fi\"a\u0002(pi\"Lgn\u001a\t\u00049\u0005M\u0011bAA\u000b;\t\u0019\u0011I\\=\t\u000f\u0005ea\u00011\u0001\u0002\u001c\u0005\tA\r\u0005\u0003\u0002\u001e\u0005%b\u0002BA\u0010\u0003OqA!!\t\u0002&9\u0019Q+a\t\n\u0005=\u0002\u0014B\u0001\u0010/\u0013\tIW&\u0003\u0003\u0002,\u00055\"\u0001\u0003#pGVlWM\u001c;\u000b\u0005%l\u0003bBA\u0019\r\u0001\u0007\u00111G\u0001\nM&,G\u000e\u001a(b[\u0016\u0004B!!\u000e\u0002>9!\u0011qGA\u001d!\taT$C\u0002\u0002<u\ta\u0001\u0015:fI\u00164\u0017\u0002BA \u0003\u0003\u0012aa\u0015;sS:<'bAA\u001e;!9\u0011Q\t\u0004A\u0002\u0005\u001d\u0013!\u00014\u0011\u000fq\tI%!\u0014\u0002\u0002%\u0019\u00111J\u000f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA(\u00037rA!!\u0015\u0002X9!\u0011qDA*\u0013\r\t)&L\u0001\u0005EN|g.C\u0002j\u00033R1!!\u0016.\u0013\u0011\ti&a\u0018\u0003\u0013\t\u001bxN\u001c,bYV,'bA5\u0002Z\u00051\u0011N\\:feR$B!!\u001a\u0002lA\u0019A$a\u001a\n\u0007\u0005%TD\u0001\u0003V]&$\bBBA7\u000f\u0001\u0007A-A\u0004tG\",W.Y:\u0002#%t7/\u001a:u\u0013\u001atu\u000e^#ySN$8\u000f\u0006\u0004\u0002f\u0005M\u0014Q\u0010\u0005\b\u0003kB\u0001\u0019AA<\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\t\u0006Y\u0005e\u00141D\u0005\u0004\u0003wj#aD'p]\u001e|7i\u001c7mK\u000e$\u0018n\u001c8\t\u000f\u0005}\u0004\u00021\u0001\u0002\u0002\u0006AAm\\2v[\u0016tG\u000f\u0005\u0003\u0002P\u0005\r\u0015\u0002BAC\u0003?\u0012ABQ:p]\u0012{7-^7f]R\f1b\u0019:fCR,G+\u00192mKR\u0011\u0011QM\u0001\fi\u0006\u0014G.Z#ySN$8\u000f\u0006\u0002\u0002\u0010B\u0019A$!%\n\u0007\u0005MUDA\u0004C_>dW-\u00198\u0002#Q\f'\r\\3De\u0016\fG/[8o\u0011&tG\u000f\u0006\u0002\u00024\u0005Qa-\u001b8e'\u000eDW-\\1\u0015\t\u0005u\u00151\u0015\t\u00059\u0005}5/C\u0002\u0002\"v\u0011aa\u00149uS>t\u0007BBAS\u0019\u0001\u0007\u0001/\u0001\u0002jI\u0006!\"/\u001a;sS\u00164X\rT1uKN$8k\u00195f[\u0006$B!a+\u0002.B!A$a(n\u0011\u001d\ty+\u0004a\u0001\u0003g\t!\"\u001b3f]RLg-[3s\u0001")
public class MongoConnector
implements Connector,
Logging {
    private final MongoClient mongoClient;
    private final ConfigurationMongoModels.BaseMongoConfig mongoConfig;
    private Logger it$agilelab$darwin$common$Logging$$_log;
    private volatile boolean bitmap$0;

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public long fingerprint(Schema schema) {
        return Connector.fingerprint$((Connector)this, (Schema)schema);
    }

    public OutputStream writeHeaderToStream(OutputStream byteStream, long schemaId, ByteOrder endianness) {
        return Connector.writeHeaderToStream$((Connector)this, (OutputStream)byteStream, (long)schemaId, (ByteOrder)endianness);
    }

    public byte[] generateAvroSingleObjectEncoded(byte[] avroPayload, Schema schema, ByteOrder endianness, Function1<Schema, Object> getId) {
        return Connector.generateAvroSingleObjectEncoded$((Connector)this, (byte[])avroPayload, (Schema)schema, (ByteOrder)endianness, getId);
    }

    public OutputStream generateAvroSingleObjectEncoded(OutputStream byteStream, byte[] avroValue, long schemaId, ByteOrder endianness) {
        return Connector.generateAvroSingleObjectEncoded$((Connector)this, (OutputStream)byteStream, (byte[])avroValue, (long)schemaId, (ByteOrder)endianness);
    }

    public OutputStream generateAvroSingleObjectEncoded(OutputStream byteStream, long schemaId, ByteOrder endianness, Function1<OutputStream, OutputStream> avroWriter) {
        return Connector.generateAvroSingleObjectEncoded$((Connector)this, (OutputStream)byteStream, (long)schemaId, (ByteOrder)endianness, avroWriter);
    }

    public Tuple2<Schema, byte[]> retrieveSchemaAndAvroPayload(byte[] avroSingleObjectEncoded, ByteOrder endianness, Function1<Object, Option<Schema>> getSchema) {
        return Connector.retrieveSchemaAndAvroPayload$((Connector)this, (byte[])avroSingleObjectEncoded, (ByteOrder)endianness, getSchema);
    }

    public Schema retrieveSchemaAndAvroPayload(ByteBuffer avroSingleObjectEncoded, ByteOrder endianness, Function1<Object, Option<Schema>> getSchema) {
        return Connector.retrieveSchemaAndAvroPayload$((Connector)this, (ByteBuffer)avroSingleObjectEncoded, (ByteOrder)endianness, getSchema);
    }

    public Either<byte[], Schema> extractSchema(InputStream inputStream, ByteOrder endianness, Function1<Object, Option<Schema>> getSchema) {
        return Connector.extractSchema$((Connector)this, (InputStream)inputStream, (ByteOrder)endianness, getSchema);
    }

    public Either<Exception, Schema> extractSchema(byte[] array, ByteOrder endianness, Function1<Object, Option<Schema>> getSchema) {
        return Connector.extractSchema$((Connector)this, (byte[])array, (ByteOrder)endianness, getSchema);
    }

    public long extractId(byte[] array, ByteOrder endianness) {
        return Connector.extractId$((Connector)this, (byte[])array, (ByteOrder)endianness);
    }

    public Either<byte[], Object> extractId(InputStream inputStream, ByteOrder endianness) {
        return Connector.extractId$((Connector)this, (InputStream)inputStream, (ByteOrder)endianness);
    }

    public long extractId(ByteBuffer avroSingleObjectEncoded, ByteOrder endianness) {
        return Connector.extractId$((Connector)this, (ByteBuffer)avroSingleObjectEncoded, (ByteOrder)endianness);
    }

    public SchemaPayloadPair retrieveSchemaAndPayload(byte[] avroSingleObjectEncoded, ByteOrder endianness, Function1<Object, Option<Schema>> getSchema) {
        return Connector.retrieveSchemaAndPayload$((Connector)this, (byte[])avroSingleObjectEncoded, (ByteOrder)endianness, getSchema);
    }

    private Logger it$agilelab$darwin$common$Logging$$_log$lzycompute() {
        MongoConnector mongoConnector = this;
        synchronized (mongoConnector) {
            if (!this.bitmap$0) {
                this.it$agilelab$darwin$common$Logging$$_log = Logging.it$agilelab$darwin$common$Logging$$_log$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.it$agilelab$darwin$common$Logging$$_log;
    }

    public Logger it$agilelab$darwin$common$Logging$$_log() {
        return !this.bitmap$0 ? this.it$agilelab$darwin$common$Logging$$_log$lzycompute() : this.it$agilelab$darwin$common$Logging$$_log;
    }

    private Schema.Parser parser() {
        return new Schema.Parser();
    }

    public Seq<Tuple2<Object, Schema>> fullLoad() {
        this.log().debug(new StringBuilder(36).append("loading all schemas from collection ").append(this.mongoConfig.collection()).toString());
        MongoCollection collection = this.mongoClient.getDatabase(this.mongoConfig.database()).getCollection(this.mongoConfig.collection(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
        Seq schemas = (Seq)Await$.MODULE$.result((Awaitable)package$.MODULE$.ScalaObservable(package$.MODULE$.ScalaObservable((Observable)collection.find(DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))).map((Function1 & Serializable & scala.Serializable)document -> this.extract((Document)document, "_id", (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)MongoConnector.$anonfun$fullLoad$2(x$1))).flatMap((Function1 & Serializable & scala.Serializable)key -> MongoConnector.$anonfun$fullLoad$3(this, document, BoxesRunTime.unboxToLong((Object)key))))).toFuture(), this.mongoConfig.timeout());
        this.log().debug(new StringBuilder(20).append(schemas.size()).append(" loaded from MongoDB").toString());
        return (Seq)schemas.map((Function1 & Serializable & scala.Serializable)x$3 -> (Tuple2)x$3.get(), Seq$.MODULE$.canBuildFrom());
    }

    private <A> Try<A> extract(Document d, String fieldName, Function1<BsonValue, A> f) {
        return (Try)((TraversableLike)d.filterKeys((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)MongoConnector.$anonfun$extract$1(fieldName, k)))).headOption().fold((Function0 & Serializable & scala.Serializable)() -> new Failure((Throwable)new RuntimeException(new StringBuilder(30).append("Cannot find ").append(fieldName).append(" field in document").toString())), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BsonValue value = (BsonValue)tuple2._2();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> f.apply((Object)value)).recoverWith((PartialFunction)new scala.Serializable(null, fieldName){
                public static final long serialVersionUID = 0L;
                private final String fieldName$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        A1 A12 = A1;
                        object = new Failure((Throwable)new RuntimeException(new StringBuilder(25).append(this.fieldName$1).append(" was not of expected type").toString(), A12));
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = throwable != null;
                    return bl;
                }
                {
                    this.fieldName$1 = fieldName$1;
                }
            });
            return try_;
        });
    }

    public void insert(Seq<Tuple2<Object, Schema>> schemas) {
        this.log().debug(new StringBuilder(43).append("inclusion of new schemas in the collection ").append(this.mongoConfig.collection()).toString());
        schemas.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MongoConnector.$anonfun$insert$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void insertIfNotExists(MongoCollection<Document> collection, BsonDocument document) {
        Object object;
        try {
            object = Await$.MODULE$.result((Awaitable)package$.MODULE$.ScalaSingleObservable(collection.insertOne((Object)package$.MODULE$.bsonDocumentToDocument(document))).toFuture(), this.mongoConfig.timeout());
        }
        catch (Throwable throwable) {
            block5: {
                block4: {
                    Throwable throwable2 = throwable;
                    if (!(throwable2 instanceof MongoWriteException)) break block4;
                    MongoWriteException mongoWriteException = (MongoWriteException)throwable2;
                    ErrorCategory errorCategory = mongoWriteException.getError().getCategory();
                    ErrorCategory errorCategory2 = ErrorCategory.DUPLICATE_KEY;
                    if (!(errorCategory != null ? !errorCategory.equals(errorCategory2) : errorCategory2 != null)) break block5;
                }
                throw throwable;
            }
            this.log().info("document already present, doing nothing");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            object = boxedUnit;
        }
    }

    public void createTable() {
        this.log().debug(new StringBuilder(20).append("Creating collection ").append(this.mongoConfig.collection()).toString());
        try {
            Await$.MODULE$.result((Awaitable)package$.MODULE$.ScalaSingleObservable(this.mongoClient.getDatabase(this.mongoConfig.database()).createCollection(this.mongoConfig.collection())).toFuture(), this.mongoConfig.timeout());
            this.log().info(new StringBuilder(38).append("collection ").append(this.mongoConfig.collection()).append(" has been correctly created").toString());
        }
        catch (Exception e) {
            this.log().info(new StringBuilder(31).append("collection ").append(this.mongoConfig.collection()).append(" was not created. \n ").append(e.getMessage()).toString());
        }
    }

    public boolean tableExists() {
        return BoxesRunTime.unboxToInt((Object)Await$.MODULE$.result((Awaitable)package$.MODULE$.ScalaObservable(package$.MODULE$.ScalaObservable(this.mongoClient.getDatabase(this.mongoConfig.database()).listCollectionNames()).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)MongoConnector.$anonfun$tableExists$1(this, x)))).toFuture().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()), ExecutionContext.Implicits$.MODULE$.global()), this.mongoConfig.timeout())) == 1;
    }

    public String tableCreationHint() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("To create the collection from shell perform the following command:\n       |db.createCollection(").append(this.mongoConfig.collection()).append(")\n     ").toString())).stripMargin();
    }

    public Option<Schema> findSchema(long id) {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)BsonInt64$.MODULE$.apply(id));
        Future documents = package$.MODULE$.ScalaObservable((Observable)this.mongoClient.getDatabase(this.mongoConfig.database()).getCollection(this.mongoConfig.collection(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)).find((Bson)query, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))).toFuture();
        Seq schemaValue = (Seq)((TraversableLike)Await$.MODULE$.result((Awaitable)documents, this.mongoConfig.timeout())).flatMap((Function1 & Serializable & scala.Serializable)document -> (Traversable)document.withFilter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)MongoConnector.$anonfun$findSchema$2(field))).map((Function1 & Serializable & scala.Serializable)field -> ((BsonValue)field._2()).asString().getValue(), Traversable$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Schema.Parser parser = this.parser();
        return schemaValue.headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> parser.parse(x$1));
    }

    public Option<Tuple2<Object, Schema>> retrieveLatestSchema(String identifier) {
        return None$.MODULE$;
    }

    public static final /* synthetic */ long $anonfun$fullLoad$2(BsonValue x$1) {
        return x$1.asInt64().getValue();
    }

    public static final /* synthetic */ Try $anonfun$fullLoad$3(MongoConnector $this, Document document$1, long key) {
        return $this.extract(document$1, "schema", (Function1 & Serializable & scala.Serializable)x$2 -> x$2.asString().getValue()).flatMap((Function1 & Serializable & scala.Serializable)schemaStr -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.parser().parse(schemaStr)).map((Function1 & Serializable & scala.Serializable)schema -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)key)), schema)));
    }

    public static final /* synthetic */ boolean $anonfun$extract$1(String fieldName$1, String k) {
        String string = k;
        String string2 = fieldName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$insert$1(MongoConnector $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long id = tuple2._1$mcJ$sp();
        Schema schema = (Schema)tuple2._2();
        BsonDocument document = new BsonDocument();
        document.put("_id", (BsonValue)BsonInt64$.MODULE$.apply(id));
        document.put("schema", (BsonValue)BsonString$.MODULE$.apply(schema.toString()));
        document.put("name", (BsonValue)BsonString$.MODULE$.apply(schema.getName()));
        document.put("namespace", (BsonValue)BsonString$.MODULE$.apply(schema.getNamespace()));
        $this.insertIfNotExists((MongoCollection<Document>)$this.mongoClient.getDatabase($this.mongoConfig.database()).getCollection($this.mongoConfig.collection(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)), document);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$tableExists$1(MongoConnector $this, String x) {
        String string = x;
        String string2 = $this.mongoConfig.collection();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findSchema$2(Tuple2 field) {
        Object object = field._1();
        String string = "schema";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public MongoConnector(MongoClient mongoClient, ConfigurationMongoModels.BaseMongoConfig mongoConfig) {
        this.mongoClient = mongoClient;
        this.mongoConfig = mongoConfig;
        Connector.$init$((Connector)this);
        Logging.$init$((Logging)this);
    }
}

