/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.darwin.connector.mongo;

import com.mongodb.Block;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.connection.ClusterSettings;
import com.typesafe.config.Config;
import it.agilelab.darwin.common.Connector;
import it.agilelab.darwin.common.ConnectorCreator;
import it.agilelab.darwin.common.compat.package$;
import it.agilelab.darwin.connector.mongo.ConfigurationKeys$;
import it.agilelab.darwin.connector.mongo.ConfigurationMongoModels;
import it.agilelab.darwin.connector.mongo.ConfigurationMongoModels$;
import it.agilelab.darwin.connector.mongo.MongoConnector;
import java.io.Serializable;
import java.util.Arrays;
import org.mongodb.scala.MongoClient;
import org.mongodb.scala.MongoClient$;
import org.mongodb.scala.MongoClientSettings$;
import org.mongodb.scala.MongoCredential$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00054AAB\u0004\u0001%!)q\u0004\u0001C\u0001A!)1\u0005\u0001C!I!)1\u0007\u0001C!i!)\u0001\t\u0001C\u0005\u0003\")a\f\u0001C\u0001?\n)Rj\u001c8h_\u000e{gN\\3di>\u00148I]3bi>\u0014(B\u0001\u0005\n\u0003\u0015iwN\\4p\u0015\tQ1\"A\u0005d_:tWm\u0019;pe*\u0011A\"D\u0001\u0007I\u0006\u0014x/\u001b8\u000b\u00059y\u0011\u0001C1hS2,G.\u00192\u000b\u0003A\t!!\u001b;\u0004\u0001M\u0019\u0001aE\r\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g!\tQR$D\u0001\u001c\u0015\ta2\"\u0001\u0004d_6lwN\\\u0005\u0003=m\u0011\u0001cQ8o]\u0016\u001cGo\u001c:De\u0016\fGo\u001c:\u0002\rqJg.\u001b;?)\u0005\t\u0003C\u0001\u0012\u0001\u001b\u00059\u0011AB2sK\u0006$X\r\u0006\u0002&QA\u0011!DJ\u0005\u0003Om\u0011\u0011bQ8o]\u0016\u001cGo\u001c:\t\u000b%\u0012\u0001\u0019\u0001\u0016\u0002\r\r|gNZ5h!\tY\u0013'D\u0001-\u0015\tISF\u0003\u0002/_\u0005AA/\u001f9fg\u00064WMC\u00011\u0003\r\u0019w.\\\u0005\u0003e1\u0012aaQ8oM&<\u0017\u0001\u00028b[\u0016$\u0012!\u000e\t\u0003mur!aN\u001e\u0011\u0005a*R\"A\u001d\u000b\u0005i\n\u0012A\u0002\u001fs_>$h(\u0003\u0002=+\u00051\u0001K]3eK\u001aL!AP \u0003\rM#(/\u001b8h\u0015\taT#\u0001\tde\u0016\fG/Z\"p]:,7\r^5p]R\u0011!i\u0013\t\u0003\u0007&k\u0011\u0001\u0012\u0006\u0003-\u0015S!AR$\u0002\u000f5|gnZ8eE*\t\u0001*A\u0002pe\u001eL!A\u0013#\u0003\u00175{gnZ8DY&,g\u000e\u001e\u0005\u0006\u0019\u0012\u0001\r!T\u0001\n[>twm\\\"p]\u001a\u0004\"AT.\u000f\u0005=KfB\u0001)Y\u001d\t\tvK\u0004\u0002S-:\u00111+\u0016\b\u0003qQK\u0011\u0001E\u0005\u0003\u001d=I!\u0001D\u0007\n\u0005)Y\u0011B\u0001\u0005\n\u0013\tQv!\u0001\rD_:4\u0017nZ;sCRLwN\\'p]\u001e|Wj\u001c3fYNL!\u0001X/\u0003)5{gnZ8D_:tWm\u0019;pe\u000e{gNZ5h\u0015\tQv!\u0001\u0007de\u0016\fG/Z\"p]\u001aLw\r\u0006\u0002NA\")\u0011&\u0002a\u0001U\u0001")
public class MongoConnectorCreator
implements ConnectorCreator {
    public Connector create(Config config) {
        ConfigurationMongoModels.MongoConnectorConfig mongoConfig = this.createConfig(config);
        return new MongoConnector(this.createConnection(mongoConfig), mongoConfig);
    }

    public String name() {
        return "mongo";
    }

    private MongoClient createConnection(ConfigurationMongoModels.MongoConnectorConfig mongoConf) {
        MongoCredential credential = MongoCredential$.MODULE$.createCredential(mongoConf.username(), mongoConf.database(), mongoConf.password().toCharArray());
        Seq hosts = (Seq)mongoConf.hosts().map((Function1 & Serializable & scala.Serializable)host -> new ServerAddress(host), Seq$.MODULE$.canBuildFrom());
        MongoClientSettings settings = MongoClientSettings$.MODULE$.builder().credential(credential).applyToClusterSettings((Block)new Block<ClusterSettings.Builder>(null, hosts){
            private final Seq hosts$1;

            public void apply(ClusterSettings.Builder builder) {
                builder.hosts(Arrays.asList((Object[])this.hosts$1.toArray(ClassTag$.MODULE$.apply(ServerAddress.class))));
            }
            {
                this.hosts$1 = hosts$1;
            }
        }).build();
        return MongoClient$.MODULE$.apply(settings);
    }

    public ConfigurationMongoModels.MongoConnectorConfig createConfig(Config config) {
        Predef$.MODULE$.require(config.hasPath(ConfigurationKeys$.MODULE$.USERNAME()));
        Predef$.MODULE$.require(config.hasPath(ConfigurationKeys$.MODULE$.PASSWORD()));
        Predef$.MODULE$.require(config.hasPath(ConfigurationKeys$.MODULE$.HOST()));
        Predef$.MODULE$.require(config.hasPath(ConfigurationKeys$.MODULE$.DATABASE()));
        Predef$.MODULE$.require(config.hasPath(ConfigurationKeys$.MODULE$.COLLECTION()));
        return new ConfigurationMongoModels.MongoConnectorConfig(config.getString(ConfigurationKeys$.MODULE$.USERNAME()), config.getString(ConfigurationKeys$.MODULE$.PASSWORD()), config.getString(ConfigurationKeys$.MODULE$.DATABASE()), config.getString(ConfigurationKeys$.MODULE$.COLLECTION()), (Seq<String>)package$.MODULE$.IterableConverter((Iterable)config.getStringList(ConfigurationKeys$.MODULE$.HOST())).toScala().toSeq(), (Duration)(config.hasPath(ConfigurationKeys$.MODULE$.TIMEOUT()) ? Duration$.MODULE$.create((long)config.getInt(ConfigurationKeys$.MODULE$.TIMEOUT()), "millis") : Duration$.MODULE$.create((long)ConfigurationMongoModels$.MODULE$.DEFAULT_DURATION(), "millis")));
    }
}

