/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.log4j;

import it.agilelab.log4j.AsyncJsonAppenderRunnable;
import it.agilelab.log4j.AsyncJsonAppenderSink;
import it.agilelab.log4j.ConfigurableAppenderSkeleton;
import it.agilelab.log4j.Configuration;
import it.agilelab.log4j.ConsoleAsyncJsonAppenderSink;
import it.agilelab.log4j.DefaultLoggingEventToJsonConverter;
import it.agilelab.log4j.InstantiationUtil;
import it.agilelab.log4j.LoggingEventBatchToJsonConverter;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.spi.LoggingEvent;

public class AsyncJsonAppender
extends ConfigurableAppenderSkeleton {
    public static String OPTION_QUEUE_CAPACITY = "queue-capacity";
    public static String OPTION_WAIT_MILLIS = "wait-millis";
    public static String OPTION_SINK_PREFIX = "sink";
    public static String OPTION_CONVERTER_PREFIX = "converter";
    private int maxCapacity;
    private BlockingQueue<LoggingEvent> events;
    private int howManyTimeUnitsToWait;
    private final AtomicLong droppedMessages = new AtomicLong();
    private final TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private final AtomicBoolean shouldRun = new AtomicBoolean(true);
    private AsyncJsonAppenderSink sink = new ConsoleAsyncJsonAppenderSink();
    private LoggingEventBatchToJsonConverter converter = new DefaultLoggingEventToJsonConverter();
    private Thread appendingThread;

    public LoggingEventBatchToJsonConverter getConverter() {
        return this.converter;
    }

    public void setConverter(LoggingEventBatchToJsonConverter converter) {
        this.converter = converter;
    }

    public AsyncJsonAppender() {
        this(true);
    }

    public AsyncJsonAppender(boolean isActive) {
        super(isActive);
    }

    @Override
    public void configure(Configuration option) {
        this.maxCapacity = option.get(OPTION_QUEUE_CAPACITY).map(Integer::parseInt).orElse(1000);
        this.howManyTimeUnitsToWait = option.get(OPTION_WAIT_MILLIS).map(Integer::parseInt).orElse(10);
        this.events = new ArrayBlockingQueue<LoggingEvent>(this.maxCapacity);
        this.sink = option.get(OPTION_SINK_PREFIX).map(InstantiationUtil.instantiate(AsyncJsonAppenderSink.class)).orElseGet(ConsoleAsyncJsonAppenderSink::new);
        this.sink.configure(option.subconfig(OPTION_SINK_PREFIX));
        this.converter = option.get(OPTION_CONVERTER_PREFIX).map(InstantiationUtil.instantiate(LoggingEventBatchToJsonConverter.class)).orElseGet(DefaultLoggingEventToJsonConverter::new);
        this.converter.configure(option.subconfig(OPTION_CONVERTER_PREFIX));
        this.appendingThread = new Thread(new AsyncJsonAppenderRunnable(this.shouldRun, this.events, this.maxCapacity, this.howManyTimeUnitsToWait, this.timeUnit, this.droppedMessages, this.sink, this.converter));
        this.appendingThread.start();
    }

    protected void append(LoggingEvent loggingEvent) {
        this.queryEventForThreadLocalData(loggingEvent);
        boolean didWeLogThat = this.events.offer(loggingEvent);
        if (!didWeLogThat) {
            this.droppedMessages.incrementAndGet();
        }
    }

    public void close() {
        this.shouldRun.set(false);
        try {
            if (this.appendingThread != null) {
                long joinTimeout = this.timeUnit.toMillis(this.howManyTimeUnitsToWait);
                this.appendingThread.interrupt();
                this.appendingThread.join(joinTimeout, 0);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    private void queryEventForThreadLocalData(LoggingEvent event) {
        event.getNDC();
        event.getThreadName();
        event.getMDCCopy();
        event.getRenderedMessage();
        event.getThrowableStrRep();
    }

    public AsyncJsonAppenderSink getSink() {
        return this.sink;
    }

    public void setSink(AsyncJsonAppenderSink sink) {
        this.sink = sink;
    }
}

