/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.log4j;

import it.agilelab.log4j.AsyncJsonAppenderSink;
import it.agilelab.log4j.BlockingQueueBatcher;
import it.agilelab.log4j.LoggingEventBatchToJsonConverter;
import it.agilelab.log4j.json.Json;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.spi.LoggingEvent;

class AsyncJsonAppenderRunnable
implements Runnable {
    private final AtomicBoolean shouldRun;
    private final BlockingQueue<LoggingEvent> events;
    private int maxEvents;
    private final int howManyTimeUnitsToWait;
    private final TimeUnit timeUnit;
    private final AtomicLong droppedEvents;
    private final AsyncJsonAppenderSink sink;
    private final LoggingEventBatchToJsonConverter converter;
    private final List<LoggingEvent> list;
    private long lastDropped;

    public AsyncJsonAppenderRunnable(AtomicBoolean shouldRun, BlockingQueue<LoggingEvent> events, int maxEvents, int howManyTimeUnitsToWait, TimeUnit timeUnit, AtomicLong droppedEvents, AsyncJsonAppenderSink sink, LoggingEventBatchToJsonConverter converter) {
        this.list = new ArrayList<LoggingEvent>(this.maxEvents);
        this.lastDropped = 0L;
        this.shouldRun = shouldRun;
        this.events = events;
        this.maxEvents = maxEvents;
        this.howManyTimeUnitsToWait = howManyTimeUnitsToWait;
        this.timeUnit = timeUnit;
        this.droppedEvents = droppedEvents;
        this.sink = sink;
        this.converter = converter;
    }

    @Override
    public void run() {
        while (this.shouldRun.get()) {
            this.list.clear();
            try {
                BlockingQueueBatcher.take(this.events, this.list, this.maxEvents, this.howManyTimeUnitsToWait, this.timeUnit);
            }
            catch (InterruptedException e) {
                this.shouldRun.set(false);
                continue;
            }
            List<Json> converted = this.converter.convert(this.list);
            this.sink.sink(converted);
            long dropped = 0L;
            dropped = this.droppedEvents.get();
            if (dropped <= this.lastDropped) continue;
            this.lastDropped = dropped;
            this.sink.dropped(dropped);
        }
        long dropped = this.droppedEvents.get();
        if (dropped > this.lastDropped) {
            this.sink.dropped(dropped);
        }
    }
}

