/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.log4j;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

class BlockingQueueBatcher {
    private BlockingQueueBatcher() {
    }

    public static <T> int take(BlockingQueue<T> queue, Collection<? super T> batch, int maxBatchSize, long maxLatency, TimeUnit maxLatencyUnit) throws InterruptedException {
        long maxLatencyNanos = maxLatencyUnit.toNanos(maxLatency);
        int curBatchSize = 0;
        long stopBatchTimeNanos = -1L;
        do {
            boolean timeout = false;
            if (stopBatchTimeNanos == -1L) {
                batch.add(queue.take());
                ++curBatchSize;
                stopBatchTimeNanos = System.nanoTime() + maxLatencyNanos;
                continue;
            }
            T element = queue.poll(stopBatchTimeNanos - System.nanoTime(), TimeUnit.NANOSECONDS);
            if (element == null) break;
            batch.add(element);
            ++curBatchSize;
        } while ((curBatchSize += queue.drainTo(batch, maxBatchSize - curBatchSize)) < maxBatchSize);
        return curBatchSize;
    }
}

