/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.log4j;

import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;

public class Configuration {
    private static final String SEPARATOR = ".";
    private final String prefix;
    private final SortedMap<String, String> options;

    public Configuration(String prefix, SortedMap<String, String> options) {
        this.prefix = prefix;
        this.options = options;
    }

    public Configuration(SortedMap<String, String> options) {
        this("", options);
    }

    public Optional<String> get(String key) {
        return Optional.ofNullable(this.options.get(this.generatekey(key)));
    }

    public Configuration subconfig(String pp) {
        String start = "";
        String end = "";
        if (pp.endsWith(SEPARATOR)) {
            start = pp;
            end = pp.substring(0, pp.length() - 1) + (char)(SEPARATOR.charAt(0) + '\u0001');
        } else {
            start = pp + SEPARATOR;
            end = pp + (char)(SEPARATOR.charAt(0) + '\u0001');
        }
        return new Configuration(this.generatekey(pp), this.options.subMap(this.generatekey(start), this.generatekey(end)));
    }

    private String generatekey(String prefix, String key) {
        if (!prefix.equals("")) {
            return prefix + SEPARATOR + key;
        }
        return key;
    }

    private String generatekey(String key) {
        return this.generatekey(this.prefix, key);
    }

    public Configuration with(String key, String value) {
        return this.with("", key, value);
    }

    public Configuration with(String prefixed, String key, String value) {
        TreeMap<String, String> newMap = new TreeMap<String, String>(this.options);
        newMap.put(this.generatekey(prefixed, key), value);
        return new Configuration(this.prefix, newMap);
    }

    public static Configuration empty() {
        return new Configuration(new TreeMap<String, String>());
    }

    public Configuration merge(Configuration other) {
        TreeMap<String, String> newMap = new TreeMap<String, String>(this.options);
        newMap.putAll(other.options);
        return new Configuration(this.prefix, newMap);
    }
}

