/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.log4j;

import it.agilelab.log4j.Configuration;
import it.agilelab.log4j.LoggingEventBatchToJsonConverter;
import it.agilelab.log4j.json.Json;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.log4j.spi.LoggingEvent;

public class DefaultLoggingEventToJsonConverter
implements LoggingEventBatchToJsonConverter {
    @Override
    public List<Json> convert(List<LoggingEvent> events) {
        return events.stream().map(this::convert).collect(Collectors.toList());
    }

    private Json convert(LoggingEvent event) {
        long epochMillisecond = event.getTimeStamp();
        String composedMessage = Optional.ofNullable(event.getRenderedMessage()).orElse("");
        Json message = Json.object().set("time", (Object)((double)epochMillisecond / 1000.0)).set("message", (Object)composedMessage).set("level", (Object)event.getLevel().toString()).set("class", (Object)event.getLoggerName()).set("thread", (Object)event.getThreadName());
        return Optional.ofNullable(event.getThrowableInformation()).map(x -> message.set("exception", (Object)this.throwableToString(event.getThrowableInformation().getThrowable())).set("hasException", (Object)true)).orElse(message);
    }

    private String throwableToString(Throwable t) {
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        t.printStackTrace(pw);
        pw.flush();
        String representation = w.toString();
        pw.close();
        return representation;
    }

    @Override
    public void configure(Configuration option) {
    }
}

