/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.log4j;

import it.agilelab.log4j.AsyncJsonAppenderSink;
import it.agilelab.log4j.Configuration;
import it.agilelab.log4j.HttpFailureStrategy;
import it.agilelab.log4j.InstantiationUtil;
import it.agilelab.log4j.LogAndIgnoreHttpFailureStrategy;
import it.agilelab.log4j.Tracing;
import it.agilelab.log4j.json.Json;
import it.agilelab.log4j.shaded.org.apache.http.HttpEntity;
import it.agilelab.log4j.shaded.org.apache.http.client.config.RequestConfig;
import it.agilelab.log4j.shaded.org.apache.http.client.entity.EntityBuilder;
import it.agilelab.log4j.shaded.org.apache.http.client.methods.CloseableHttpResponse;
import it.agilelab.log4j.shaded.org.apache.http.client.methods.HttpPost;
import it.agilelab.log4j.shaded.org.apache.http.entity.ContentType;
import it.agilelab.log4j.shaded.org.apache.http.impl.client.CloseableHttpClient;
import it.agilelab.log4j.shaded.org.apache.http.impl.client.HttpClients;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.helpers.LogLog;

public class FluentdAsyncJsonAppenderSink
implements AsyncJsonAppenderSink {
    public static final String HOST_OPTION = "host";
    public static final String TAG_OPTION = "tag";
    public static final String MAX_CONNECTIONS_TOTAL_OPTION = "max-connections-total";
    public static final String MAX_CONNECTIONS_PER_ROUTE = "max-connections-per-route";
    public static final String CONNECTION_REQUEST_TIMEOUT = "connection-request-timeout-ms";
    public static final String CONNECTION_TIMEOUT = "connection-timeout-ms";
    public static final String SOCKET_TIMEOUT = "socket-timeout-ms";
    public static final String TRANSFER_DEADLINE = "transfer-deadline-ms";
    public static final String FAILURE_STRATEGY = "failure-strategy";
    private HttpFailureStrategy failureStrategy;
    private final ScheduledExecutorService ex = Executors.newSingleThreadScheduledExecutor();
    private URI host;
    private String tag;
    private int transferDeadlineMs;
    private CloseableHttpClient httpClient;

    public FluentdAsyncJsonAppenderSink(URI host, String tag) {
        this.host = host;
        this.tag = tag;
    }

    public FluentdAsyncJsonAppenderSink() {
    }

    @Override
    public void sink(List<Json> data) {
        for (Json entry : data) {
            URI resolved = this.host.resolve(this.tag);
            HttpPost httpPost = new HttpPost(resolved);
            String rendered = Tracing.time(Tracing.Tags.RENDER_BATCH, entry::toString);
            HttpEntity entity = EntityBuilder.create().setText(rendered).gzipCompress().setContentType(ContentType.APPLICATION_JSON).build();
            httpPost.setEntity(entity);
            this.ex.schedule(httpPost::abort, (long)this.transferDeadlineMs, TimeUnit.MILLISECONDS);
            Tracing.time(Tracing.Tags.EXECUTE_REQUEST, () -> {
                try (CloseableHttpResponse response = this.httpClient.execute(httpPost);){
                    if (response.getStatusLine().getStatusCode() < 200 && response.getStatusLine().getStatusCode() >= 300) {
                        this.failureStrategy.onFailureStatus(httpPost, response);
                    } else {
                        LogLog.debug((String)("Request [" + httpPost + "] success, response: [" + httpPost + "]"));
                    }
                }
                catch (Exception e) {
                    this.failureStrategy.onException(httpPost, e);
                }
                return null;
            });
        }
    }

    @Override
    public void dropped(long dropped) {
        System.err.println("Dropped " + dropped);
    }

    @Override
    public void configure(Configuration option) {
        this.host = option.get(HOST_OPTION).map(URI::create).orElseThrow(() -> new RuntimeException("Invalid URI for host"));
        this.tag = option.get(TAG_OPTION).orElseThrow(() -> new RuntimeException("No tag supplied"));
        int maxConnectionsTotal = option.get(MAX_CONNECTIONS_TOTAL_OPTION).map(Integer::parseInt).orElse(10);
        int maxConnectionsPerRoute = option.get(MAX_CONNECTIONS_PER_ROUTE).map(Integer::parseInt).orElse(10);
        int connectionTimeout = option.get(CONNECTION_TIMEOUT).map(Integer::parseInt).orElse(1000);
        int connectionRequestTimeout = option.get(CONNECTION_REQUEST_TIMEOUT).map(Integer::parseInt).orElse(1000);
        int socketTimeout = option.get(SOCKET_TIMEOUT).map(Integer::parseInt).orElse(1000);
        this.transferDeadlineMs = option.get(TRANSFER_DEADLINE).map(Integer::parseInt).orElse(1000);
        this.failureStrategy = option.get(FAILURE_STRATEGY).map(InstantiationUtil.instantiate(HttpFailureStrategy.class)).orElseGet(LogAndIgnoreHttpFailureStrategy::new);
        this.httpClient = HttpClients.custom().setMaxConnTotal(maxConnectionsTotal).setMaxConnPerRoute(maxConnectionsPerRoute).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(connectionRequestTimeout).setSocketTimeout(socketTimeout).build()).build();
    }
}

