/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.log4j;

import java.util.function.Function;

public class InstantiationUtil {
    public static <T> Function<String, T> instantiate(Class<T> expectedInterface) {
        return className -> {
            try {
                Class<?> clazz = Class.forName(className);
                if (expectedInterface.isAssignableFrom(clazz)) {
                    return expectedInterface.cast(clazz.newInstance());
                }
                throw new RuntimeException(className + " is not assignable to " + expectedInterface.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Cannot find class " + className, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot access " + className, e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Cannot instantiate " + className, e);
            }
        };
    }
}

