/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.log4j;

import java.io.IOException;
import java.io.StringReader;
import java.util.Objects;
import java.util.Properties;

public class OptionParser {
    public static Option parse(String input) throws IOException {
        Properties props = new Properties();
        props.load(new StringReader(input));
        if (props.size() != 1) {
            throw new IOException("Expected only one key");
        }
        return props.entrySet().stream().findFirst().map(x -> new Option((String)x.getKey(), (String)x.getValue())).get();
    }

    static class Option {
        private final String key;
        private final String value;

        private Option(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return "Option{key='" + this.key + '\'' + ", value='" + this.value + '\'' + '}';
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Option option = (Option)o;
            return Objects.equals(this.key, option.key) && Objects.equals(this.value, option.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }
    }
}

