/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.log4j;

import it.agilelab.log4j.Configuration;
import it.agilelab.log4j.DefaultLoggingEventToJsonConverter;
import it.agilelab.log4j.InstantiationUtil;
import it.agilelab.log4j.LoggingEventBatchToJsonConverter;
import it.agilelab.log4j.Tracing;
import it.agilelab.log4j.json.Json;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.spi.LoggingEvent;

public class RequestSizeBatchingLoggingEventToJsonConverter
implements LoggingEventBatchToJsonConverter {
    private LoggingEventBatchToJsonConverter downstream;
    public static String OPTION_MAX_REQUEST_SIZE_BYTES = "max-request-size-bytes";
    public static String OPTION_DOWNSTREAM_CONVERTER_CLASS = "downstream";
    private int maxRequestSizeBytes;

    @Override
    public List<Json> convert(List<LoggingEvent> events) {
        List converted = Tracing.time(Tracing.Tags.CONVERT_ALL, () -> this.downstream.convert(events));
        ArrayList target = new ArrayList();
        return Tracing.time(Tracing.Tags.BUILD_BATCH, () -> {
            Json array = Json.array();
            long currentSize = 0L;
            for (Json json : converted) {
                Json capture = array = array.add(json);
                currentSize = Tracing.time(Tracing.Tags.CONVERT_ESTIMATION, () -> {
                    capture.resetSizeEstimation();
                    return capture.estimateSize();
                });
                if (currentSize <= (long)this.maxRequestSizeBytes) continue;
                target.add(array);
                array = Json.array();
                currentSize = 0L;
            }
            if (currentSize > 0L) {
                target.add(array);
            }
            return target;
        });
    }

    @Override
    public void configure(Configuration option) {
        this.maxRequestSizeBytes = option.get(OPTION_MAX_REQUEST_SIZE_BYTES).map(Integer::parseInt).orElse(0x400000);
        this.downstream = option.get(OPTION_DOWNSTREAM_CONVERTER_CLASS).map(InstantiationUtil.instantiate(LoggingEventBatchToJsonConverter.class)).orElse(new DefaultLoggingEventToJsonConverter());
        this.downstream.configure(option.subconfig(OPTION_DOWNSTREAM_CONVERTER_CLASS));
    }
}

