/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.log4j;

import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.log4j.helpers.LogLog;

public class Tracing {
    private static final Set<Tag> ENABLED_TAGS = new HashSet<Tag>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, E extends Throwable> R time(Tag tag, TracingConsumer<R, E> action) throws E {
        Instant start = Instant.now();
        if (ENABLED_TAGS.contains(tag)) {
            LogLog.debug((String)String.format("%s [%s] - start", start.toString(), tag.getValue()));
        }
        R result = null;
        try {
            result = action.consume();
        }
        catch (Throwable throwable) {
            Instant end = Instant.now();
            if (ENABLED_TAGS.contains(tag)) {
                LogLog.debug((String)String.format("%s [%s] - end %s", end.toString(), tag.getValue(), Duration.between(start, end).toMillis()));
            }
            throw throwable;
        }
        Instant end = Instant.now();
        if (ENABLED_TAGS.contains(tag)) {
            LogLog.debug((String)String.format("%s [%s] - end %s", end.toString(), tag.getValue(), Duration.between(start, end).toMillis()));
        }
        return result;
    }

    @FunctionalInterface
    public static interface TracingConsumer<R, E extends Throwable> {
        public R consume() throws E;
    }

    public static class Tags {
        public static Tag CONVERT_ALL = new Tag("convert-all");
        public static Tag CONVERT_ESTIMATION = new Tag("convert-estimation");
        public static Tag SERIALIZE_ONE = new Tag("serialize-one");
        public static Tag SERIALIZE_ALL = new Tag("serialize-all");
        public static Tag BUILD_BATCH = new Tag("build-batch");
        public static Tag CONVERT_ONE = new Tag("convert-one");
        public static Tag RENDER_BATCH = new Tag("render-batch");
        public static Tag EXECUTE_REQUEST = new Tag("execute-request");
    }

    private static class Tag {
        private final String value;

        public Tag(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tag tag = (Tag)o;
            return Objects.equals(this.value, tag.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

