/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.log4j.shaded.org.apache.http.protocol;

import it.agilelab.log4j.shaded.org.apache.http.HttpEntity;
import it.agilelab.log4j.shaded.org.apache.http.HttpEntityEnclosingRequest;
import it.agilelab.log4j.shaded.org.apache.http.HttpException;
import it.agilelab.log4j.shaded.org.apache.http.HttpRequest;
import it.agilelab.log4j.shaded.org.apache.http.HttpRequestInterceptor;
import it.agilelab.log4j.shaded.org.apache.http.HttpVersion;
import it.agilelab.log4j.shaded.org.apache.http.ProtocolVersion;
import it.agilelab.log4j.shaded.org.apache.http.annotation.Contract;
import it.agilelab.log4j.shaded.org.apache.http.annotation.ThreadingBehavior;
import it.agilelab.log4j.shaded.org.apache.http.protocol.HttpContext;
import it.agilelab.log4j.shaded.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

