/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.aws.auth.v2;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialsSerde {
    private static Logger log = LoggerFactory.getLogger(CredentialsSerde.class);

    private static void writeSessionCredentials(AWSSessionCredentials aWSSessionCredentials, OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.write("SESSION");
        outputStreamWriter.write("\n");
        outputStreamWriter.write(aWSSessionCredentials.getAWSAccessKeyId());
        outputStreamWriter.write("\n");
        outputStreamWriter.write(aWSSessionCredentials.getAWSSecretKey());
        outputStreamWriter.write("\n");
        outputStreamWriter.write(aWSSessionCredentials.getSessionToken());
        outputStreamWriter.flush();
    }

    private static void writeCredentials(AWSCredentials aWSCredentials, OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.write("PLAIN");
        outputStreamWriter.write("\n");
        outputStreamWriter.write(aWSCredentials.getAWSAccessKeyId());
        outputStreamWriter.write("\n");
        outputStreamWriter.write(aWSCredentials.getAWSSecretKey());
        outputStreamWriter.write("\n");
        outputStreamWriter.flush();
    }

    public static void write(Configuration configuration, Path path, AWSCredentials aWSCredentials, String string) {
        try {
            FileSystem fileSystem = path.getFileSystem(configuration);
            fileSystem.mkdirs(path);
            Path path2 = new Path(path, string);
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileSystem.create(path2, true), StandardCharsets.UTF_8);){
                if (aWSCredentials instanceof AWSSessionCredentials) {
                    CredentialsSerde.writeSessionCredentials((AWSSessionCredentials)aWSCredentials, outputStreamWriter);
                } else {
                    CredentialsSerde.writeCredentials(aWSCredentials, outputStreamWriter);
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot write credentials", iOException);
        }
    }

    public static AWSCredentials read(FileSystem fileSystem, Path path) throws IOException {
        String string;
        log.info("Getting executor credentials");
        String string2 = "";
        RemoteIterator remoteIterator = fileSystem.listFiles(path, false);
        while (remoteIterator.hasNext()) {
            string = ((LocatedFileStatus)remoteIterator.next()).getPath().getName();
            if (string.compareTo(string2) <= 0) continue;
            string2 = string;
        }
        log.info("SELECTED " + string2);
        string = new Path(path, string2);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileSystem.open((Path)string), StandardCharsets.UTF_8));){
            String string3 = bufferedReader.readLine();
            if (string3.equals("SESSION")) {
                final String string4 = bufferedReader.readLine();
                final String string5 = bufferedReader.readLine();
                final String string6 = bufferedReader.readLine();
                AWSSessionCredentials aWSSessionCredentials = new AWSSessionCredentials(){

                    public String getAWSAccessKeyId() {
                        return string4;
                    }

                    public String getAWSSecretKey() {
                        return string5;
                    }

                    public String getSessionToken() {
                        return string6;
                    }
                };
                return aWSSessionCredentials;
            }
            final String string7 = bufferedReader.readLine();
            final String string8 = bufferedReader.readLine();
            AWSCredentials aWSCredentials = new AWSCredentials(){

                public String getAWSAccessKeyId() {
                    return string7;
                }

                public String getAWSSecretKey() {
                    return string8;
                }
            };
            return aWSCredentials;
        }
    }

    public static void cleanupOldCredentials(Configuration configuration, Path path) throws IOException {
        FileSystem fileSystem = path.getFileSystem(configuration);
        if (fileSystem.exists(path)) {
            Object object;
            RemoteIterator remoteIterator = fileSystem.listFiles(path, false);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (remoteIterator.hasNext()) {
                object = ((LocatedFileStatus)remoteIterator.next()).getPath().getName();
                arrayList.add((String)object);
            }
            object = arrayList.stream().sorted().limit(Math.max(0, arrayList.size() - 5)).collect(Collectors.toList());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                fileSystem.delete(new Path(path, string), false);
            }
        }
    }
}

